/* TABLIX, PGA highschool timetable generator                              */
/* Copyright (C) 2002-2004 Tomaz Solc                                      */

/* This program is free software; you can redistribute it and/or modify    */
/* it under the terms of the GNU General Public License as published by    */
/* the Free Software Foundation; either version 2 of the License, or       */
/* (at your option) any later version.                                     */

/* This program is distributed in the hope that it will be useful,         */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/* GNU General Public License for more details.                            */

/* You should have received a copy of the GNU General Public License       */
/* along with this program; if not, write to the Free Software             */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA */

/* $Id: student_perday.c,v 1.7 2004/10/17 09:37:05 avian Exp $ */

/* 
 * AUTHOR:
 *  
 *  Tomaz Solc <tomaz.solc@siol.net>
 *
 * DESCRIPTION:
 *
 *  Calculates weekly dispersion of non-free periods for classes. Number of 
 *  added weights is equal to the sum of dispersions for all classes.
 *
 *  This module tries to ensure that students have their work evenly 
 *  distributed throughout the week. For example: This module would add zero 
 *  weights if a class has 5 non-free periods on each day of the week. On the 
 *  other hand, it would add 2 weights if this class has 6 non-free periods on
 *  monday, 4 on tuesday and 5 on wednesday, thursday and friday. This is done
 *  by calculating mathematical dispersion of non-free periods through the 
 *  weekdays.
 *
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdlib.h>
#include "modsup.h"
#include "data.h"
#include "gettext.h"

int *perday;

int precalc_mod()
{
	int c;
	perday=malloc(sizeof(*perday)*cmapnum);

	for(c=0;c<cmapnum;c++) perday[c]=0;

	for(c=0;c<tuplenum;c++) {
		perday[tuplemap[c].cid]++;
	}

	for(c=0;c<cmapnum;c++) perday[c]=perday[c]/DAYS;

	return(0);
}

int grade_function(chromo *t, int *cpnt, int *tpnt, int **start, int **lead)
{
	int a,b,c,e;
	int sum;

	sum=0;
        for(c=0;c<cmapnum;c++) {
                for(a=0;a<DAYS;a++) {
			e=0;
                        b=0;
                        while (b<PERIODS) {
                                if (*cpnt!=-1) 
					if (tuplemap[*cpnt].cid==c) e++;
                                b++;
				cpnt++;
                        }

			e=e-perday[c];

			sum=sum+e*e;
		}
        };
	return(sum);
	      
}
