/* TABLIX, PGA highschool timetable generator                              */
/* Copyright (C) 2002 Tomaz Solc                                           */

/* This program is free software; you can redistribute it and/or modify    */
/* it under the terms of the GNU General Public License as published by    */
/* the Free Software Foundation; either version 2 of the License, or       */
/* (at your option) any later version.                                     */

/* This program is distributed in the hope that it will be useful,         */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/* GNU General Public License for more details.                            */

/* You should have received a copy of the GNU General Public License       */
/* along with this program; if not, write to the Free Software             */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA */

/* $Id: placecapability.c,v 1.6 2004/10/17 09:37:05 avian Exp $ */

/* 
 * AUTHOR:
 *
 *  Tomaz Solc <tomaz.solc@siol.net>
 *
 * DESCRIPTION:
 *
 *  Adds a weight whenever a subject-teacher pair is scheduled in a classroom 
 *  that does not have the neccessary capabilities.
 *
 * DEFINED ROOM RESTRICTIONS:
 *
 *  <capability type="capability-place">capability</capability>
 *
 * DEFINED SUBJECT RESTRICTIONS:
 *
 *  <restriction type="capability-place">capability</restriction>
 *
 *  This restriction specifies that this subject-teacher pair should only be 
 *  scheduled in a classroom that has the requested capability.
 *  
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "modsup.h"
#include "data.h"
#include "gettext.h"

int **roomok;

struct _cap {
        char **caplist;    /* list of capabilites this classroom has */
        int capnum;
};

typedef struct _cap cap;

cap **caps;

int hascap(int rid, char *cap)
{
	int c;

	for(c=0;c<caps[rid]->capnum;c++) {
		if (!strcmp(caps[rid]->caplist[c], cap)) return(1);
	}

	return(0);
}

int getcapability(char *type, char *cont, int rid)
{
	caps[rid]->caplist[caps[rid]->capnum]=malloc(sizeof(char)*(strlen(cont)+1));

	strcpy(caps[rid]->caplist[caps[rid]->capnum], cont);

	caps[rid]->capnum++;

	return 0;
}

int getrestriction(char *type, char *cont, int sid)
{
	int c;

	for(c=0;c<rmapnum;c++) {
		/* room is OK only if it was OK   */
		/* previously and matches our new */
		/* criteria                       */

		roomok[sid][c]=roomok[sid][c]&&hascap(c, cont);
	
	}
	return 0;
}

parop room_restrictions[] = { 
	{ type : "capability-place", parfunc: getcapability },
	{ type : 0, parfunc: 0 }
};

parop subject_restrictions[] = {
	{ type : "capability-place", parfunc: getrestriction },
	{ type : 0, parfunc: 0 }
};

int init_mod()
{
	int c,b;

	roomok=malloc(sizeof(*roomok)*smapnum);

	for(c=0;c<smapnum;c++) {
		roomok[c]=malloc(sizeof(*roomok[c])*rmapnum);
		for(b=0;b<rmapnum;b++) {
			roomok[c][b]=1;
		}
	}

	caps=malloc(sizeof(*caps)*rmapnum);

	for(c=0;c<rmapnum;c++) {
		caps[c]=malloc(sizeof(*caps[c]));
		caps[c]->caplist=malloc(sizeof(*caps[c]->caplist)*MAXCAP);
		caps[c]->capnum=0;
	}
	
	return 0;
}

int grade_function(chromo *t, int *cpnt, int *tpnt, int **start, int **lead)
{
	int c;
	int sum;

	sum=0;

        for(c=0;c<tuplenum;c++) {
        	if (!roomok[tuplemap[c].sid][t->inf[c].room]) sum++;
        }

	return(sum);
}
