C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                       *****************
                        SUBROUTINE MAILFF
C                       *****************
C
C     ---------------------------------------------------------
     *(NDIM,NPOINF,NELEBF,XYZF,NBCOUF,NELESF,NDMASF,NBRAF,NELRAF,
     * NREFAF,COORDF,NODEBF,NODESF,NCOUPF,COORAF,NRAPF,NODRAF,
     * NPOIFF,ICOLA,ITRAV,
     * NBFILS,NWMAIL,NWDN,NWDRN,NWDE,NWDRE,
     * NWNCF1,NWNRF1,NWECF1,NWERF1,NWDMA1)
C     ---------------------------------------------------------
C
C***********************************************************************
C* SYRTHES 2.0                              JUIL 93 COPYRIGHT EDF 1993 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C                                                                      *
C   FONCTION :                                                         *
C   --------                                                           *
C              MAILLAGE FLUIDE TYPE N3S-NATUR                          *
C                                                                      *
C-----------------------------------------------------------------------
C               (*)   (*)                 ARGUMENTS
C   .________.______.____._____________________________________________.
C   !  NOM   ! TYPE !MODE!                  ROLE                       !
C   !________!______!____!_____________________________________________!
C   ! NDIM   !  TE  ! E  ! Dimension du probleme (2 pour 2D, 3 pour 3D)! 
C   ! NBCOUF !  E   ! D  ! Nombre de points fluides couples            !
C   ! NBRAF  !  E   ! D  ! Nombre de points fluides non couples + rayt !
C   ! NPOINF !  E   ! D  ! Nombre de points fluide total               !
C   ! COORDF !  TR  ! M  ! Coordonnes des points fluides couples       !
C   ! COORAF !  TR  ! M  ! Coordonnes des pts fluides non couples+rayt !
C   !________!______!____!_____________________________________________!
C   ! COMMONS                                                          !
C   !__________________________________________________________________!
C   !/OPTCT/ !      ! D  !                                             !
C   !/FICHCT/!      ! D  !                                             !
C   !/XREFER/!      ! D  ! 
C   !________!______!____!_____________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : ---
C                                   
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) :  
C
C***********************************************************************
C
      IMPLICIT NONE
C
C**********************************************************************
C     DONNEES EN COMMON
C**********************************************************************
C
#include "xrefer.h"
#include "optct.h"
#include "nlofes.h"
C
C**********************************************************************
C
C.. Variables externes
      INTEGER NDIM,NPOINF,NBCOUF,NBRAF
      INTEGER NELEBF,NELESF,NDMASF,NELRAF,NPOIFF
      INTEGER NODESF(NELESF,NDMASF), NODEBF(NELEBF,NDMASF)
      INTEGER NODRAF(NELRAF,NDMASF)
      INTEGER NCOUPF(NBCOUF,2),NRAPF(NBRAF,2)
      INTEGER NREFAF(NELEBF),ICOLA(NPOIFF),ITRAV(NPOIFF)
      INTEGER NBFILS,NWMAIL,NWDN,NWDRN,NWDE,NWDRE,NWDMA1
      INTEGER NWNCF1,NWNRF1,NWECF1,NWERF1
      DOUBLE PRECISION XYZF(NPOINF,NDIM)
      DOUBLE PRECISION COORDF(NBCOUF,NDIM),COORAF(NBRAF,NDIM)
C
C.. Variables internes
      INTEGER N,M,NC,NR,NE,NY,NUMREF,N1
C
C**********************************************************************
C
      IF (NWMAIL.EQ.1) THEN
        DO N=1,NELESF*NDMASF
         NODESF(N,1) = 0
        ENDDO
C
        DO N=1,NELRAF*NDMASF
         NODRAF(N,1) = 0
        ENDDO
      ENDIF
C
      DO N=1,NPOIFF
       ITRAV(N)=0
      ENDDO
C
      DO N=NWDN,NWDN+NWNCF1-1
        NCOUPF(N,1) = 0
        NCOUPF(N,2) = 0
      ENDDO
C
      DO N=NWDRN,NWDRN+NWNRF1-1
        NRAPF(N,1) = 0
        NRAPF(N,2) = 0
      ENDDO
C
C     1- TABLE DES ELEMENTS FLUIDES COUPLES
C     =====================================
C
      NE = NWDE-1
      NY = NWDRE-1

      DO N=1,NELEBF
        NUMREF = NREFAF(N)
        IF (NUMREF.NE.0) THEN
          DO N1=1,NRFMAX
           IF (NUMREF.EQ.N1) THEN
            IF (IREFFC(N1).NE.0 .AND. IREFRF(N1).NE.0)  THEN
               NE=NE+1
               NY=NY+1
               DO M=1,NWDMA1
                  ITRAV(NODEBF(N,M))=3
                  NODESF(NE,M) = NODEBF(N,M)
                  NODRAF(NY,M) = NODRAF(N,M)
               ENDDO
            ELSEIF (IREFFC(N1).NE.0)  THEN
               NE=NE+1
               DO M=1,NWDMA1
                  ITRAV(NODEBF(N,M))=1
                  NODESF(NE,M) = NODEBF(N,M)
               ENDDO
            ELSEIF (IREFRF(N1).NE.0)  THEN
               NY=NY+1
               DO M=1,NWDMA1
                  NODRAF(NY,M) = NODEBF(N,M)
                  ITRAV(NODEBF(N,M))=2
               ENDDO
            ENDIF
           ENDIF
          ENDDO
       ENDIF
      ENDDO
C
C     2 noeuds fluides couples
C     ========================
      NC = NWDN-1
      NR = NWDRN-1
C
C
      DO N=1,NPOIFF
        IF (ITRAV(N).EQ.1) THEN
          NC = NC + 1
          COORDF(NC,1)=XYZF(ICOLA(N),1)
          COORDF(NC,2)=XYZF(ICOLA(N),2)
          IF (NDIM.EQ.3) COORDF(NC,3)=XYZF(ICOLA(N),3)
           NCOUPF(NC,1) = N
        ELSEIF (ITRAV(N).EQ.2) THEN
          NR = NR + 1
          COORAF(NR,1)=XYZF(ICOLA(N),1)
          COORAF(NR,2)=XYZF(ICOLA(N),2)
          IF (NDIM.EQ.3) COORAF(NR,3)=XYZF(ICOLA(N),3)
          NRAPF(NR,1) = N
        ELSEIF (ITRAV(N).EQ.3) THEN
          NC = NC + 1
          COORDF(NC,1)=XYZF(ICOLA(N),1)
          COORDF(NC,2)=XYZF(ICOLA(N),2)
          IF (NDIM.EQ.3) COORDF(NC,3)=XYZF(ICOLA(N),3)
          NR = NR + 1
          COORAF(NR,1)=XYZF(ICOLA(N),1)
          COORAF(NR,2)=XYZF(ICOLA(N),2)
          IF (NDIM.EQ.3) COORAF(NR,3)=XYZF(ICOLA(N),3)
          NCOUPF(NC,1) = N
          NRAPF(NR,1) = N
       ENDIF
      ENDDO
C
C     3  numerotation locale pour les elements
C     ========================================
C
      DO N=1,NPOIFF
       ITRAV(N)=0
      ENDDO
C
      DO N=NWDN,NWDN+NWNCF1-1
         ITRAV(NCOUPF(N,1)) = N
      ENDDO
C
      DO M=1,NWDMA1
         DO N=NWDE,NWDE+NWECF1-1
           NODESF(N,M) = ITRAV (NODESF(N,M))
         ENDDO
      ENDDO
C
      DO N=1,NPOIFF
       ITRAV(N)=0
      ENDDO
C
      DO N=NWDRN,NWDRN+NWNRF1-1
         ITRAV(NRAPF(N,1)) = N
      ENDDO
C
      DO M=1,NWDMA1
         DO N=NWDRE,NWDRE+NWERF1-1
           NODRAF(N,M) = ITRAV (NODRAF(N,M))
         ENDDO
      ENDDO
C
C     4 Controles
C     ===========
C
      IF (NWMAIL.EQ.NBFILS .AND.
     *     (NC.NE.NBCOUF .OR. NR.NE.NBRAF .OR.
     *      NE.NE.NELESF .OR. NY.NE.NELRAF))  THEN
         WRITE(NFECRA,4000) NC,NBCOUF,NR,NBRAF,NE,NELESF,NY,NELRAF
         STOP
      ENDIF
C
C--------
C FORMATS
C--------
 4000 FORMAT(/,' %% ERREUR MAILFF : lors de la lecture des coordonnees'
     &        ,' pour le(s) fluide(s). On trouve :',/,
     &         20X,I6,' noeuds couples au lieu de ',I6,/,
     &         20X,I6,' noeuds avec rayonnement au lieu de ',I6,/,
     &         20X,I6,' elements couples au lieu de ',I6,/,
     &         20X,I6,' elements avec rayonnement au lieu de ',I6 )
C
C
      END











