C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                       *****************
                        SUBROUTINE LECSI1
C                       *****************
C
C     --------------------
     *(NPOINS,NELEMS,NT5)
C     --------------------
C
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C FONCTION :                                                           *
C ----------                                                           *
C             1ere LECTURE DU MAILLAGE ELEMENTS FINIS                  *
C             --> STRUCTURE DE DONNEE ISSUE DE SIMAIL                  *
C             (Necessaire pour les dimensionnements de tableaux)       *
C                                                                      *
C             Modifications par Y. Fournier pour prendre en compte     *
C             les aspects binaires Linux                               *
C                                                                      *
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !  A        ! TR ! A  ! TABLEAU DE TRAVAIL REEL                      !
C !  ILONRA   !  E ! D  ! DIMENSION DE A                               !
C !  IA       ! TE ! A  ! TABLEAUX DE TRAVAIL ENTIER                   !
C !  ILONIA   !  E ! D  ! DIMENSION DE IA                              !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !____________________________________________________________________!
C ! /XREFER/  !    ! D  !                                              !
C ! /NLOFES/  !    ! D  !                                              !
C ! /NLOFCT/  !    ! D  !                                              !
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : LCOODP,CMPTNO,CMPTEL,CMPTFA,INREFA
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) :
C
C***********************************************************************
C
      IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON  
C **********************************************************************
C
#include "nlofes.h"
#include "nlofct.h"
#include "xrefer.h"
C
C***********************************************************************
C
C.. Variables externes
      INTEGER NPOINS,NELEMS,NT5
C
C.. Variables internes
      INTEGER I,NDIMEF,NDSR,NDSD,NCOPNP,M(32),LE
#ifdef HAVE_C_IO
      INTEGER   NBRLUS,NBRTOT,IERROR
      CHARACTER MSGIER*80
#endif /* HAVE_C_IO */
C***********************************************************************
C
C     1- LECTURE DE L'ENREGISTREMENT AVANT LE TABLEAU 0
C     =================================================
C     Lecture du tableau "-1"
C
#ifdef HAVE_C_IO
      NBRLUS = 0
      CALL READBF (NFSGCT, 4, 1, 1, NBRLUS, NBRTOT, LE, IERROR)
      IF (IERROR .NE. 0) GOTO 998
      CALL READBF (NFSGCT, 4, LE, 1, NBRLUS, NBRTOT, M, IERROR)
      IF (IERROR .NE. 0) GOTO 998
      IF (NBRLUS .LT. NBRTOT) THEN
         CALL READBF (NFSGCT, 4, 0, 2, NBRLUS, NBRTOT, 0, IERROR)
         IF (IERROR .NE. 0) GOTO 998
      ENDIF
#else
      REWIND (NFSGCT)
      READ (NFSGCT,ERR=999) LE, (M(I), I=1,LE)
#endif
      NT5 = M(7)
C
C     2- LECTURE DU TABLEAU 0
C     =======================
#ifdef HAVE_C_IO
      NBRLUS = 0
      CALL READBF (NFSGCT, 4, 1, 1, NBRLUS, NBRTOT, LE, IERROR)
      IF (IERROR .NE. 0) GOTO 998
      CALL READBF (NFSGCT, 4, LE, 1, NBRLUS, NBRTOT, M, IERROR)
      IF (IERROR .NE. 0) GOTO 998
      IF (NBRLUS .LT. NBRTOT) THEN
         CALL READBF (NFSGCT, 4, 0, 2, NBRLUS, NBRTOT, 0, IERROR)
         IF (IERROR .NE. 0) GOTO 998
      ENDIF
#else
      READ (NFSGCT,ERR=999) LE, (M(I), I=1,LE)
#endif
C
cc CIR : incompatible dans l'etat sur DEC
cc            C = CHAR4(M(29))
cc            IF (C.NE.'NOPO') THEN
cc               WRITE(NFECRA,1000)
cc               CLOSE(NFSGCT)
cc               STOP
cc            ENDIF
            IF (M(32).NE.0) THEN
               WRITE(NFECRA,1023)
               STOP
            ENDIF
C
C     3- LECTURE DU TABLEAU 2
C     =======================
#ifdef HAVE_C_IO
      NBRLUS = 0
      CALL READBF (NFSGCT, 4, 1, 1, NBRLUS, NBRTOT, LE, IERROR)
      IF (IERROR .NE. 0) GOTO 998
      CALL READBF (NFSGCT, 4, LE, 1, NBRLUS, NBRTOT, M, IERROR)
      IF (IERROR .NE. 0) GOTO 998
      IF (NBRLUS .LT. NBRTOT) THEN
         CALL READBF (NFSGCT, 4, 0, 2, NBRLUS, NBRTOT, 0, IERROR)
         IF (IERROR .NE. 0) GOTO 998
      ENDIF
#else
      READ(NFSGCT,ERR=999) LE,(M(I),I=1,LE)
#endif
C
      NDIMEF = M(1)
      NDSR = M(2)
      NDSD = M(3)
      NCOPNP = M(4)
      NELEMS = M(5)
      NPOINS = M(15)
C

C     4- VERIFICATIONS DIVERSES
C     =========================
C
cc          IF (NDIMEF.EQ.2 .AND. NDIELE.NE.2) THEN
cc             WRITE(NFECRA,1018)
cc             STOP
cc          ENDIF
C
      IF (NDSR.GT.NRFMAX) THEN
         WRITE(NFECRA,1020)
         STOP
      ENDIF
      IF (NDSD.GT.NRFMAX) THEN
         WRITE(NFECRA,1021)
         STOP
      ENDIF
C     
      IF (NCOPNP.NE.0) THEN
         WRITE(NFECRA,1022)
         STOP
      ENDIF
C     
      IF ( M(7).NE.0 .OR. M(9).NE.0 .OR. M(11).NE.0 
     &     .OR. M(12).NE.0 .OR. M(13).NE.0 ) THEN
         WRITE(NFECRA,1023)
         STOP
      ENDIF
C     
      RETURN
#ifdef HAVE_C_IO
 998  CONTINUE
      CALL STREBF (MSGIER, LEN(MSGIER), IERROR)
      WRITE(NFECRA,9998) MSGIER
      STOP
#else
 999  CONTINUE
      WRITE(NFECRA,9999)
      STOP
#endif
C
C--------
C FORMATS
C--------
C 
 1000 FORMAT('  %% ERREUR LECSI1 : LE FICHIER NE CONTIENT PAS UNE S.D.',
     &       ' DE MAILLAGE ')
 1020 FORMAT('  %% ERREUR LECSI1 : NUMERO(S) DE REFERENCES > 99')      
 1021 FORMAT('  %% ERREUR LECSI1 : NUMERO(S) DE SOUS-DOMAINES > 99')      
 1022 FORMAT('  %% ERREUR LECSI1 : LE MAILLAGE NE POSSEDE PAS DE'
     &                             ,' NOEUDS MILIEUX')      
 1023 FORMAT('  %% ERREUR LECSI1 : UTILISATION D''ELEMENTS ',
     &                              'NON CONFORMES')
#ifdef HAVE_C_IO
 9998 FORMAT(' %% ERREUR LECSI1 : erreur de lecture du maillage ',
     *       ' solide',/,'    de type : ',A)
#else
 9999 FORMAT(' %% ERREUR LECSI1 : erreur de lecture du maillage ',
     *       ' solide')
#endif
C 
      END

