; Script generated by the HM NIS Edit Script Wizard.
; Modified by Ikuya Awashiro <ikuya@fruitsbasket.info>
; Modified by Hiroyuki Yamamoto <hiro-y@kcn.ne.jp>

; This script requires NsProcess plugin:
; http://nsis.sourceforge.net/NsProcess_plugin

!include "sylpheed-defs.nsh"

SetCompressor /SOLID lzma

!include "nsProcess.nsh"
!include "Memento.nsh"

; MUI 1.67 compatible ------
!include "MUI.nsh"
!include "Sections.nsh"
!include "LogicLib.nsh"

; MUI Settings
!define MUI_ABORTWARNING
!define MUI_ICON "${NSISDIR}\Contrib\Graphics\Icons\modern-install-blue.ico"
!define MUI_UNICON "${NSISDIR}\Contrib\Graphics\Icons\modern-uninstall-blue.ico"

; Welcome page
!insertmacro MUI_PAGE_WELCOME
; License page
!define MUI_LICENSEPAGE_RADIOBUTTONS
!insertmacro MUI_PAGE_LICENSE $(license)
; Components page
!insertmacro MUI_PAGE_COMPONENTS
; Directory page
!insertmacro MUI_PAGE_DIRECTORY
; Instfiles page
!insertmacro MUI_PAGE_INSTFILES
; Finish page
;!define MUI_FINISHPAGE_RUN "$INSTDIR\sylpheed.exe"
;!define MUI_FINISHPAGE_RUN_NOTCHECKED
!define MUI_FINISHPAGE_SHOWREADME "$INSTDIR\README.txt"
;!define MUI_FINISHPAGE_SHOWREADME "$INSTDIR\README-win32.txt"
;!define MUI_FINISHPAGE_SHOWREADME "$INSTDIR\README-win32-ja.txt"
!define MUI_FINISHPAGE_SHOWREADME_FUNCTION "ShowReadme"
!define MUI_FINISHPAGE_SHOWREADME_TEXT "$(readme)"
!define MUI_FINISHPAGE_LINK "$(jump)"
!define MUI_FINISHPAGE_LINK_LOCATION ${PRODUCT_WEB_SITE}
!insertmacro MUI_PAGE_FINISH

; Uninstaller pages
!insertmacro MUI_UNPAGE_WELCOME
!insertmacro MUI_UNPAGE_CONFIRM
!insertmacro MUI_UNPAGE_COMPONENTS
!insertmacro MUI_UNPAGE_INSTFILES
!insertmacro MUI_UNPAGE_FINISH

; Language files
!insertmacro MUI_LANGUAGE "English" # ${LANG_ENGLISH}
!insertmacro MUI_LANGUAGE "Spanish" # ${LANG_SPANISH}
!insertmacro MUI_LANGUAGE "Japanese" # ${LANG_JAPANESE}

; Reserve files
!insertmacro MUI_RESERVEFILE_INSTALLOPTIONS
ReserveFile "${NSISDIR}\Plugins\nsProcess.dll"

; MUI end ------

!include "English.nsh"
!include "Spanish.nsh"
!include "Japanese.nsh"

Var ISSILENT

;Name "${PRODUCT_NAME} ${PRODUCT_VERSION}"
;OutFile "${PRODUCT_NAME}-${PRODUCT_VERSION}_setup.exe"
Name "${INST_NAME} ${INST_VERSION}"
OutFile "${INST_FILENAME}-${INST_VERSION}_setup.exe"
InstallDir "$PROGRAMFILES\${PRODUCT_NAME}"
InstallDirRegKey HKLM "${PRODUCT_DIR_REGKEY}" ""
RequestExecutionLevel admin
ShowInstDetails hide
ShowUnInstDetails hide
XPStyle on
BrandingText "${INST_NAME} ${INST_VERSION}"

${MementoSection} "!Sylpheed" sec_sylpheed
  SetShellVarContext all
  SectionIn RO
  SetOutPath "$INSTDIR"
  File /r "Sylpheed\"
  CreateDirectory "$SMPROGRAMS\${PRODUCT_NAME}"
  ${If} $LANGUAGE = "${LANG_JAPANESE}"
    CreateShortCut "$SMPROGRAMS\${PRODUCT_NAME}\Sylpheed Manual.lnk" "$INSTDIR\doc\manual\ja\Sylpheed.html"
    CreateShortCut "$SMPROGRAMS\${PRODUCT_NAME}\README.lnk" "$INSTDIR\README-win32-ja.txt"
    File /oname=README.txt "Sylpheed\README-win32-ja.txt"
  ${ElseIf} $LANGUAGE = "${LANG_SPANISH}"
    CreateShortCut "$SMPROGRAMS\${PRODUCT_NAME}\Sylpheed Manual.lnk" "$INSTDIR\doc\manual\en\Sylpheed.html"
    CreateShortCut "$SMPROGRAMS\${PRODUCT_NAME}\README.lnk" "$INSTDIR\README-win32-es.txt"
    File /oname=README.txt "Sylpheed\README-win32-es.txt"
  ${Else}
    CreateShortCut "$SMPROGRAMS\${PRODUCT_NAME}\Sylpheed Manual.lnk" "$INSTDIR\doc\manual\en\Sylpheed.html"
    CreateShortCut "$SMPROGRAMS\${PRODUCT_NAME}\README.lnk" "$INSTDIR\README-win32.txt"
    File /oname=README.txt "Sylpheed\README-win32.txt"
  ${EndIf}
  CreateShortCut "$SMPROGRAMS\${PRODUCT_NAME}\Sylpheed.lnk" "$INSTDIR\sylpheed.exe"
  CreateShortCut "$SMPROGRAMS\${PRODUCT_NAME}\Sylpheed (debug mode).lnk" "$INSTDIR\sylpheed.exe" "--debug"
  CreateShortCut "$SMPROGRAMS\${PRODUCT_NAME}\Sylpheed All Quit.lnk" "$INSTDIR\sylpheed.exe" "--exit"
  WriteIniStr "$INSTDIR\${PRODUCT_NAME}.url" "InternetShortcut" "URL" "${ORIG_WEB_SITE}"
  CreateShortCut "$SMPROGRAMS\${PRODUCT_NAME}\Sylpheed Homepage.lnk" "$INSTDIR\${PRODUCT_NAME}.url"
  CreateShortCut "$SMPROGRAMS\${PRODUCT_NAME}\Uninstall.lnk" "$INSTDIR\uninst.exe"
${MementoSectionEnd}

SectionGroup /e "$(plugins)" sec_plugins

!ifdef SYLPHEED_PRO
${MementoSection} "Sylpheed Pro" sec_sylpheed_pro
  SetShellVarContext all
  SetOutPath "$INSTDIR"
  File /r "Sylpheed-Pro\"
  WriteIniStr "$INSTDIR\${INST_NAME}.url" "InternetShortcut" "URL" "${PRODUCT_WEB_SITE}"
  CreateShortCut "$SMPROGRAMS\${PRODUCT_NAME}\Sylpheed Pro Homepage.lnk" "$INSTDIR\${INST_NAME}.url"
  CreateShortCut "$SMPROGRAMS\${PRODUCT_NAME}\Sylpheed Pro Manual.lnk" "$INSTDIR\doc\manual\sylpheed-pro\ja\search-plugin.html"
${MementoSectionEnd}
!endif

${MementoSection} "$(attachment_tool_plugin)" sec_attachment_tool_plugin
  SetOutPath "$INSTDIR\plugins"
  File "plugins\plugins\attachment_tool.dll"
  SetOutPath "$INSTDIR\doc\plugins"
  File "plugins\doc\plugins\README.attachment_tool.txt"
${MementoSectionEnd}

SectionGroupEnd

${MementoSection} "sylfilter" sec_sylfilter
  SetOutPath "$INSTDIR"
  File /r "sylfilter\"
${MementoSectionEnd}

${MementoSection} "bsfilter" sec_bsfilter
  SetOutPath "$INSTDIR"
  File /r "bsfilter\"
${MementoSectionEnd}

${MementoSection} "$(desktop_shortcut)" sec_desktop_shortcut
  SetShellVarContext current
  CreateShortCut "$DESKTOP\Sylpheed.lnk" "$INSTDIR\sylpheed.exe"
${MementoSectionEnd}

${MementoUnselectedSection} "$(quick_shortcut)" sec_quick_shortcut
  SetShellVarContext current
  CreateShortCut "$QUICKLAUNCH\Sylpheed.lnk" "$INSTDIR\sylpheed.exe"
${MementoSectionEnd}

${MementoSection} "$(handler)" sec_handler
   ; HKLM
   ; .eml
   WriteRegStr HKLM "Software\Classes\Sylpheed.EML" "" "Sylpheed Message"
   WriteRegDWORD HKLM "Software\Classes\Sylpheed.EML" "EditFlags" 0x00000002
   WriteRegStr HKLM "Software\Classes\Sylpheed.EML" "FriendlyTypeName" "Sylpheed Message"
   WriteRegStr HKLM "Software\Classes\Sylpheed.EML\DefaultIcon" "" "$INSTDIR\sylpheed.exe,0"
   WriteRegStr HKLM "Software\Classes\Sylpheed.EML\shell\open\command" "" "$\"$INSTDIR\sylpheed.exe$\" --open $\"%1$\""

   ; mailto:
   WriteRegStr HKLM "Software\Classes\mailto" "" "URL:MailTo Protocol"
   WriteRegDWORD HKLM "Software\Classes\mailto" "EditFlags" 0x00000002
   WriteRegStr HKLM "Software\Classes\mailto" "FriendlyTypeName" "Sylpheed MailTo"
   WriteRegStr HKLM "Software\Classes\mailto" "URL Protocol" ""
   WriteRegStr HKLM "Software\Classes\mailto\DefaultIcon" "" "$INSTDIR\sylpheed.exe,0"
   WriteRegStr HKLM "Software\Classes\mailto\shell\open\command" "" "$\"$INSTDIR\sylpheed.exe$\" --compose $\"%1$\""

   WriteRegStr HKLM "Software\Classes\Sylpheed.Url.MailTo" "" "URL:MailTo Protocol"
   WriteRegDWORD HKLM "Software\Classes\Sylpheed.Url.MailTo" "EditFlags" 0x00000002
   WriteRegStr HKLM "Software\Classes\Sylpheed.Url.MailTo" "FriendlyTypeName" "Sylpheed MailTo"
   WriteRegStr HKLM "Software\Classes\Sylpheed.Url.MailTo" "URL Protocol" ""
   WriteRegStr HKLM "Software\Classes\Sylpheed.Url.MailTo\DefaultIcon" "" "$INSTDIR\sylpheed.exe,0"
   WriteRegStr HKLM "Software\Classes\Sylpheed.Url.MailTo\shell\open\command" "" "$\"$INSTDIR\sylpheed.exe$\" --compose $\"%1$\""

   WriteRegStr HKLM "Software\Clients\Mail\Sylpheed" "" "Sylpheed"
   WriteRegStr HKLM "Software\Clients\Mail\Sylpheed\DefaultIcon" "" "$INSTDIR\sylpheed.exe,0"
   WriteRegStr HKLM "Software\Clients\Mail\Sylpheed\Protocols\mailto" "" "URL:MailTo Protocol"
   WriteRegStr HKLM "Software\Clients\Mail\Sylpheed\Protocols\mailto" "URL Protocol" ""
   WriteRegStr HKLM "Software\Clients\Mail\Sylpheed\Protocols\mailto\DefaultIcon" "" "$INSTDIR\sylpheed.exe,0"
   WriteRegStr HKLM "Software\Clients\Mail\Sylpheed\Protocols\mailto\shell\open\command" "" "$\"$INSTDIR\sylpheed.exe$\" --compose $\"%1$\""
   WriteRegStr HKLM "Software\Clients\Mail\Sylpheed\shell\open\command" "" "$\"$INSTDIR\sylpheed.exe$\""

   WriteRegStr HKLM "Software\Clients\Mail\Sylpheed\Capabilities" "ApplicationName" "Sylpheed"
   WriteRegStr HKLM "Software\Clients\Mail\Sylpheed\Capabilities" "ApplicationIcon" "$INSTDIR\sylpheed.exe,0"
   WriteRegStr HKLM "Software\Clients\Mail\Sylpheed\Capabilities" "ApplicationDescription" "Sylpheed - lightweight and user-friendly e-mail client"
   WriteRegStr HKLM "Software\Clients\Mail\Sylpheed\Capabilities\FileAssociations" ".eml" "Sylpheed.EML"
   WriteRegStr HKLM "Software\Clients\Mail\Sylpheed\Capabilities\URLAssociations" "mailto" "Sylpheed.Url.MailTo"
   WriteRegStr HKLM "Software\Clients\Mail\Sylpheed\Capabilities\StartMenu" "Mail" "Sylpheed"

   WriteRegStr HKLM "Software\RegisteredApplications" "Sylpheed" "SOFTWARE\Clients\Mail\Sylpheed\Capabilities"

   ; HKCU
   WriteRegStr HKCU "Software\Clients\Mail" "" "Sylpheed"

   WriteRegStr HKCU "Software\Microsoft\Windows\Shell\Associations\URLAssociations\mailto\UserChoice" "Progid" "Sylpheed.Url.MailTo"
   DeleteRegKey HKCU "Software\Microsoft\Windows\CurrentVersion\Explorer\FileExts\.eml\UserChoice"
   WriteRegStr HKCU "Software\Microsoft\Windows\CurrentVersion\Explorer\FileExts\.eml\UserChoice" "Progid" "Sylpheed.EML"

   ; .eml
   WriteRegStr HKCU "Software\Classes\.eml" "" "Sylpheed.EML"

   WriteRegStr HKCU "Software\Classes\Sylpheed.EML" "" "Sylpheed Message"
   WriteRegDWORD HKCU "Software\Classes\Sylpheed.EML" "EditFlags" 0x00000002
   WriteRegStr HKCU "Software\Classes\Sylpheed.EML" "FriendlyTypeName" "Sylpheed Message"
   WriteRegStr HKCU "Software\Classes\Sylpheed.EML\DefaultIcon" "" "$INSTDIR\sylpheed.exe,0"
   WriteRegStr HKCU "Software\Classes\Sylpheed.EML\shell\open\command" "" "$\"$INSTDIR\sylpheed.exe$\" --open $\"%1$\""

   ; mailto:
   WriteRegStr HKCU "Software\Classes\mailto" "" "URL:MailTo Protocol"
   WriteRegDWORD HKCU "Software\Classes\mailto" "EditFlags" 0x00000002
   WriteRegStr HKCU "Software\Classes\mailto" "FriendlyTypeName" "Sylpheed MailTo"
   WriteRegStr HKCU "Software\Classes\mailto" "URL Protocol" ""
   WriteRegStr HKCU "Software\Classes\mailto\DefaultIcon" "" "$INSTDIR\sylpheed.exe,0"
   WriteRegStr HKCU "Software\Classes\mailto\shell\open\command" "" "$\"$INSTDIR\sylpheed.exe$\" --compose $\"%1$\""

   WriteRegStr HKCU "Software\Classes\Sylpheed.Url.MailTo" "" "URL:MailTo Protocol"
   WriteRegDWORD HKCU "Software\Classes\Sylpheed.Url.MailTo" "EditFlags" 0x00000002
   WriteRegStr HKCU "Software\Classes\Sylpheed.Url.MailTo" "FriendlyTypeName" "Sylpheed MailTo"
   WriteRegStr HKCU "Software\Classes\Sylpheed.Url.MailTo" "URL Protocol" ""
   WriteRegStr HKCU "Software\Classes\Sylpheed.Url.MailTo\DefaultIcon" "" "$INSTDIR\sylpheed.exe,0"
   WriteRegStr HKCU "Software\Classes\Sylpheed.Url.MailTo\shell\open\command" "" "$\"$INSTDIR\sylpheed.exe$\" --compose $\"%1$\""
${MementoSectionEnd}

${MementoSectionDone}

Section -Post
  WriteUninstaller "$INSTDIR\uninst.exe"
  WriteRegStr HKLM "${PRODUCT_DIR_REGKEY}" "" "$INSTDIR\sylpheed.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayName" "$(^Name)"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString" "$INSTDIR\uninst.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayIcon" "$INSTDIR\sylpheed.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayVersion" "${PRODUCT_VERSION}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "URLInfoAbout" "${PRODUCT_WEB_SITE}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "Publisher" "${PRODUCT_PUBLISHER}"
SectionEnd

Section "!un.Sylpheed" sec_un_sylpheed
  SetShellVarContext all
  Delete "$SMPROGRAMS\${PRODUCT_NAME}\Sylpheed Manual.lnk"
  Delete "$SMPROGRAMS\${PRODUCT_NAME}\README.lnk"
  Delete "$SMPROGRAMS\${PRODUCT_NAME}\Sylpheed.lnk"
  Delete "$SMPROGRAMS\${PRODUCT_NAME}\Sylpheed (debug mode).lnk"
  Delete "$SMPROGRAMS\${PRODUCT_NAME}\Sylpheed All Quit.lnk"
  Delete "$SMPROGRAMS\${PRODUCT_NAME}\Sylpheed Homepage.lnk"
  Delete "$SMPROGRAMS\${PRODUCT_NAME}\Uninstall.lnk"
  SetShellVarContext current

  Delete "$INSTDIR\plugin-updater.exe"
  Delete "$INSTDIR\update-manager.exe"

  Delete "$INSTDIR\curl.exe"
  Delete "$INSTDIR\gpgme-w32spawn.exe"
  Delete "$INSTDIR\gspawn-win32-helper-console.exe"
  Delete "$INSTDIR\gspawn-win32-helper.exe"
  Delete "$INSTDIR\iconv.dll"
  Delete "$INSTDIR\intl.dll"
  Delete "$INSTDIR\jpeg62.dll"
  Delete "$INSTDIR\libatk-1.0-0.dll"
  Delete "$INSTDIR\libcairo-2.dll"
  Delete "$INSTDIR\libcompface.dll"
  Delete "$INSTDIR\libeay32.dll"
  Delete "$INSTDIR\libgdk-win32-2.0-0.dll"
  Delete "$INSTDIR\libgdk_pixbuf-2.0-0.dll"
  Delete "$INSTDIR\libglib-2.0-0.dll"
  Delete "$INSTDIR\libgmodule-2.0-0.dll"
  Delete "$INSTDIR\libgobject-2.0-0.dll"
  Delete "$INSTDIR\libgpg-error-0.dll"
  Delete "$INSTDIR\libgpgme-11.dll"
  Delete "$INSTDIR\libgthread-2.0-0.dll"
  Delete "$INSTDIR\libgtk-win32-2.0-0.dll"
  Delete "$INSTDIR\libonig.dll"
  Delete "$INSTDIR\libpango-1.0-0.dll"
  Delete "$INSTDIR\libpangocairo-1.0-0.dll"
  Delete "$INSTDIR\libpangowin32-1.0-0.dll"
  Delete "$INSTDIR\libpng13.dll"
  Delete "$INSTDIR\libsylph-0-1.dll"
  Delete "$INSTDIR\libsylpheed-plugin-0-1.dll"
  Delete "$INSTDIR\libtiff3.dll"
  Delete "$INSTDIR\README-win32-es.txt"
  Delete "$INSTDIR\README-win32-ja.txt"
  Delete "$INSTDIR\README-win32.txt"
  Delete "$INSTDIR\README.txt"
  Delete "$INSTDIR\sample-sylpheed.ini"
  Delete "$INSTDIR\ssleay32.dll"
  Delete "$INSTDIR\sylpheed-128x128.png"
  Delete "$INSTDIR\sylpheed-64x64.png"
  Delete "$INSTDIR\sylpheed-mailto-protocol_admin.reg"
  Delete "$INSTDIR\sylpheed-mailto-protocol_user.reg"
  Delete "$INSTDIR\sylpheed.exe"
  Delete "$INSTDIR\sylpheed.png"
  Delete "$INSTDIR\${PRODUCT_NAME}.url"
  Delete "$INSTDIR\uninst.exe"
  Delete "$INSTDIR\wabread.exe"
  Delete "$INSTDIR\zlib1.dll"
  RMDir /r "$INSTDIR\doc"
  RMDir /r "$INSTDIR\etc"
  RMDir /r "$INSTDIR\lib"
  RMDir /r "$INSTDIR\share\themes"
  RMDir "$INSTDIR\share"
SectionEnd

SectionGroup /e "un.$(plugins)" sec_un_plugins

!ifdef SYLPHEED_PRO
Section "un.Sylpheed Pro" sec_un_sylpheed_pro
  SetShellVarContext all
  Delete "$SMPROGRAMS\${PRODUCT_NAME}\Sylpheed Pro Homepage.lnk"
  Delete "$SMPROGRAMS\${PRODUCT_NAME}\Sylpheed Pro Manual.lnk"
  SetShellVarContext current

  ; Sylpheed Pro components
  Delete "$INSTDIR\bzip2.dll"
  Delete "$INSTDIR\dbimport-ext.exe"
  Delete "$INSTDIR\dts-indexer.exe"
  Delete "$INSTDIR\libarchive2.dll"
  Delete "$INSTDIR\libmecab.dll"
  Delete "$INSTDIR\libpq.dll"
  Delete "$INSTDIR\mecabrc"
  Delete "$INSTDIR\Sylpheed Pro.url"
  Delete "$INSTDIR\plugins\dbimport.dll"
  Delete "$INSTDIR\plugins\scheduler.dll"
  RMDir /r "$INSTDIR\dic"
  RMDir /r "$INSTDIR\pgsql"
  RMDir /r "$INSTDIR\pgsql83"
  RMDir /r "$INSTDIR\share\sylpheed-pro"
  RMDir "$INSTDIR\share"
SectionEnd
!endif

Section "un.$(attachment_tool_plugin)" sec_un_attachment_tool_plugin
  Delete "$INSTDIR\plugins\attachment_tool.dll"
  Delete "$INSTDIR\doc\plugins\README.attachment_tool.txt"
SectionEnd

SectionGroupEnd

Section "un.sylfilter" sec_un_sylfilter
  ; sylfilter components
  Delete "$INSTDIR\sylfilter.exe"
  Delete "$INSTDIR\sylfilter-cui.exe"
SectionEnd

Section "un.bsfilter" sec_un_bsfilter
  ; bsfilter components
  Delete "$INSTDIR\bsfilter"
  Delete "$INSTDIR\bsfilterw.exe"
SectionEnd

Section "un.$(desktop_shortcut)" sec_un_desktop_shortcut
  SetShellVarContext current
  Delete "$DESKTOP\Sylpheed.lnk"
SectionEnd

Section "un.$(quick_shortcut)" sec_un_quick_shortcut
  SetShellVarContext current
  Delete "$QUICKLAUNCH\Sylpheed.lnk"
SectionEnd

Section "-un.install"
  SetShellVarContext all
  RMDir "$SMPROGRAMS\Sylpheed"
  SetShellVarContext current

  ; remove plug-ins dir only when empty
  RMDir "$INSTDIR\plugins"
  RMDir "$INSTDIR"

  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}"
  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_DIR_REGKEY}"
  DeleteRegKey HKLM "Software\Classes\Sylpheed.EML"
  DeleteRegKey HKLM "Software\Classes\Sylpheed.Url.MailTo"
  DeleteRegKey HKLM "Software\Clients\Mail\Sylpheed"
  DeleteRegValue HKLM "Software\RegisteredApplications" "Sylpheed"
  DeleteRegKey HKCU "Software\Classes\Sylpheed.EML"
  DeleteRegKey HKCU "Software\Classes\Sylpheed.Url.MailTo"
  DeleteRegKey ${MEMENTO_REGISTRY_ROOT} "${MEMENTO_REGISTRY_KEY}"

  SetAutoClose true
SectionEnd

; Section descriptions
!insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
  !insertmacro MUI_DESCRIPTION_TEXT ${sec_sylpheed} "$(sylpheed_description)"
  !insertmacro MUI_DESCRIPTION_TEXT ${sec_plugins} "$(plugins_description)"
!ifdef SYLPHEED_PRO
  !insertmacro MUI_DESCRIPTION_TEXT ${sec_sylpheed_pro} "$(sylpheed_pro_description)"
!endif
  !insertmacro MUI_DESCRIPTION_TEXT ${sec_attachment_tool_plugin} "$(attachment_tool_plugin_description)"
  !insertmacro MUI_DESCRIPTION_TEXT ${sec_sylfilter} "$(sylfilter_description)"
  !insertmacro MUI_DESCRIPTION_TEXT ${sec_bsfilter} "$(bsfilter_description)"
  !insertmacro MUI_DESCRIPTION_TEXT ${sec_desktop_shortcut} "$(desktop_shortcut_description)"
  !insertmacro MUI_DESCRIPTION_TEXT ${sec_quick_shortcut} "$(quick_shortcut_description)"
  !insertmacro MUI_DESCRIPTION_TEXT ${sec_handler} "$(handler_description)"
!insertmacro MUI_FUNCTION_DESCRIPTION_END
!insertmacro MUI_UNFUNCTION_DESCRIPTION_BEGIN
  !insertmacro MUI_DESCRIPTION_TEXT ${sec_un_sylpheed} "$(un_sylpheed_description)"
  !insertmacro MUI_DESCRIPTION_TEXT ${sec_un_plugins} "$(un_plugins_description)"
!ifdef SYLPHEED_PRO
  !insertmacro MUI_DESCRIPTION_TEXT ${sec_un_sylpheed_pro} "$(un_sylpheed_pro_description)"
!endif
  !insertmacro MUI_DESCRIPTION_TEXT ${sec_un_attachment_tool_plugin} "$(un_attachment_tool_plugin_description)"
  !insertmacro MUI_DESCRIPTION_TEXT ${sec_un_sylfilter} "$(un_sylfilter_description)"
  !insertmacro MUI_DESCRIPTION_TEXT ${sec_un_bsfilter} "$(un_bsfilter_description)"
  !insertmacro MUI_DESCRIPTION_TEXT ${sec_un_desktop_shortcut} "$(un_desktop_shortcut_description)"
  !insertmacro MUI_DESCRIPTION_TEXT ${sec_un_quick_shortcut} "$(un_quick_shortcut_description)"
  ; handler is not uninstallable.
!insertmacro MUI_UNFUNCTION_DESCRIPTION_END

Function .onInit
  ${MementoSectionRestore}

  StrCpy $1 ${sec_sylpheed}

; Prevent install while Sylpheed is running
check_app_running:
  ${nsProcess::FindProcess} "sylpheed.exe" $R0
  StrCmp $R0 "0" 0 +3
  MessageBox MB_OKCANCEL|MB_ICONEXCLAMATION "$(app_running)" IDOK check_app_running
  Abort

; Auto-uninstall old before installing new
; http://nsis.sourceforge.net/Auto-uninstall_old_before_installing_new
  ReadRegStr $R0 HKLM \
  "${PRODUCT_UNINST_KEY}" "UninstallString"
  StrCmp $R0 "" done_
 
  MessageBox MB_OKCANCEL|MB_ICONEXCLAMATION \
  "$(delete_caution)" \
  /SD IDOK \
  IDOK uninst
  Abort
  
;Run the uninstaller
uninst:
  ClearErrors
  StrCpy $ISSILENT "/S"
  IfSilent +2
    StrCpy $ISSILENT ""
  ExecWait '$R0 $ISSILENT _?=$INSTDIR' ;Do not copy the uninstaller to a temp file
 
  IfErrors no_remove_uninstaller done_
  no_remove_uninstaller:
  Abort
  
; label "done" used in MementoSectionRestore
done_:
FunctionEnd

Function .onInstSuccess
  ${MementoSectionSave}
FunctionEnd

Function .onSelChange
  !insertmacro StartRadioButtons $1
    !insertmacro RadioButton ${sec_sylpheed}
  !insertmacro EndRadioButtons
FunctionEnd

Function un.onInit
check_app_running:
  ; Prevent uninstall while Sylpheed is running
  ${nsProcess::FindProcess} "sylpheed.exe" $R0
  StrCmp $R0 "0" 0 +3
  MessageBox MB_OKCANCEL|MB_ICONEXCLAMATION "$(app_running_uninst)" IDOK check_app_running
  Abort

  ${nsProcess::KillProcess} "sylpheed.exe" $R0
  ${nsProcess::KillProcess} "dts-indexer.exe" $R0
  ${nsProcess::KillProcess} "postgres.exe" $R0

  SetShellVarContext current

  IfFileExists "$INSTDIR\sylpheed.exe" sylpheed_file_exists
  !insertmacro UnselectSection ${sec_un_sylpheed}
  sylpheed_file_exists:
  !insertmacro SetSectionFlag ${sec_un_sylpheed} ${SF_RO}

!ifdef SYLPHEED_PRO
  IfFileExists "$INSTDIR\plugins\dbimport.dll" sylpheed_pro_file_exists
  !insertmacro UnselectSection ${sec_un_sylpheed_pro}
  !insertmacro SetSectionFlag ${sec_un_sylpheed_pro} ${SF_RO}
  sylpheed_pro_file_exists:
!endif

  IfFileExists "$INSTDIR\plugins\attachment_tool.dll" attachment_tool_plugin_file_exists
  !insertmacro UnselectSection ${sec_un_attachment_tool_plugin}
  !insertmacro SetSectionFlag ${sec_un_attachment_tool_plugin} ${SF_RO}
  attachment_tool_plugin_file_exists:

  IfFileExists "$INSTDIR\sylfilter.exe" sylfilter_file_exists
  !insertmacro UnselectSection ${sec_un_sylfilter}
  !insertmacro SetSectionFlag ${sec_un_sylfilter} ${SF_RO}
  sylfilter_file_exists:

  IfFileExists "$INSTDIR\bsfilter" bsfilter_file_exists
  !insertmacro UnselectSection ${sec_un_bsfilter}
  !insertmacro SetSectionFlag ${sec_un_bsfilter} ${SF_RO}
  bsfilter_file_exists:

  SetShellVarContext current
  IfFileExists "$DESKTOP\Sylpheed.lnk" desktop_shortcut_file_exists
  !insertmacro UnselectSection ${sec_un_desktop_shortcut}
  !insertmacro SetSectionFlag ${sec_un_desktop_shortcut} ${SF_RO}
  desktop_shortcut_file_exists:

  SetShellVarContext current
  IfFileExists "$QUICKLAUNCH\Sylpheed.lnk" quick_shortcut_file_exists
  !insertmacro UnselectSection ${sec_un_quick_shortcut}
  !insertmacro SetSectionFlag ${sec_un_quick_shortcut} ${SF_RO}
  quick_shortcut_file_exists:
FunctionEnd

Function ShowReadme
  ExecShell open "$INSTDIR\README.txt"
!ifdef SYLPHEED_PRO
  ${If} $LANGUAGE = "${LANG_JAPANESE}"
    IfFileExists "$INSTDIR\doc\manual\sylpheed-pro\ja\search-plugin.html" 0 +2
      ExecShell open "$INSTDIR\doc\manual\sylpheed-pro\ja\search-plugin.html"
  ${EndIf}
!endif
FunctionEnd
