#include <SyFi.h>
#include <fstream>

using namespace GiNaC; 
using namespace SyFi; 
using namespace std; 

int main() {

    initSyFi(3); 

    ex p0 = lst(0.0,0.0,0.0);
    ex p1 = lst(1.0,0.0,0.0);
    ex p2 = lst(0.0,1.0,0.0);

    
    cout <<"\n\nThe reference triangle in 3D"<<endl; 
    Triangle triangle(p0,p1,p2); 
    cout <<triangle.str()<<endl; 
    ex repr = triangle.repr(); 
    cout <<"repr "<<repr<<endl; 

    cout <<"\n\nThe reference triangle in 3D by using Simplex"<<endl; 
    lst vertices(p0,p1,p2); 
    Simplex simplex(vertices); 
    cout <<simplex.str()<<endl; 
    repr = simplex.repr(); 
    cout <<"repr "<<repr<<endl; 

    cout <<"\n\nThe sub-simplices (lines) on the reference triangle simplex in 3D"<<endl; 
    for (unsigned int i=0; i<3; i++) {
      Simplex sub_simplex = simplex.sub_simplex(i); 
      cout <<"\nsub simplex:  "<<i<<"\n\t"<<sub_simplex.str() <<"\n\trepr "<< sub_simplex.repr()<<endl; 
      for (unsigned int k=0; k< sub_simplex.no_vertices(); k++) {
        cout <<"\tv"<<k<<" "<<sub_simplex.vertex(k); 
      }
    }



    cout <<"\n\nThe reference tetrahedron"<<endl; 
    ex p3 = lst(0.0,0.0,1.0);
    Tetrahedron tetrahedron(p0,p1,p2,p3); 
    cout <<tetrahedron.str()<<endl; 
    cout <<"repr "<<tetrahedron.repr()<<endl; 

    cout <<"\n\nThe reference tetrahedron represented by Simplex"<<endl; 
    Simplex simplex3(lst(p0,p1,p2,p3)); 
    cout <<simplex3.str()<<endl; 
    cout <<"repr "<<simplex3.repr()<<endl; 


    cout <<"\n\nThe integral of 1 over the reference tetrahedron represented by Simplex"<<endl; 
    ex f = 1; 
    std::cout <<" simplex3.integrate(f) = "<< simplex3.integrate(f) <<std::endl; 

    initSyFi(4); 

    ex q0 = lst(0.0,0.0,0.0,0.0);
    ex q1 = lst(1.0,0.0,0.0,0.0);
    ex q2 = lst(0.0,1.0,0.0,0.0);
    ex q3 = lst(0.0,0.0,1.0,0.0);
    ex q4 = lst(0.0,0.0,0.0,1.0);

    cout <<"\n\nThe reference simplex in 4D"<<endl; 
    Simplex simplex4(lst(q0,q1,q2,q3, q4)); 
    cout <<simplex4.str()<<endl; 
    cout <<"repr "<<simplex4.repr()<<endl; 

    cout <<"\n\nThe integral of 1 over the reference simplex in 4D"<<endl; 
    std::cout <<" simplex4.integrate(f) = "<< simplex4.integrate(f) <<std::endl; 




    initSyFi(5); 

    ex r0 = lst(0.0,0.0,0.0,0.0,0.0);
    ex r1 = lst(1.0,0.0,0.0,0.0,0.0);
    ex r2 = lst(0.0,1.0,0.0,0.0,0.0);
    ex r3 = lst(0.0,0.0,1.0,0.0,0.0);
    ex r4 = lst(0.0,0.0,0.0,1.0,0.0);
    ex r5 = lst(0.0,0.0,0.0,0.0,1.0);

    cout <<"\n\nThe reference simplex in 4D"<<endl; 
    Simplex simplex5(lst(r0,r1,r2,r3,r4,r5)); 
    cout <<simplex5.str()<<endl; 
    cout <<"repr "<<simplex5.repr()<<endl; 

    cout <<"\n\nThe integral of 1 over the reference simplex in 5D"<<endl; 
    std::cout <<" simplex5.integrate(f) = "<< simplex5.integrate(f) <<std::endl; 







}


