#include <SyFi.h>
#include <fstream>

using namespace GiNaC; 
using namespace SyFi; 
using namespace std; 

int main() {

    initSyFi(2); 

    Triangle T(lst(0,0), lst(1,0), lst(0,1), "t"); 
    int order = 2; 

    std::map<std::pair<int,int>, ex> A;
    std::pair<int,int> index;
    Lagrange fe; 
    fe.set_order(order); 
    fe.set_polygon(T); 
    fe.compute_basis_functions(); 
    for (int i=0; i< fe.nbf() ; i++) {
        index.first = i; 
        for (int j=0; j< fe.nbf() ; j++) {
            index.second = j; 
            ex nabla = inner(grad(fe.N(i)), grad(fe.N(j))); 
            ex Aij = T.integrate(nabla);   
            A[index] = Aij;  
        }
    }

    map<std::pair<int,int>,ex>::iterator iter; 
    for (iter = A.begin(); iter != A.end() ; iter++) {
        cout <<"A["<<(*iter).first.first<<","<<(*iter).first.second<<"]="<<(*iter).second<<endl; 
    }


    // regression test 
    archive ar; 
    for (iter = A.begin(); iter != A.end() ; iter++) {
	ar.archive_ex((*iter).second, istr("A", (*iter).first.first, (*iter).first.second).c_str()); 
    }
    ofstream vfile("fe_ex2.gar.v"); 
    vfile << ar; vfile.close(); 
    if(!compare_archives("fe_ex2.gar.v", "fe_ex2.gar.r")) { 
	    cerr << "Failure!" << endl;
	    return -1;
    }

    return 0; 
}



