
from dolfin import *

parameters["form_compiler"]["name"]= "sfc"

class BoundaryFunction(Expression): 
    def dim(self): return 2
    def eval(self, values, x): 
        values[0] = (0.5*(x[0] + x[1]))**2     
        values[1] = (1-0.5*(x[0] + x[1]))**2  

class DirichletBoundary(SubDomain): 
    def inside(self, x, on_boundary): 
        return bool(on_boundary)

# Geometry
N = 80  
P = 5 

mesh = UnitSquare(N,N)

# Function spaces
V = VectorFunctionSpace(mesh, "CG", 1)

# BoundaryFunction function 
U = Function(V)

# Basis functions 
v = TestFunction(V)
u = TrialFunction(V)

# Forms
L = inner(grad(U),grad(U))*dx + dot(U,U)**P*dx  
F = derivative(L, U, v)
J = derivative(F, U, u)

# start vector 
boundary_function = BoundaryFunction(V)
x0 = project(boundary_function,V)

# Solve nonlinear variational problem
dirichlet_boundary = DirichletBoundary()
bc = DirichletBC(V, boundary_function, dirichlet_boundary)
#problem = VariationalProblem(J, F, bc, nonlinear=True)

problem = VariationalProblem(J, F, bc, nonlinear=True)
problem.solve(U)

plot(U)
interactive()

# Write solution to file
file = File("u.pvd") 
file << U 

