#include <iostream>
using namespace std;

#include <tools.h>
using namespace GiNaC;
using namespace SyFi;

/* Simplification strategy during form creation:
 *	- Count symbols
 *	- Take the X % most used symbols, and create a sqrfree factorization
 *	OR SIMPLY:
 *	- Create a sqrfree factorization wrt (x,y,z)
 */

/* Simplification strategy after integration:
 *	- Count symbols
 *	- Count flops
 *	- Take the P % most used symbols with degree > D, and create a sqrfree factorization
 *	- Count flops
 *	- Undo if flop count increases!
 *	- Register single variable powers
 *	- Simplify with ExpressionSimplifier
 */


void print(ex e)
{
	cout << "    e = " << e << endl;

	exhashmap<int> sc = count_symbols(e);
	exhashmap<int>::iterator it;
	int count = 0;
	int maxcount = 0;
	for(it = sc.begin(); it != sc.end(); it++)
	{
		if(it->second > maxcount)
			maxcount = it->second;
		count += it->second;
		//cout << "        " << it->first << ": " << it->second << endl;
	}
	cout << "    number of symbols / total symbol count  = " << sc.size() << ", " << count << endl;

	ExStats es = count_ops(e);
	cout << "    m,a,p,f,flops = "
	                           << es.muls << ", "
	                           << es.adds << ", "
	                           << es.pows << ", "
	                           << es.functions << ", "
	                           << es.flops << endl;
}

void variants(ex e)
{
	cout << "====================" << endl;
	cout << "original:" << endl;
	print(e);

	cout << "expand:" << endl;
	print(expand(e));

	cout << "normal:" << endl;
	print(normal(e));

	cout << "sqrfree in x,y,z:" << endl;
	print(sqrfree(e,lst(x,y,z)));
/*
	cout << "sqrfree in x,y,z of expanded form:" << endl;
	print(sqrfree(expand(e),lst(x,y,z)));
*/

/*
	cout << "collect_common_factors:" << endl;
	print(collect_common_factors(e));

	cout << "collect_common_factors o expand:" << endl;
	print(collect_common_factors(expand(e)));
*/
	cout << "----------------------------------------" << endl;

	list<symexpair> sel;
	list<symbol> sl;
	sl.push_back(x);
	sl.push_back(y);
	sl.push_back(z);

	cout << "replace_powers:" << endl;
	print( replace_powers(e, sl, sel) );

	cout << "replace_powers(expand):" << endl;
	print( replace_powers(expand(e), sl, sel) );

	cout << "replace_powers(sqrfree):" << endl;
	print( replace_powers(sqrfree(e, lst(x,y,z)), sl, sel) );

	cout << "replace_powers(sqrfree(expand)):" << endl;
	print( replace_powers(sqrfree(expand(e), lst(x,y,z)), sl, sel) );
	cout << "====================" << endl;

/*
	list<symexpair>::iterator it = sel.begin();
	for(;it!=sel.end();it++)
	{
		cout << it->first << ", " << it->second << endl;
	}
*/
}

int main() {
	initSyFi(3);

	ex e;

	e = x*y+y*z+z*x;
	variants(e);

	e = pow(x*y+y*z+z*x,5);
	variants(e);

	e = (x*y*z)*(x*y*z)+(x*y*z)+(x*y*z);
	variants(e);

	e = pow(2-2*y,3) * pow(1+x*y,2) * pow(x-2*y,2) * (x+y);
	variants(e);

	e = 1;
	for(int i=0; i<10; i++)
	{
		e = e*isymb("x",i) + isymb("y",i);
	}
	variants(e);

	return 0;
}
