
import os
import glob
import instant

def get_abs_ufc_h_path():
    (ufc_include_dirs, ufc_flags, ufc_libs, ufc_libdirs) = instant.header_and_libs_from_pkgconfig("ufc-1")
    if len(ufc_include_dirs) == 0:
        sys_dirs = ["/usr/include", "/usr/local/include", "/opt/include"]
        for d in sys_dirs:
            f = glob.glob(os.path.join(d, "ufc.h"))
            if len(f) == 1:
                return f[0]
        raise "ERROR: Found no include dir for ufc.h: %s. FIXME: Need better configuration tools in SyFi!"
    if len(ufc_include_dirs) > 1:
        print "WARNING: Found more than one include dir for ufc.h: %s. Using %s. FIXME: Need better configuration tools in SyFi!" % (str(ufc_include_dirs), ufc_include_dirs[0])
    return os.path.join(ufc_include_dirs[0], "ufc.h")

