/*  $Id$

    Part of SWI-Prolog

    Author:        Jan Wielemaker
    E-mail:        J.Wielemaker@uva.nl
    WWW:           http://www.swi-prolog.org
    Copyright (C): 1985-2008, University of Amsterdam

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    As a special exception, if you link this library with other files,
    compiled with a Free Software compiler, to produce an executable, this
    library does not by itself cause the resulting executable to be covered
    by the GNU General Public License. This exception does not however
    invalidate any other reasons why the executable file might be covered by
    the GNU General Public License.
*/

:- module('$apply',
	  [ forall/2,			% :Goal, :Goal
	    apply/2			% :Goal, +ExtraArgs
	  ]).

:- meta_predicate
	forall(0,0),
	apply(:, +).

:- noprofile((forall/2, apply/2)).

%%	forall(+Condition, +Action)
%
%	True if Action if true for all variable bindings for which Condition
%	if true.

forall(Cond, Action) :-
	\+ (Cond, \+ Action).

%%	apply(:Goal, +ExtraArgs) is nondet.
%
%	Extend Goal with arguments from ExtraArgs and call it.
%
%	@deprecated	Almost all usage can be replaced by call/N.

apply(M:Goal, Extra) :-
	(   callable(Goal)
	->  Goal =.. List0,
	    '$append'(List0, Extra, List),
	    G =.. List,
	    M:G
	;   throw(error(type_error(callable, Goal), _))
	).
