#!/bin/sh

BASE_REL=$(dpkg-parsechangelog 2>/dev/null | sed -ne 's/Version: \([0-9.]\+\)+.*/\1/p')
OLDDIR=${PWD}
GOS_DIR=${OLDDIR}/get-orig-source
GIT_COMMIT='git log -1 --oneline | cut -d" " -f1'
GIT_DATE='git log -1 --date=iso | sed -ne "s/Date:\s\+\(.*\).*/\1/p" | cut -d" " -f1 | tr -d "-"'

if [ -z ${BASE_REL} ]; then
	echo 'Please run this script from the sources root directory.'
	exit 1
fi


rm -rf ${GOS_DIR}
mkdir ${GOS_DIR} && cd ${GOS_DIR}
git clone http://github.com/swh/lv2.git swh-lv2
cd swh-lv2/
SWH_LV2_GIT_COMMIT=$(eval "${GIT_COMMIT}")
SWH_LV2_GIT_DATE=$(eval "${GIT_DATE}")
cd .. && tar cjf \
	${OLDDIR}/swh-lv2_${BASE_REL}+${SWH_LV2_GIT_DATE}.git${SWH_LV2_GIT_COMMIT}.orig.tar.bz2 \
	swh-lv2 --exclude=.git --exclude=util/gsm
rm -rf ${GOS_DIR}
