/* Swfdec
 * Copyright (C) 2007 Pekka Lampila <pekka.lampila@iki.fi>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, 
 * Boston, MA  02110-1301  USA
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "swfdec_as_internal.h"
#include "swfdec_debug.h"

SWFDEC_AS_NATIVE (1101, 1, swfdec_drop_shadow_filter_get_distance)
void
swfdec_drop_shadow_filter_get_distance (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("DropShadowFilter.distance (get)");
}

SWFDEC_AS_NATIVE (1101, 2, swfdec_drop_shadow_filter_set_distance)
void
swfdec_drop_shadow_filter_set_distance (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("DropShadowFilter.distance (set)");
}

SWFDEC_AS_NATIVE (1101, 3, swfdec_drop_shadow_filter_get_angle)
void
swfdec_drop_shadow_filter_get_angle (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("DropShadowFilter.angle (get)");
}

SWFDEC_AS_NATIVE (1101, 4, swfdec_drop_shadow_filter_set_angle)
void
swfdec_drop_shadow_filter_set_angle (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("DropShadowFilter.angle (set)");
}

SWFDEC_AS_NATIVE (1101, 5, swfdec_drop_shadow_filter_get_color)
void
swfdec_drop_shadow_filter_get_color (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("DropShadowFilter.color (get)");
}

SWFDEC_AS_NATIVE (1101, 6, swfdec_drop_shadow_filter_set_color)
void
swfdec_drop_shadow_filter_set_color (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("DropShadowFilter.color (set)");
}

SWFDEC_AS_NATIVE (1101, 7, swfdec_drop_shadow_filter_get_alpha)
void
swfdec_drop_shadow_filter_get_alpha (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("DropShadowFilter.alpha (get)");
}

SWFDEC_AS_NATIVE (1101, 8, swfdec_drop_shadow_filter_set_alpha)
void
swfdec_drop_shadow_filter_set_alpha (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("DropShadowFilter.alpha (set)");
}

SWFDEC_AS_NATIVE (1101, 9, swfdec_drop_shadow_filter_get_quality)
void
swfdec_drop_shadow_filter_get_quality (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("DropShadowFilter.quality (get)");
}

SWFDEC_AS_NATIVE (1101, 10, swfdec_drop_shadow_filter_set_quality)
void
swfdec_drop_shadow_filter_set_quality (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("DropShadowFilter.quality (set)");
}

SWFDEC_AS_NATIVE (1101, 11, swfdec_drop_shadow_filter_get_inner)
void
swfdec_drop_shadow_filter_get_inner (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("DropShadowFilter.inner (get)");
}

SWFDEC_AS_NATIVE (1101, 12, swfdec_drop_shadow_filter_set_inner)
void
swfdec_drop_shadow_filter_set_inner (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("DropShadowFilter.inner (set)");
}

SWFDEC_AS_NATIVE (1101, 13, swfdec_drop_shadow_filter_get_knockout)
void
swfdec_drop_shadow_filter_get_knockout (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("DropShadowFilter.knockout (get)");
}

SWFDEC_AS_NATIVE (1101, 14, swfdec_drop_shadow_filter_set_knockout)
void
swfdec_drop_shadow_filter_set_knockout (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("DropShadowFilter.knockout (set)");
}

SWFDEC_AS_NATIVE (1101, 15, swfdec_drop_shadow_filter_get_blurX)
void
swfdec_drop_shadow_filter_get_blurX (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("DropShadowFilter.blurX (get)");
}

SWFDEC_AS_NATIVE (1101, 16, swfdec_drop_shadow_filter_set_blurX)
void
swfdec_drop_shadow_filter_set_blurX (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("DropShadowFilter.blurX (set)");
}

SWFDEC_AS_NATIVE (1101, 17, swfdec_drop_shadow_filter_get_blurY)
void
swfdec_drop_shadow_filter_get_blurY (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("DropShadowFilter.blurY (get)");
}

SWFDEC_AS_NATIVE (1101, 18, swfdec_drop_shadow_filter_set_blurY)
void
swfdec_drop_shadow_filter_set_blurY (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("DropShadowFilter.blurY (set)");
}

SWFDEC_AS_NATIVE (1101, 19, swfdec_drop_shadow_filter_get_strength)
void
swfdec_drop_shadow_filter_get_strength (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("DropShadowFilter.strength (get)");
}

SWFDEC_AS_NATIVE (1101, 20, swfdec_drop_shadow_filter_set_strength)
void
swfdec_drop_shadow_filter_set_strength (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("DropShadowFilter.strength (set)");
}

SWFDEC_AS_NATIVE (1101, 21, swfdec_drop_shadow_filter_get_hideObject)
void
swfdec_drop_shadow_filter_get_hideObject (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("DropShadowFilter.hideObject (get)");
}

SWFDEC_AS_NATIVE (1101, 22, swfdec_drop_shadow_filter_set_hideObject)
void
swfdec_drop_shadow_filter_set_hideObject (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("DropShadowFilter.hideObject (set)");
}

// constructor
SWFDEC_AS_NATIVE (1101, 0, swfdec_drop_shadow_filter_construct)
void
swfdec_drop_shadow_filter_construct (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("DropShadowFilter");
}
