/*==================================================================
 * samview.h - Header file for GTK sample view widget
 *
 * Swami
 * Copyright (C) 1999-2003 Josh Green <jgreen@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA or point your web browser to http://www.gnu.org.
 *
 * To contact the author of this program:
 * Email: Josh Green <jgreen@users.sourceforge.net>
 * Swami homepage: http://swami.sourceforge.net
 *==================================================================*/
#ifndef __SAMVIEW_WIDG_H__
#define __SAMVIEW_WIDG_H__

#include <gdk/gdk.h>
#include <gtk/gtkwidget.h>
#include <gtk/gtkadjustment.h>

#define SAMVIEW(obj)	GTK_CHECK_CAST(obj, samview_get_type(), SamView)
#define SAMVIEW_CLASS(klass)	GTK_CHECK_CLASS_CAST(klass, samview_get_type(), SamViewClass)
#define IS_SAMVIEW(obj)	GTK_CHECK_TYPE(obj, samview_get_type())

typedef struct _SamView SamView;
typedef struct _SamViewClass SamViewClass;
typedef struct _SamViewMark SamViewMark;

/* For markers */
struct _SamViewMark
{
  gint pos;			/* Marker position in samples: -1 = disabled */
  gint xpos;			/* Marker x pixel position: -1 = not in view */
  GdkColor color;
  GdkGC *gc;
};

struct _SamView
{
  GtkWidget widget;

  gint16 *samdata;		/* Pointer to 16 bit Signed Mono sample data */
  gint length;			/* length of sample data in samples */

  gint start;			/* start position of view (in samples) */
  gint size;			/* size of view (in samples) */

  gint select_start;		/* sample selection start (in samples) or -1 */
  gint select_end;		/* sample selection end (in samples) or -1 */
  gint select_actvbegin;	/* active selection begin (in samples) or -1 */

  gint select_scroll;		/* scroll direction 0,1,2 = none,left,right */
  guint32 select_scrolltime;	/* time of last scroll motion event */
  gint select_scrolly;		/* y position of last mouse motion event */
  float select_scrollamt;	/* amount to scroll (in view pixels) */
  gint select_scrollaccum;	/* accumulated scroll amount in samples */
  gint select_toid;		/* selection scroll time out id */

  GSList *markers;		/* linked list of markers */
  SamViewMark *sel_marker;	/* currently highlighted marker or NULL */

  GtkAdjustment *adj;		/* adjustment for sample view */
  float oldval;			/* previous adjustment value */

  gint zoom_btn;		/* zoom mouse button 1 or 3, 0 = disabled */
  gint zoom_pos;		/* current mouse zoom position (pixels) */
  gint zoom_sampos;		/* current mouse zoom sample position */
  gint zoom_ofs;		/* length of zoom transform */
  gint zoom_dir;		/* 0: right, 1: left, 2: not determined */
  gboolean zoom_toactv;		/* timeout function active? */
  gint zoom_toid;		/* time out function id */
  gint zoom_totime;		/* time out time (in milliseconds) */
  float zoom_amount;		/* amount to zoom/timeout, < 1 = zoom */

  GdkPixmap *samview_pm;	/* sample view pixmap */

  gint freeze_count;		/* number of freezes on the view */

  GdkColor bg_clr;		/* background color */
  GdkColor sam_clr;		/* sample waveform color */
  GdkColor cline_clr;		/* center line color */
  GdkColor realpos_clr;		/* when zooming, marks the original zoom pos */
  GdkColor selmark_clr;		/* color used for selected marker line */
  GdkColor select_clr;		/* sample selection color */

  GdkGC *bg_gc;			/* background graphics context */
  GdkGC *sam_gc;		/* graphics context for sample waveform */
  GdkGC *cline_gc;		/* center line graphics context */
  GdkGC *realpos_gc;		/* original zoom pos graphics context */
  GdkGC *selmark_gc;		/* selected marker GC */
  GdkGC *select_gc;		/* graphics context for sample selection */
};

struct _SamViewClass
{
  GtkWidgetClass parent_class;

  void (*view_change) (SamView * samview);
  void (*selection_change) (SamView * samview);
};

guint samview_get_type (void);
GtkWidget *samview_new (void);
void samview_freeze (SamView * samview);
void samview_thaw (SamView * samview);
void samview_set_data (SamView * samview, gint16 * data, gint length);
void samview_set_view (SamView * samview, gint start, gint size);
void samview_set_position (SamView * samview, gint start);
gint samview_calc_sample_pos (SamView * samview, gint xpos);
gint samview_calc_xpos (SamView * samview, gint pos);
void samview_new_marker (SamView * samview, GdkColor * color);
void samview_set_marker (SamView * samview, guint marknum, gint loc);
SamViewMark *samview_get_nth_mark (SamView * samview, guint marknum);
gint samview_get_mark_index (SamView * samview, SamViewMark * mark);
void samview_select_marker (SamView * samview, guint marknum);
void samview_unselect_marker (SamView * samview);

/* returns selected marker position (in samples), possibly correcting xpos */
gint samview_set_selected_marker_xpos (SamView * samview, gint * xpos);

void samview_set_selection (SamView * samview, gint start, gint end);

#endif
