/**
 * \file SwamiUIMidiCtrl.h
 * \brief MIDI control user interface object
 */

/*
 * Swami
 * Copyright (C) 1999-2003 Josh Green <jgreen@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA or point your web browser to http://www.gnu.org.
 *
 * To contact the author of this program:
 * Email: Josh Green <jgreen@users.sourceforge.net>
 * Swami homepage: http://swami.sourceforge.net
 */
#ifndef __SWAMIUI_MIDI_CTRL_H__
#define __SWAMIUI_MIDI_CTRL_H__

#include <libswami/SwamiMidi.h>

#include "swamidll.h"

typedef struct _SwamiUIMidiCtrl SwamiUIMidiCtrl;
typedef struct _SwamiUIMidiCtrlClass SwamiUIMidiCtrlClass;

#define SWAMIUI_TYPE_MIDICTRL   (swamiui_midictrl_get_type ())
#define SWAMIUI_MIDICTRL(obj) \
  (GTK_CHECK_CAST ((obj), SWAMIUI_TYPE_MIDICTRL, SwamiUIMidiCtrl))
#define SWAMIUI_MIDICTRL_CLASS(klass) \
  (GTK_CHECK_CLASS_CAST ((klass), SWAMIUI_TYPE_MIDICTRL, SwamiUIMidiCtrlClass))
#define SWAMIUI_IS_MIDICTRL(obj) \
  (GTK_CHECK_TYPE ((obj), SWAMIUI_TYPE_MIDICTRL))
#define SWAMIUI_IS_MIDICTRL_CLASS(klass) \
  (GTK_CHECK_CLASS_TYPE ((klass), SWAMIUI_TYPE_MIDICTRL))

/** Swami User Interface Midi Control object */
struct _SwamiUIMidiCtrl
{
  GtkVBox parent;		/* derived from GtkVBox */

  SwamiMidi *midi;		/* libswami MIDI object */
  GArray *vals;			/* control values for 16 MIDI channels
				     per control */
  int chan;			/* current MIDI channel */

  GList *adj_list;		/* list of control GtkAdjustment objects */
  gboolean block_adj_changed;	/* block adjustment changed handler */

  GtkWidget *glade_widg;	/* currently used glade widget (will
				   change in future to be more flexible) */
};

/** Swami User Interface MIDI Control object class */
struct _SwamiUIMidiCtrlClass
{
  GtkVBoxClass parent_class;

  GArray *params;		/* control parameter array */
};

/* function type to set a control */
typedef void (*SwamiUIMidiCtrlFunc)(SwamiUIMidiCtrl *midictrl, int ctrl_index,
				    gpointer data);

SWAMI_API guint swamiui_midictrl_get_type (void);
SWAMI_API GtkWidget *swamiui_midictrl_new (void);
SWAMI_API void swamiui_midictrl_set_midi_driver (SwamiUIMidiCtrl *midictrl,
						 SwamiMidi *midi);
SWAMI_API void swamiui_midictrl_add_control (char *key, char *name,
					     int low, int high, int def,
					     SwamiUIMidiCtrlFunc func,
					     gpointer data);
SWAMI_API void swamiui_midictrl_adjustment_register (SwamiUIMidiCtrl *midictrl,
						     GtkAdjustment *adj,
						     const char *key);
SWAMI_API void swamiui_midictrl_adjustment_init (SwamiUIMidiCtrl *midictrl,
						 GtkAdjustment *adj,
						 const char *key);
SWAMI_API void swamiui_midictrl_adjustment_update (SwamiUIMidiCtrl *midictrl,
						   GtkAdjustment *adj);

SWAMI_API void swamiui_midictrl_set (SwamiUIMidiCtrl *midictrl,
				     const char *key,int val);
SWAMI_API void swamiui_midictrl_midi_update_all (SwamiUIMidiCtrl *midictrl);

#endif
