/**
 * \file SwamiUIGenCtrl.h
 * \brief UI generator control object header file
 */

/*
 *
 * Swami
 * Copyright (C) 1999-2003 Josh Green <jgreen@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA or point your web browser to http://www.gnu.org.
 *
 * To contact the author of this program:
 * Email: Josh Green <jgreen@users.sourceforge.net>
 * Swami homepage: http://swami.sourceforge.net
 */
#ifndef __SWAMIUI_GENCTRL_H__
#define __SWAMIUI_GENCTRL_H__

#include <gtk/gtk.h>
#include <instpatch.h>

#include "swamidll.h"

typedef struct _SwamiUIGenCtrl SwamiUIGenCtrl;
typedef struct _SwamiUIGenCtrlClass SwamiUIGenCtrlClass;

#define SWAMIUI_TYPE_GENCTRL   (swamiui_genctrl_get_type ())
#define SWAMIUI_GENCTRL(obj) \
  (GTK_CHECK_CAST ((obj), SWAMIUI_TYPE_GENCTRL, SwamiUIGenCtrl))
#define SWAMIUI_GENCTRL_CLASS(klass) \
  (GTK_CHECK_CLASS_CAST ((klass), SWAMIUI_TYPE_GENCTRL, SwamiUIGenCtrlClass))
#define SWAMIUI_IS_GENCTRL(obj) \
  (GTK_CHECK_TYPE ((obj), SWAMIUI_TYPE_GENCTRL))
#define SWAMIUI_IS_GENCTRL_CLASS(klass) \
  (GTK_CHECK_CLASS_TYPE ((klass), SWAMIUI_TYPE_GENCTRL))

struct _SwamiUIGenCtrl
{
  GtkScrolledWindow parent;
  IPZone *zone;			/* Sound font item to sync to */
  GtkWidget *notebook_widg;	/* notebook widget for ctrls */  
  void *ctrl_array;	/* Array of GenCtrls (see SwamiUIGenCtrl.c) */ 
  gboolean block_handlers;	/* flag to block critical callbacks */
  int ctrl_counter;		/* grrrr... */
  gboolean queue_update;	/* queue sync genctrl to zone */
};

struct _SwamiUIGenCtrlClass
{
  GtkScrolledWindowClass parent_class;
};

SWAMI_API guint swamiui_genctrl_get_type (void);
SWAMI_API GtkWidget *swamiui_genctrl_new (void);
SWAMI_API void swamiui_genctrl_set_item (SwamiUIGenCtrl *genctrl,
					 IPItem *item);
SWAMI_API void swamiui_genctrl_update (SwamiUIGenCtrl *genctrl);

#endif
