//  $Id: item.cpp 2405 2008-10-31 20:48:19Z auria $
//
//  SuperTuxKart - a fun racing game with go-kart
//  Copyright (C) 2004 Steve Baker <sjbaker1@airmail.net>
//
//  This program is free software; you can redistribute it and/or
//  modify it under the terms of the GNU General Public License
//  as published by the Free Software Foundation; either version 3
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

#include "items/bubblegumitem.hpp"

BubbleGumItem::BubbleGumItem(ItemType type, const Vec3& xyz, const Vec3 &normal,
                             ssgEntity* model, unsigned int item_id) 
             : Item(type, xyz, normal, model, item_id,
                    /* rotate */ false)
{
}   // BubbleGumItem

//-----------------------------------------------------------------------------
BubbleGumItem::~BubbleGumItem()
{
}   // ~BubbleGumItem

//-----------------------------------------------------------------------------
/** Is called when the item is hit by a kart. The bubble gum item then
 *  inactivates itself for 0.5 seconds, but disables the reappearing of
 *  the bubble gum.
 */
void BubbleGumItem::isCollected(float t)
{
    deactivate(0.5);
    // Set the time till reappear to -1 seconds --> the item will 
    // reappear immediately.
    Item::isCollected(-1);
}   // isCollected
