/*
 * Decompiled with CFR 0.152.
 */
package cadyts.utilities.visualization.network;

import cadyts.supply.network.Link;
import cadyts.supply.network.Network;
import cadyts.supply.network.Node;
import cadyts.utilities.misc.Time;
import cadyts.utilities.visualization.network.NetVis;
import cadyts.utilities.visualization.network.VisLinkData;
import cadyts.utilities.visualization.network.VisNetworkData;
import cadyts.utilities.visualization.network.VisNodeData;

public class MATSimNetworkPreprocessor {
    private static final String EASTING_ATTRIBUTE = "x";
    private static final String NORTHING_ATTRIBUTE = "y";
    private static final String LANES_ATTRIBUTE = "permlanes";
    private static final String LENGTH_ATTRIBUTE = "length";
    private static final String CAPPERIOD_ATTRIBUTE = "capperiod";
    private static final String CAPACITY_PER_CAPPERIOD_ATTRIBUTE = "capacity";

    public VisNetworkData newVisData(Network network) {
        double capperiod_s = Time.secFromStr(network.getLinksAttr(CAPPERIOD_ATTRIBUTE));
        VisNetworkData result = new VisNetworkData();
        result.setMinEasting(Double.POSITIVE_INFINITY);
        result.setMaxEasting(Double.NEGATIVE_INFINITY);
        result.setMinNorthing(Double.POSITIVE_INFINITY);
        result.setMaxNorthing(Double.NEGATIVE_INFINITY);
        for (Node node : network.getNodes()) {
            VisNodeData nodeData = result.getVisNodeData(node);
            nodeData.setEasting(Double.parseDouble(node.getAttr(EASTING_ATTRIBUTE)));
            nodeData.setNorthing(Double.parseDouble(node.getAttr(NORTHING_ATTRIBUTE)));
            result.setMinEasting(Math.min(result.getMinEasting(), nodeData.getEasting()));
            result.setMaxEasting(Math.max(result.getMaxEasting(), nodeData.getEasting()));
            result.setMinNorthing(Math.min(result.getMinNorthing(), nodeData.getNorthing()));
            result.setMaxNorthing(Math.max(result.getMaxNorthing(), nodeData.getNorthing()));
        }
        for (Link link : network.getLinks()) {
            VisLinkData linkData = result.getVisLinkData(link);
            linkData.setLanes((int)Math.round(Double.parseDouble(link.getAttr(LANES_ATTRIBUTE))));
            linkData.setLength_m(Double.parseDouble(link.getAttr(LENGTH_ATTRIBUTE)));
            double cap_veh_s = Double.parseDouble(link.getAttr(CAPACITY_PER_CAPPERIOD_ATTRIBUTE)) / capperiod_s;
            linkData.setVisible(cap_veh_s < 100.0 && linkData.getLength_m() > 1.0);
            linkData.setTransform(NetVis.newLinear2PlaneTransform(link, result.getVisNodeData(link.getFromNode()), result.getVisNodeData(link.getToNode()), linkData.getLength_m()));
        }
        return result;
    }
}

