/*
 * Decompiled with CFR 0.152.
 */
package cadyts.utilities.visualization.network;

import cadyts.supply.network.Link;
import cadyts.supply.network.Network;
import cadyts.utilities.visualization.network.NetJComponent;
import cadyts.utilities.visualization.network.RenderableDynamicData;
import cadyts.utilities.visualization.network.RendererA;
import cadyts.utilities.visualization.network.ValueColorizer;
import cadyts.utilities.visualization.network.VisConfig;
import cadyts.utilities.visualization.network.VisLinkData;
import cadyts.utilities.visualization.network.VisNetworkData;
import cadyts.utilities.visualization.network.VisNodeData;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;

class LinkSetRenderer
extends RendererA {
    private final ValueColorizer colorizer;
    private final Network network;
    private final RenderableDynamicData<Link> data;
    private Image agentPic = null;
    private double laneWidth;

    LinkSetRenderer(VisConfig visConfig, Network network, VisNetworkData netData, RenderableDynamicData<Link> data) {
        super(visConfig, netData);
        this.network = network;
        this.data = data;
        this.colorizer = new ValueColorizer(visConfig.getColorDef());
        this.laneWidth = 4.0 * (double)visConfig.getLinkWidthFactor();
    }

    @Override
    public void setTargetComponent(NetJComponent comp) {
        super.setTargetComponent(comp);
        comp.prepareImage(this.agentPic, comp);
    }

    @Override
    protected synchronized void myRendering(Graphics2D display, AffineTransform boxTransform) {
        this.laneWidth = 4.0 * (double)this.getVisConfig().getLinkWidthFactor();
        NetJComponent comp = this.getNetJComponent();
        AffineTransform originalTransform = display.getTransform();
        display.setStroke(new BasicStroke(Math.round(0.05 * this.laneWidth)));
        for (Link link : this.network.getLinks()) {
            double endNorthing;
            double endEasting;
            double startNorthing;
            VisLinkData linkData = this.netData().getVisLinkData(link);
            if (!linkData.getVisible()) continue;
            VisNodeData fromNodeData = this.netData().getVisNodeData(link.getFromNode());
            VisNodeData toNodeData = this.netData().getVisNodeData(link.getToNode());
            double startEasting = fromNodeData.getEasting();
            if (!comp.checkLineInClip(startEasting, startNorthing = fromNodeData.getNorthing(), endEasting = toNodeData.getEasting(), endNorthing = toNodeData.getNorthing()) || startEasting == endEasting && startNorthing == endNorthing) continue;
            AffineTransform linkTransform = new AffineTransform(originalTransform);
            linkTransform.concatenate(boxTransform);
            linkTransform.concatenate(linkData.getTransform());
            display.setTransform(linkTransform);
            int lanes = this.getVisConfig().getMultiLane() ? linkData.getLanes() : 1;
            int linkLength_m = (int)Math.round(linkData.getLength_m());
            int cellWidth_m = (int)Math.round(this.laneWidth * (double)lanes);
            int cellStart_m = 0;
            if (this.data != null) {
                double value = this.data.getCurrentValue(link);
                display.setColor(this.colorizer.getColor(value));
            } else {
                display.setColor(Color.WHITE);
            }
            display.fillRect(cellStart_m, -cellWidth_m, linkLength_m, cellWidth_m);
            display.setColor(Color.BLACK);
            display.drawRect(cellStart_m, -cellWidth_m, linkLength_m, cellWidth_m);
        }
        display.setTransform(originalTransform);
    }
}

