/*
 * Decompiled with CFR 0.152.
 */
package ui.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import ui.filefilters.ProjectFileFilter;
import ui.filefilters.SUMOFileFilter;

public class DlgNewProject
extends JDialog {
    private static final long serialVersionUID = 1L;
    private int answer = 2;
    private JButton btnBrowseMap = null;
    private JButton btnBrowseSave = null;
    private JButton btnCancel = null;
    private JButton btnOK = null;
    private JDialog dialog = this;
    private JPanel jContentPane = null;
    private JLabel lblLocation = null;
    private JLabel lblMapLocation = null;
    private JTextField txtMapLocation = null;
    private JTextField txtSave = null;

    public DlgNewProject(JFrame frame) {
        super(frame, "New Project", true);
        this.initialize();
        this.setLocationRelativeTo(frame);
        this.setVisible(true);
    }

    public int getAnswer() {
        return this.answer;
    }

    public File getMapFile() {
        return new File(this.txtMapLocation.getText());
    }

    public String getProjectPath() {
        return this.txtSave.getText();
    }

    private JButton getBtnBrowseMap() {
        if (this.btnBrowseMap == null) {
            this.btnBrowseMap = new JButton();
            this.btnBrowseMap.setText("Browse...");
            this.btnBrowseMap.setBounds(new Rectangle(351, 34, 93, 19));
            this.btnBrowseMap.setPreferredSize(new Dimension(87, 20));
            this.btnBrowseMap.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JFileChooser f = new JFileChooser();
                    f.setMultiSelectionEnabled(false);
                    f.setFileSelectionMode(0);
                    f.setDialogTitle("Select a SUMO road network map");
                    f.setFileFilter(new SUMOFileFilter());
                    f.setAcceptAllFileFilterUsed(false);
                    if (f.showOpenDialog(DlgNewProject.this.dialog) == 0) {
                        DlgNewProject.this.getTxtMapLocation().setText(f.getSelectedFile().getAbsolutePath());
                        DlgNewProject.this.getTxtMapLocation().setToolTipText(f.getSelectedFile().getAbsolutePath());
                    }
                }
            });
        }
        return this.btnBrowseMap;
    }

    private JButton getBtnBrowseSave() {
        if (this.btnBrowseSave == null) {
            this.btnBrowseSave = new JButton();
            this.btnBrowseSave.setText("Browse...");
            this.btnBrowseSave.setBounds(new Rectangle(351, 8, 93, 19));
            this.btnBrowseSave.setPreferredSize(new Dimension(87, 20));
            this.btnBrowseSave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JFileChooser f = new JFileChooser();
                    f.setDialogTitle("Select project path");
                    f.setAcceptAllFileFilterUsed(false);
                    f.setFileFilter(new ProjectFileFilter());
                    f.setMultiSelectionEnabled(false);
                    if (f.showSaveDialog(DlgNewProject.this.dialog) == 0) {
                        if (f.getSelectedFile().getAbsolutePath().endsWith(".sumo.prj")) {
                            DlgNewProject.this.getTxtSave().setText(f.getSelectedFile().getAbsolutePath());
                            DlgNewProject.this.getTxtSave().setToolTipText(f.getSelectedFile().getAbsolutePath());
                        } else {
                            DlgNewProject.this.getTxtSave().setText(String.valueOf(f.getSelectedFile().getAbsolutePath()) + ".sumo.prj");
                            DlgNewProject.this.getTxtSave().setToolTipText(String.valueOf(f.getSelectedFile().getAbsolutePath()) + ".sumo.prj");
                        }
                    }
                }
            });
        }
        return this.btnBrowseSave;
    }

    private JButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new JButton();
            this.btnCancel.setText("Cancel");
            this.btnCancel.setBounds(new Rectangle(362, 63, 82, 24));
            this.btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DlgNewProject.this.answer = 2;
                    DlgNewProject.this.dialog.setVisible(false);
                }
            });
        }
        return this.btnCancel;
    }

    private JButton getBtnOK() {
        if (this.btnOK == null) {
            this.btnOK = new JButton();
            this.btnOK.setText("OK");
            this.btnOK.setBounds(new Rectangle(275, 63, 82, 24));
            this.btnOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DlgNewProject.this.answer = 0;
                    if (DlgNewProject.this.txtSave.getText().trim().length() == 0) {
                        JOptionPane.showMessageDialog(DlgNewProject.this.dialog, "Please select the project path");
                        return;
                    }
                    if (DlgNewProject.this.txtMapLocation.getText().trim().length() == 0) {
                        JOptionPane.showMessageDialog(DlgNewProject.this.dialog, "Please select a road network map");
                        return;
                    }
                    if (!new File(DlgNewProject.this.txtMapLocation.getText().trim().replaceFirst(".net.", ".edg.")).exists() || !new File(DlgNewProject.this.txtMapLocation.getText().trim().replaceFirst(".net.", ".nod.")).exists()) {
                        JOptionPane.showMessageDialog(DlgNewProject.this.dialog, "No corresponding edge and/or node file was found for the selected map");
                        return;
                    }
                    DlgNewProject.this.dialog.setVisible(false);
                }
            });
        }
        return this.btnOK;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(null);
            this.jContentPane.add((Component)this.getBtnCancel(), null);
            this.jContentPane.add((Component)this.getLblLocation(), null);
            this.jContentPane.add((Component)this.getTxtSave(), null);
            this.jContentPane.add((Component)this.getBtnBrowseSave(), null);
            this.jContentPane.add((Component)this.getLblMapLocation(), null);
            this.jContentPane.add((Component)this.getTxtMapLocation(), null);
            this.jContentPane.add((Component)this.getBtnBrowseMap(), null);
            this.jContentPane.add((Component)this.getBtnOK(), null);
        }
        return this.jContentPane;
    }

    private JLabel getLblLocation() {
        if (this.lblLocation == null) {
            this.lblLocation = new JLabel();
            this.lblLocation.setHorizontalAlignment(4);
            this.lblLocation.setBounds(new Rectangle(9, 11, 52, 16));
            this.lblLocation.setText("Save as:");
        }
        return this.lblLocation;
    }

    private JLabel getLblMapLocation() {
        if (this.lblMapLocation == null) {
            this.lblMapLocation = new JLabel();
            this.lblMapLocation.setHorizontalAlignment(4);
            this.lblMapLocation.setBounds(new Rectangle(8, 36, 52, 16));
            this.lblMapLocation.setText("Map file:");
        }
        return this.lblMapLocation;
    }

    private JTextField getTxtMapLocation() {
        if (this.txtMapLocation == null) {
            this.txtMapLocation = new JTextField();
            this.txtMapLocation.setPreferredSize(new Dimension(60, 20));
            this.txtMapLocation.setEditable(false);
            this.txtMapLocation.setBounds(new Rectangle(71, 34, 273, 19));
        }
        return this.txtMapLocation;
    }

    private JTextField getTxtSave() {
        if (this.txtSave == null) {
            this.txtSave = new JTextField();
            this.txtSave.setBounds(new Rectangle(71, 8, 273, 19));
            this.txtSave.setEditable(false);
        }
        return this.txtSave;
    }

    private void initialize() {
        this.setSize(459, 127);
        this.setModal(true);
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.setContentPane(this.getJContentPane());
        this.setTitle("New Project");
    }
}

