/*
 * Decompiled with CFR 0.152.
 */
package ui;

import classes.Layer;
import classes.Project;
import classes.ProjectElement;
import enums.EditingMode;
import enums.SelectionType;
import enums.ToolType;
import helpers.Broadcaster;
import helpers.CursorProvider;
import interfaces.CurrentLayerChangedListener;
import interfaces.ProjectChangedListener;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import roadnetwork.Edge;
import roadnetwork.RoadNetwork;
import roadnetwork.RoadNetworkElement;
import trafficdefinition.Accident;
import trafficdefinition.AreaFlow;
import trafficdefinition.Flow;
import trafficdefinition.Handle;
import trafficdefinition.HotSpot;
import trafficdefinition.School;
import trafficdefinition.TrafficArea;
import trafficdefinition.TrafficDefinitionElement;
import trafficdefinition.TrafficDefinitionLayer;

public class Display
extends JComponent
implements CurrentLayerChangedListener,
ProjectChangedListener,
MouseListener,
MouseMotionListener,
MouseWheelListener,
AdjustmentListener,
KeyListener {
    private static final long serialVersionUID = 7162061244639610972L;
    private JScrollBar scrlVertical = null;
    private JScrollBar scrlHorizontal = null;
    private TrafficDefinitionLayer currentTrafficLayer;
    private RoadNetwork roadNetwork;
    private boolean projectLoaded = false;
    private double translateX;
    private double translateY;
    private double mintranslateX;
    private double maxtranslateX;
    private double mintranslateY;
    private double maxtranslateY;
    private double scale;
    private Point previousMouseLocation;
    private boolean areaZoom;
    private ToolType tool = ToolType.None;
    private SelectionType selectionType = SelectionType.New;
    private TrafficDefinitionElement newElement;
    private boolean drawAllTrafficLayers = false;
    private GeneralPath areaPath;
    private boolean creatingNewElement = false;
    private Handle currentHandle = null;
    private Rectangle marquee;
    private Point marqueeStart;
    private Point marqueeEnd;
    private AffineTransform tx = new AffineTransform();
    private EditingMode editingMode;
    private boolean manipulatingHandle = false;

    public Display(JScrollBar scrlvertical, JScrollBar scrlhorizontal) {
        this.scrlVertical = scrlvertical;
        this.scrlHorizontal = scrlhorizontal;
        this.translateX = 0.0;
        this.translateY = 0.0;
        this.scale = 1.0;
        this.setOpaque(true);
        this.setDoubleBuffered(true);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.addKeyListener(this);
        this.scrlVertical.addAdjustmentListener(this);
        this.scrlHorizontal.addAdjustmentListener(this);
        Broadcaster.addProjectChangedListener(this);
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        if (e.getSource() == this.scrlHorizontal) {
            this.translateX = Math.max(this.maxtranslateX, this.mintranslateX) - (double)e.getValue() + Math.min(this.maxtranslateX, this.mintranslateX);
            this.repaint();
        } else if (e.getSource() == this.scrlVertical) {
            this.translateY = Math.max(this.maxtranslateY, this.mintranslateY) - (double)e.getValue() + Math.min(this.maxtranslateY, this.mintranslateY);
            this.repaint();
        }
    }

    @Override
    public void CurrentLayerChanged(Layer<? extends ProjectElement> newCurrentLayer) {
        if (this.currentTrafficLayer != null) {
            this.currentTrafficLayer.SelectNoneElements();
        }
        if (this.roadNetwork != null) {
            this.roadNetwork.SelectNoneElements();
        }
        if (newCurrentLayer instanceof RoadNetwork) {
            this.setEditingMode(EditingMode.Map);
            this.currentTrafficLayer = null;
        } else if (newCurrentLayer instanceof TrafficDefinitionLayer) {
            this.currentTrafficLayer = (TrafficDefinitionLayer)newCurrentLayer;
            this.setEditingMode(EditingMode.GenericTraffic);
        }
        this.repaint();
    }

    public void DeleteSelectedObjects() {
        switch (this.editingMode) {
            case Map: {
                this.roadNetwork.DeleteSelectedElements();
                break;
            }
            case GenericTraffic: {
                this.currentTrafficLayer.DeleteSelectedElements();
            }
        }
        this.repaint();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (!this.projectLoaded) {
            return;
        }
        if (e.getKeyCode() == 127) {
            this.DeleteSelectedObjects();
            return;
        }
        if (e.getKeyCode() == 27 && this.creatingNewElement) {
            this.creatingNewElement = false;
            this.newElement = null;
            this.repaint();
            return;
        }
        if (this.tool == ToolType.Select && e.getKeyCode() == 17) {
            this.setCursor(CursorProvider.getCursor(CursorProvider.Cursors.SelectAdd));
            return;
        }
        if (this.tool == ToolType.Select && e.getKeyCode() == 16) {
            this.setCursor(CursorProvider.getCursor(CursorProvider.Cursors.SelectRemove));
            return;
        }
        if (this.tool == ToolType.Zoom && e.getKeyCode() == 17) {
            this.setCursor(CursorProvider.getCursor(CursorProvider.Cursors.ZoomOut));
            return;
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (!this.projectLoaded) {
            return;
        }
        if (this.tool == ToolType.Select && (e.getKeyCode() == 17 || e.getKeyCode() == 16)) {
            this.setCursor(CursorProvider.getCursor(CursorProvider.Cursors.Select));
            return;
        }
        if (this.tool == ToolType.Zoom && e.getKeyCode() == 17) {
            this.setCursor(CursorProvider.getCursor(CursorProvider.Cursors.ZoomIn));
            return;
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!this.projectLoaded) {
            return;
        }
        Point2D.Double transformedPoint = this.TransformPoint(e.getPoint());
        if (transformedPoint == null) {
            return;
        }
        switch (this.tool) {
            case School: {
                if (e.getButton() == 1) {
                    this.currentTrafficLayer.AddTrafficElement(new School(transformedPoint));
                }
                this.repaint();
                break;
            }
            case Hotspot: {
                if (this.creatingNewElement && e.getButton() == 3) {
                    this.creatingNewElement = false;
                    this.newElement = null;
                    this.repaint();
                    return;
                }
                if (this.creatingNewElement) {
                    ((HotSpot)this.newElement).createHandles();
                    this.currentTrafficLayer.AddTrafficElement(this.newElement);
                    this.newElement = null;
                    this.creatingNewElement = false;
                    this.repaint();
                } else {
                    this.newElement = new HotSpot(transformedPoint);
                    this.creatingNewElement = true;
                }
                return;
            }
            case AreaFlow: {
                if (this.creatingNewElement && e.getButton() == 3) {
                    this.creatingNewElement = false;
                    this.newElement = null;
                    this.repaint();
                    return;
                }
                if (this.creatingNewElement) {
                    AreaFlow newFlow = (AreaFlow)this.newElement;
                    ++newFlow.constructionPhase;
                    if (newFlow.constructionPhase == 3) {
                        newFlow.createHandles();
                        this.currentTrafficLayer.AddTrafficElement(this.newElement);
                        this.creatingNewElement = false;
                        this.newElement = null;
                        this.repaint();
                    }
                } else {
                    this.newElement = new AreaFlow();
                    ((AreaFlow)this.newElement).setStartAreaCenter(transformedPoint);
                    ((AreaFlow)this.newElement).constructionPhase = 0;
                    this.creatingNewElement = true;
                }
                return;
            }
            case Flow: {
                RoadNetworkElement elementBelowMouse = (RoadNetworkElement)this.roadNetwork.PointHitTest(transformedPoint);
                if (this.creatingNewElement && (e.getButton() == 3 || elementBelowMouse == null || !(elementBelowMouse instanceof Edge))) {
                    this.creatingNewElement = false;
                    this.newElement = null;
                    this.repaint();
                    return;
                }
                if (elementBelowMouse != null && elementBelowMouse instanceof Edge) {
                    if (this.creatingNewElement) {
                        ((Flow)this.newElement).setTo(new Point2D.Double(elementBelowMouse.getBounds().getCenterX(), elementBelowMouse.getBounds().getCenterY()));
                        ((Flow)this.newElement).setEnd((Edge)elementBelowMouse);
                        ((Flow)this.newElement).SetDependencies();
                        this.currentTrafficLayer.AddTrafficElement(this.newElement);
                        this.creatingNewElement = false;
                        this.newElement = null;
                        this.repaint();
                    } else {
                        this.newElement = new Flow();
                        ((Flow)this.newElement).setStart((Edge)elementBelowMouse);
                        ((Flow)this.newElement).setFrom(new Point2D.Float((float)elementBelowMouse.getBounds().getCenterX(), (float)elementBelowMouse.getBounds().getCenterY()));
                        this.creatingNewElement = true;
                    }
                }
                return;
            }
            case Accident: {
                RoadNetworkElement elementBelowMouse2 = (RoadNetworkElement)this.roadNetwork.PointHitTest(transformedPoint);
                if (elementBelowMouse2 != null && elementBelowMouse2 instanceof Edge && e.getButton() == 1) {
                    this.currentTrafficLayer.AddTrafficElement(new Accident((Edge)elementBelowMouse2, transformedPoint));
                }
                this.repaint();
                break;
            }
            case Select: {
                switch (this.editingMode) {
                    case Map: {
                        if (e.isControlDown()) {
                            this.roadNetwork.AlterSelection(new Rectangle((int)Math.round(transformedPoint.x), (int)Math.round(transformedPoint.y), 1, 1), SelectionType.Add);
                        } else if (e.isShiftDown()) {
                            this.roadNetwork.AlterSelection(new Rectangle((int)Math.round(transformedPoint.x), (int)Math.round(transformedPoint.y), 1, 1), SelectionType.Remove);
                        } else {
                            this.roadNetwork.AlterSelection(new Rectangle((int)Math.round(transformedPoint.x), (int)Math.round(transformedPoint.y), 1, 1), this.selectionType);
                        }
                        this.repaint();
                        break;
                    }
                    case GenericTraffic: {
                        if (e.isControlDown()) {
                            this.currentTrafficLayer.AlterSelection(new Rectangle((int)Math.round(transformedPoint.x), (int)Math.round(transformedPoint.y), 1, 1), SelectionType.Add);
                        } else if (e.isShiftDown()) {
                            this.currentTrafficLayer.AlterSelection(new Rectangle((int)Math.round(transformedPoint.x), (int)Math.round(transformedPoint.y), 1, 1), SelectionType.Remove);
                        } else {
                            this.currentTrafficLayer.AlterSelection(new Rectangle((int)Math.round(transformedPoint.x), (int)Math.round(transformedPoint.y), 1, 1), this.selectionType);
                        }
                        this.repaint();
                    }
                }
                break;
            }
            case Zoom: {
                if (e.isControlDown()) {
                    if ((double)this.getWidth() > this.roadNetwork.getBounds().width * this.scale && (double)this.getHeight() > this.roadNetwork.getBounds().height * this.scale) {
                        return;
                    }
                    this.scale -= 0.5;
                } else {
                    this.scale += 0.5;
                }
                this.MoveMapPointToDisplayCenter(transformedPoint);
                this.UpdateScrollBars();
                this.repaint();
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.projectLoaded) {
            return;
        }
        Point2D.Double transformedPoint = this.TransformPoint(e.getPoint());
        if (transformedPoint == null) {
            return;
        }
        switch (this.tool) {
            case Pan: {
                this.translateX += (double)e.getX() - this.previousMouseLocation.getX();
                this.translateY += (double)e.getY() - this.previousMouseLocation.getY();
                this.previousMouseLocation = e.getPoint();
                this.UpdateScrollBars();
                this.repaint();
                break;
            }
            case Zoom: {
                this.areaZoom = true;
                this.marqueeEnd = e.getPoint();
                this.marquee.setFrameFromDiagonal(this.marqueeStart, this.marqueeEnd);
                this.repaint();
                break;
            }
            case Select: {
                if (this.manipulatingHandle) {
                    this.currentHandle.setLocationAndNotify(transformedPoint);
                } else {
                    this.areaZoom = true;
                    this.marqueeEnd = e.getPoint();
                    this.marquee.setFrameFromDiagonal(this.marqueeStart, this.marqueeEnd);
                }
                this.repaint();
                break;
            }
            case Area: {
                this.areaPath.lineTo((float)transformedPoint.x, (float)transformedPoint.y);
                this.repaint();
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.setFocusable(true);
        this.requestFocus(true);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.manipulatingHandle = false;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (!this.projectLoaded) {
            return;
        }
        Point2D.Double transformedPoint = this.TransformPoint(e.getPoint());
        if (transformedPoint == null) {
            return;
        }
        ProjectElement trafficElementBelowMouse = null;
        RoadNetworkElement roadElementBelowMouse = (RoadNetworkElement)this.roadNetwork.PointHitTest(transformedPoint);
        if (this.currentTrafficLayer != null) {
            trafficElementBelowMouse = (TrafficDefinitionElement)this.currentTrafficLayer.PointHitTest(transformedPoint);
        }
        if (trafficElementBelowMouse != null) {
            this.setToolTipText(trafficElementBelowMouse.getToolTip());
        } else if (roadElementBelowMouse != null) {
            this.setToolTipText(roadElementBelowMouse.getToolTip());
        } else {
            this.setToolTipText(null);
        }
        switch (this.tool) {
            case Select: {
                this.currentHandle = null;
                boolean overHandle = false;
                if (this.currentTrafficLayer != null) {
                    List<TrafficDefinitionElement> selectedTrafficElements = this.currentTrafficLayer.getSelectedElements();
                    for (TrafficDefinitionElement t : selectedTrafficElements) {
                        this.currentHandle = t.handleHit(e.getPoint(), this.tx);
                        if (this.currentHandle == null) continue;
                        overHandle = true;
                        break;
                    }
                }
                if (overHandle) {
                    this.setCursor(CursorProvider.getCursor(CursorProvider.Cursors.Hand));
                    break;
                }
                this.setCursor(CursorProvider.getCursor(CursorProvider.Cursors.Select));
                break;
            }
            case Hotspot: {
                if (!this.creatingNewElement) break;
                HotSpot newHotSpot = (HotSpot)this.newElement;
                newHotSpot.setRadius(transformedPoint);
                this.repaint();
                break;
            }
            case AreaFlow: {
                if (!this.creatingNewElement) break;
                AreaFlow newFlow = (AreaFlow)this.newElement;
                switch (newFlow.constructionPhase) {
                    case 0: {
                        newFlow.setStartAreaRadius(transformedPoint);
                        break;
                    }
                    case 1: {
                        newFlow.setEndAreaCenter(transformedPoint);
                        break;
                    }
                    case 2: {
                        newFlow.setEndAreaRadius(transformedPoint);
                    }
                }
                this.repaint();
                break;
            }
            case Flow: {
                if (roadElementBelowMouse != null && roadElementBelowMouse instanceof Edge) {
                    this.setCursor(Cursor.getPredefinedCursor(1));
                } else {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                }
                if (!this.creatingNewElement) {
                    return;
                }
                ((Flow)this.newElement).setTo(transformedPoint);
                this.repaint();
                break;
            }
            case Accident: {
                if (roadElementBelowMouse != null && roadElementBelowMouse instanceof Edge) {
                    this.setCursor(Cursor.getPredefinedCursor(1));
                    break;
                }
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.projectLoaded) {
            return;
        }
        this.previousMouseLocation = e.getPoint();
        Point2D.Double transformedPoint = this.TransformPoint(e.getPoint());
        if (transformedPoint == null) {
            return;
        }
        switch (this.tool) {
            case Select: {
                if (this.currentHandle != null) {
                    this.setCursor(CursorProvider.getCursor(CursorProvider.Cursors.HandClosed));
                    this.manipulatingHandle = true;
                    break;
                }
                if (this.selectionType == SelectionType.New && !e.isShiftDown() && !e.isControlDown()) {
                    switch (this.editingMode) {
                        case Map: {
                            this.roadNetwork.SelectNoneElements();
                            break;
                        }
                        case GenericTraffic: {
                            this.currentTrafficLayer.SelectNoneElements();
                        }
                    }
                }
                this.areaZoom = false;
                this.marquee = new Rectangle();
                this.marqueeStart = e.getPoint();
                this.manipulatingHandle = false;
                break;
            }
            case Zoom: {
                this.areaZoom = false;
                this.marquee = new Rectangle();
                this.marqueeStart = e.getPoint();
                break;
            }
            case Pan: {
                this.setCursor(CursorProvider.getCursor(CursorProvider.Cursors.HandClosed));
                break;
            }
            case Area: {
                this.areaPath = new GeneralPath();
                this.areaPath.moveTo((float)transformedPoint.x, (float)transformedPoint.y);
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.projectLoaded) {
            return;
        }
        switch (this.tool) {
            case Pan: {
                this.setCursor(CursorProvider.getCursor(CursorProvider.Cursors.Hand));
                break;
            }
            case Zoom: {
                if (!this.areaZoom || this.marquee.height * this.marquee.width < 10) {
                    return;
                }
                Point2D.Double transformedMarqueeStart = this.TransformPoint(this.marqueeStart);
                Point2D.Double transformedMarqueeEnd = this.TransformPoint(this.marqueeEnd);
                if (transformedMarqueeStart == null || transformedMarqueeEnd == null) {
                    return;
                }
                Rectangle transformedRectangle = new Rectangle();
                transformedRectangle.setFrameFromDiagonal(transformedMarqueeStart, transformedMarqueeEnd);
                this.ZoomToRectangleAndCenter(transformedRectangle);
                this.UpdateScrollBars();
                this.marquee = null;
                this.repaint();
                break;
            }
            case Select: {
                if (this.manipulatingHandle) {
                    this.manipulatingHandle = false;
                    break;
                }
                if (!this.areaZoom || this.marquee.height * this.marquee.width < 10) {
                    return;
                }
                Point2D.Double transformedMarqueeStart1 = this.TransformPoint(this.marqueeStart);
                Point2D.Double transformedMarqueeEnd1 = this.TransformPoint(this.marqueeEnd);
                if (transformedMarqueeStart1 == null || transformedMarqueeEnd1 == null) {
                    return;
                }
                Rectangle transformedRectangle1 = new Rectangle();
                transformedRectangle1.setFrameFromDiagonal(transformedMarqueeStart1, transformedMarqueeEnd1);
                switch (this.editingMode) {
                    case Map: {
                        if (e.isControlDown()) {
                            this.roadNetwork.AlterSelection(transformedRectangle1, SelectionType.Add);
                        } else if (e.isShiftDown()) {
                            this.roadNetwork.AlterSelection(transformedRectangle1, SelectionType.Remove);
                        } else {
                            this.roadNetwork.AlterSelection(transformedRectangle1, this.selectionType);
                        }
                        this.repaint();
                        break;
                    }
                    case GenericTraffic: {
                        if (e.isControlDown()) {
                            this.currentTrafficLayer.AlterSelection(transformedRectangle1, SelectionType.Add);
                        } else if (e.isShiftDown()) {
                            this.currentTrafficLayer.AlterSelection(transformedRectangle1, SelectionType.Remove);
                        } else {
                            this.currentTrafficLayer.AlterSelection(transformedRectangle1, this.selectionType);
                        }
                        this.repaint();
                    }
                }
                this.marquee = null;
                this.repaint();
                break;
            }
            case Area: {
                this.areaPath.closePath();
                this.currentTrafficLayer.AddTrafficElement(new TrafficArea(this.areaPath));
                this.areaPath = null;
                this.repaint();
            }
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (e.getScrollType() == 0) {
            if (e.getWheelRotation() < 0 && (double)this.getWidth() > this.roadNetwork.getBounds().width * this.scale && (double)this.getHeight() > this.roadNetwork.getBounds().height * this.scale) {
                return;
            }
            Point2D.Double transformedPoint = this.TransformPoint(e.getPoint());
            if (transformedPoint == null) {
                return;
            }
            this.scale += 0.01 * (double)e.getWheelRotation();
            this.MoveMapPointToDisplayPoint(transformedPoint, e.getPoint());
            this.UpdateScrollBars();
            this.repaint();
        }
    }

    private void MoveMapPointToDisplayPoint(Point2D.Double mapPoint, Point displayPoint) {
        this.translateX = (double)displayPoint.x - mapPoint.x * this.scale;
        this.translateY = (double)displayPoint.y + mapPoint.y * this.scale;
    }

    public void MoveMapPointToDisplayCenter(Point2D.Double mapPoint) {
        this.MoveMapPointToDisplayPoint(mapPoint, new Point(this.getWidth() / 2, this.getHeight() / 2));
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D graphics2D = (Graphics2D)g;
        Rectangle clip = graphics2D.getClipBounds();
        if (clip.x != 0 || clip.y != 0) {
            this.repaint();
            return;
        }
        graphics2D.setColor(Color.GRAY);
        graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (!this.projectLoaded) {
            return;
        }
        this.tx.setToIdentity();
        this.tx.translate(this.translateX, this.translateY);
        this.tx.scale(this.scale, -this.scale);
        graphics2D.setTransform(this.tx);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(Color.WHITE);
        graphics2D.fill(this.roadNetwork.getBounds());
        graphics2D.setColor(Color.BLACK);
        graphics2D.draw(this.roadNetwork.getBounds());
        this.roadNetwork.Draw(graphics2D, this.scale);
        if (this.drawAllTrafficLayers) {
            for (TrafficDefinitionLayer tdl : Project.getCurrentlyLoadedProject().getTrafficLayers()) {
                tdl.Draw(graphics2D, this.scale);
            }
        } else if (this.currentTrafficLayer != null) {
            this.currentTrafficLayer.Draw(graphics2D, this.scale);
        }
        if (this.newElement != null) {
            graphics2D.setColor(Color.RED);
            this.newElement.Draw(graphics2D, this.scale, false, false);
        }
        if (this.areaPath != null) {
            graphics2D.setColor(new Color(120, 65, 87, 125));
            graphics2D.fill(this.areaPath);
        }
        if (this.marquee != null) {
            graphics2D.setTransform(new AffineTransform());
            graphics2D.setColor(Color.RED);
            graphics2D.draw(this.marquee);
        }
    }

    @Override
    public void ProjectChanged(Project project) {
        if (project == null) {
            this.projectLoaded = false;
            this.roadNetwork = null;
            this.currentTrafficLayer = null;
            this.repaint();
        } else {
            this.projectLoaded = true;
            this.roadNetwork = project.getRoadNetwork();
            this.ZoomToFitAndCenter();
            this.UpdateScrollBars();
            this.setEditingMode(EditingMode.Map);
        }
    }

    public void Refresh() {
        this.repaint();
    }

    public void SelectAll() {
        switch (this.editingMode) {
            case Map: {
                this.roadNetwork.SelectAllElements();
                break;
            }
            case GenericTraffic: {
                this.currentTrafficLayer.SelectAllElements();
            }
        }
        this.repaint();
    }

    public void SelectInverse() {
        switch (this.editingMode) {
            case Map: {
                this.roadNetwork.SelectInverseElements();
                break;
            }
            case GenericTraffic: {
                this.currentTrafficLayer.SelectInverseElements();
            }
        }
        this.repaint();
    }

    public void SelectNone() {
        switch (this.editingMode) {
            case Map: {
                this.roadNetwork.SelectNoneElements();
                break;
            }
            case GenericTraffic: {
                this.currentTrafficLayer.SelectNoneElements();
            }
        }
        this.repaint();
    }

    public void setEditingMode(EditingMode newMode) {
        this.editingMode = newMode;
    }

    public void setSelectionType(SelectionType selectionType) {
        this.selectionType = selectionType;
    }

    public void setShowDeleted(boolean b) {
        if (!this.projectLoaded) {
            return;
        }
        this.roadNetwork.setShowDeleted(b);
        this.repaint();
    }

    public void setDrawAllTrafficLayers(boolean b) {
        this.drawAllTrafficLayers = b;
    }

    public void setTool(ToolType tool) {
        this.tool = tool;
        switch (tool) {
            case Pan: {
                this.setCursor(CursorProvider.getCursor(CursorProvider.Cursors.Hand));
                break;
            }
            case Zoom: {
                this.setCursor(CursorProvider.getCursor(CursorProvider.Cursors.ZoomIn));
                break;
            }
            case Select: {
                this.setCursor(CursorProvider.getCursor(CursorProvider.Cursors.Select));
                break;
            }
            default: {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    public void UndeleteSelectedObjects() {
        this.roadNetwork.UndeleteSelectedMapElements();
        this.repaint();
    }

    public void ZoomToFitAndCenter() {
        if (!this.projectLoaded) {
            return;
        }
        this.ZoomToRectangleAndCenter(this.roadNetwork.getBounds());
        this.UpdateScrollBars();
        this.repaint();
    }

    private Point2D.Double TransformPoint(Point p) {
        try {
            return (Point2D.Double)this.tx.inverseTransform(new Point2D.Double(p.getX(), p.getY()), null);
        }
        catch (NoninvertibleTransformException e) {
            return null;
        }
    }

    private void UpdateScrollBars() {
        this.mintranslateX = (double)(this.getWidth() / 2) - this.roadNetwork.getBounds().getMinX() * this.scale;
        this.maxtranslateX = (double)(this.getWidth() / 2) - this.roadNetwork.getBounds().getMaxX() * this.scale;
        this.mintranslateY = (double)(this.getHeight() / 2) + this.roadNetwork.getBounds().getMinY() * this.scale;
        this.maxtranslateY = (double)(this.getHeight() / 2) + this.roadNetwork.getBounds().getMaxY() * this.scale;
        this.scrlVertical.removeAdjustmentListener(this);
        this.scrlVertical.setMinimum((int)Math.min(this.mintranslateY, this.maxtranslateY));
        this.scrlVertical.setMaximum((int)Math.max(this.mintranslateY, this.maxtranslateY));
        this.scrlVertical.setValue((int)(-this.translateY) + (int)Math.max(this.maxtranslateY, this.mintranslateY) + (int)Math.min(this.maxtranslateY, this.mintranslateY));
        this.scrlVertical.addAdjustmentListener(this);
        this.scrlHorizontal.removeAdjustmentListener(this);
        this.scrlHorizontal.setMinimum((int)Math.min(this.mintranslateX, this.maxtranslateX));
        this.scrlHorizontal.setMaximum((int)Math.max(this.mintranslateX, this.maxtranslateX));
        this.scrlHorizontal.setValue((int)(-this.translateX) + (int)Math.max(this.maxtranslateX, this.mintranslateX) + (int)Math.min(this.maxtranslateX, this.mintranslateX));
        this.scrlHorizontal.addAdjustmentListener(this);
    }

    private void ZoomToRectangleAndCenter(RectangularShape rectangle) {
        if (rectangle.getHeight() > rectangle.getWidth()) {
            this.scale = (double)this.getHeight() / rectangle.getHeight();
        } else if (rectangle.getHeight() < rectangle.getWidth()) {
            this.scale = (double)this.getWidth() / rectangle.getWidth();
        } else {
            int minDimension = Math.min(this.getWidth(), this.getHeight());
            this.scale = (double)minDimension / rectangle.getWidth();
        }
        this.MoveMapPointToDisplayCenter(new Point2D.Double(rectangle.getCenterX(), rectangle.getCenterY()));
    }

    public void CenterAndZoomOnElement(ProjectElement element) {
        this.MoveMapPointToDisplayCenter(new Point2D.Double(element.getBounds().getCenterX(), element.getBounds().getCenterY()));
        this.UpdateScrollBars();
        this.repaint();
    }
}

