/*
 * Decompiled with CFR 0.152.
 */
package simulation;

import classes.TypeSelection;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import roadnetwork.Edge;
import simulation.Adult;
import simulation.Child;
import simulation.Route;
import simulation.SUMOInstructionList;
import simulation.Trip;
import simulation.VehicleType;
import trafficdefinition.School;
import trafficdefinition.TrafficArea;

public class House {
    private List<Adult> adults = new ArrayList<Adult>();
    private List<Child> children = new ArrayList<Child>();
    private Edge address;
    private TrafficArea area;
    private int id;
    private Point2D.Double location;

    public House(TrafficArea area, int id) {
        this.id = id;
        this.area = area;
    }

    public void assignVehiclesToDrivers(float possibilityDriverHasCar, TypeSelection<VehicleType> areaVehicleTypes) {
        ArrayList<VehicleType> vehicles = new ArrayList<VehicleType>();
        int numberOfVehicles = Math.round(possibilityDriverHasCar * (float)this.getNumberOfDrivers());
        int i = 0;
        while (i < numberOfVehicles) {
            vehicles.add(areaVehicleTypes.getRandomType());
            ++i;
        }
        ArrayList<VehicleType> availableVehicles = new ArrayList<VehicleType>();
        availableVehicles.addAll(vehicles);
        List<Adult> availableWorkingDriverAdults = this.getWorkingDrivers();
        List<Adult> availableNonWorkingDriverAdults = this.getNonWorkingDrivers();
        while (!availableVehicles.isEmpty()) {
            if (!availableWorkingDriverAdults.isEmpty()) {
                availableWorkingDriverAdults.get(0).setVehicle((VehicleType)availableVehicles.get(0));
                availableWorkingDriverAdults.remove(0);
            } else {
                availableNonWorkingDriverAdults.get(0).setVehicle((VehicleType)availableVehicles.get(0));
                availableNonWorkingDriverAdults.remove(0);
            }
            availableVehicles.remove(0);
        }
    }

    public void createActivities(SUMOInstructionList<Trip> tripsList, SUMOInstructionList<Route> routesList) throws Exception {
        String color = String.valueOf(new Float((float)this.area.getColor().getRed() / 255.0f).toString()) + "," + new Float((float)this.area.getColor().getGreen() / 255.0f).toString() + "," + new Float((float)this.area.getColor().getBlue() / 255.0f).toString();
        Hashtable childrenBySchool = new Hashtable();
        ArrayList<School> schools = new ArrayList<School>();
        for (Child c : this.children) {
            if (c.getSchool() == null) continue;
            if (!childrenBySchool.containsKey(c.getSchool())) {
                childrenBySchool.put(c.getSchool(), new ArrayList());
                schools.add(c.getSchool());
            }
            ((List)childrenBySchool.get(c.getSchool())).add(c);
        }
        Collections.sort(schools, new School.SchoolPriorityComparator());
        block1: for (School school : schools) {
            for (Adult a : this.getAdultsWithVehicleOrderByEmploymentStatus()) {
                if (!a.canTakeChildToSchool(school, 600)) continue;
                a.takeChildrenToSchool((List)childrenBySchool.get(school));
                break;
            }
            for (Adult a : this.getAdultsWithVehicleOrderByEmploymentStatus()) {
                if (!a.canPickupChildFromSchool(school)) continue;
                a.pickupChildrenFromSchool((List)childrenBySchool.get(school));
                continue block1;
            }
        }
        int adultCounter = 0;
        for (Adult a : this.adults) {
            a.createTrips(color, tripsList, routesList, adultCounter++);
        }
    }

    public void createAdults(int numberOfAdults, float possibilityAdultIsDriver, float possibilityAdultHasJob) {
        int i = 0;
        while (i < numberOfAdults) {
            this.adults.add(new Adult(this, possibilityAdultIsDriver, possibilityAdultHasJob));
            ++i;
        }
    }

    public void createChildren(int numberOfChildren) {
        int i = 0;
        while (i < numberOfChildren) {
            this.children.add(new Child());
            ++i;
        }
    }

    public List<Child> getChildren() {
        return this.children;
    }

    public Edge getAddress() {
        return this.address;
    }

    public Point2D.Double getLocation() {
        return this.location;
    }

    public int getNumberOfResidents() {
        return this.adults.size() + this.children.size();
    }

    public List<Adult> getWorkingAdults() {
        ArrayList<Adult> result = new ArrayList<Adult>();
        for (Adult a : this.adults) {
            if (!a.hasJob()) continue;
            result.add(a);
        }
        return result;
    }

    public void setAddress(Edge closestEdge) {
        this.address = closestEdge;
    }

    public void setLocation(Point2D.Double location) {
        this.location = location;
    }

    private List<Adult> getNonWorkingDrivers() {
        ArrayList<Adult> nonWorkingDrivers = new ArrayList<Adult>();
        for (Adult a : this.adults) {
            if (!a.canDrive() || a.hasJob()) continue;
            nonWorkingDrivers.add(a);
        }
        return nonWorkingDrivers;
    }

    private List<Adult> getAdultsWithVehicleOrderByEmploymentStatus() {
        ArrayList<Adult> result = new ArrayList<Adult>();
        for (Adult a : this.adults) {
            if (a.hasJob() || a.getVehicle() == null) continue;
            result.add(a);
        }
        for (Adult a : this.adults) {
            if (!a.hasJob() || a.getVehicle() == null) continue;
            result.add(a);
        }
        return result;
    }

    private int getNumberOfDrivers() {
        int drivers = 0;
        for (Adult a : this.adults) {
            if (!a.canDrive()) continue;
            ++drivers;
        }
        return drivers;
    }

    private List<Adult> getWorkingDrivers() {
        ArrayList<Adult> workingDrivers = new ArrayList<Adult>();
        for (Adult a : this.adults) {
            if (!a.canDrive() || !a.hasJob()) continue;
            workingDrivers.add(a);
        }
        return workingDrivers;
    }

    public int getId() {
        return this.id;
    }
}

