/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.map.proj;

import com.jhlabs.map.MapMath;
import com.jhlabs.map.proj.CylindricalProjection;
import com.jhlabs.map.proj.ProjectionException;
import java.awt.geom.Point2D;

public class TCCProjection
extends CylindricalProjection {
    public TCCProjection() {
        this.minLongitude = MapMath.degToRad(-60.0);
        this.maxLongitude = MapMath.degToRad(60.0);
    }

    public Point2D.Double project(double lplam, double lpphi, Point2D.Double out) {
        double d;
        double b = Math.cos(lpphi) * Math.sin(lplam);
        double bt = 1.0 - b * b;
        if (d < 1.0E-10) {
            throw new ProjectionException("F");
        }
        out.x = b / Math.sqrt(bt);
        out.y = Math.atan2(Math.tan(lpphi), Math.cos(lplam));
        return out;
    }

    public boolean isRectilinear() {
        return false;
    }

    public String toString() {
        return "Transverse Central Cylindrical";
    }
}

