/*
 * Decompiled with CFR 0.152.
 */
package cadyts.interfaces.dracula;

import cadyts.demand.BasicPlan;
import cadyts.demand.PlanBuilder;
import cadyts.interfaces.dracula.DraculaLink;
import cadyts.interfaces.dracula.DraculaODRelation;
import cadyts.interfaces.dracula.DraculaRoute;
import cadyts.interfaces.dracula.DraculaTravelTimes;
import java.util.List;
import java.util.logging.Logger;

class DraculaPlan
extends BasicPlan<DraculaLink> {
    private final DraculaRoute route;
    private final int departureTime_s;

    DraculaPlan(DraculaRoute route, int dptTime_s, PlanBuilder<DraculaLink> planBuilder, DraculaTravelTimes travelTimes) {
        if (route == null) {
            throw new IllegalArgumentException("route is null");
        }
        if (route.getId() > 0L && travelTimes == null) {
            throw new IllegalArgumentException("travel times are null but route is not empty");
        }
        this.route = route;
        this.departureTime_s = dptTime_s;
        if (planBuilder == null) {
            throw new IllegalArgumentException("planBuilder is null");
        }
        if (!this.isStayAtHome()) {
            List<DraculaLink> links = route.getLinks();
            if (links.size() > 0) {
                planBuilder.reset(this);
                int time_s = dptTime_s;
                DraculaLink link = links.get(0);
                planBuilder.addEntry(link, time_s);
                time_s = (int)((double)time_s + travelTimes.getTT_s(link, time_s));
                int i = 1;
                while (i < links.size()) {
                    link = links.get(i);
                    planBuilder.addTurn(link, time_s);
                    time_s = (int)((double)time_s + travelTimes.getTT_s(link, time_s));
                    ++i;
                }
                planBuilder.addExit(time_s);
            } else {
                Logger.getLogger(this.getClass().getName()).warning("non-stay-at-home route " + route.getId() + " has zero links");
            }
        }
        this.trim();
    }

    protected DraculaRoute getRoute() {
        return this.route;
    }

    int getDepartureTime_s() {
        return this.departureTime_s;
    }

    DraculaODRelation getOD() {
        return this.route.getOD();
    }

    boolean isStayAtHome() {
        return this.route.getId() == 0L;
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.getClass().getSimpleName());
        result.append("(dptTime_s = ");
        result.append(this.departureTime_s);
        result.append(", route = ");
        result.append(this.route);
        result.append(", link_entries = ");
        result.append(super.toString());
        result.append(")");
        return result.toString();
    }
}

