/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_CHECKOUTCMD_H
#define _SC_CHECKOUTCMD_H

// sc
#include "ScCmd.h"
#include "svn/svn.h"
class CheckoutParam;
class CmdResultCallback;

/**
 * Command for checking out a working copy.
 */
class CheckoutCmd : public ScCmd
{
public:
  /**
   * Construct a CheckoutCmd.
   *
   * \param param the parameters for the command.
   * \param cb the callback that gets called when the command has finished.
   * The command takes ownership the callback.
   */
  CheckoutCmd( CheckoutParam* param, CmdResultCallback* cb );
  ~CheckoutCmd();

  void run();

private:
  // in
  CheckoutParam*     _param;

  // out
  CmdResultCallback* _cb;
};

#endif // _SC_CHECKOUTCMD_H
