/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SVN_VISUALDIFF_H
#define _SVN_VISUALDIFF_H

// util
#include "util/String.h"

// apr
struct apr_pool_t;

// svn
struct svn_error_t;
struct svn_client_ctx_t;
struct svn_opt_revision_t;


namespace svn
{

/**
 * prepare and run visual diffs
 */
class VisualDiff
{
public:
  VisualDiff( svn_client_ctx_t* context, const sc::String& diffCmd,
    apr_pool_t* pool );
  ~VisualDiff();

  svn_error_t* run( const char* path1, const svn_opt_revision_t* revision1,
    const char* path2, const svn_opt_revision_t* revision2 );

  svn_error_t* run( const char* path, const svn_opt_revision_t* revision1,
    const svn_opt_revision_t* revision2, const svn_opt_revision_t* peg );

private:
  svn_error_t* diffWcWc( const char* path1, const svn_opt_revision_t* revision1,
    const char* path2, const svn_opt_revision_t* revision2 );

  svn_error_t* diffRpRp( const char* path1, const svn_opt_revision_t* revision1,
    const char* path2, const svn_opt_revision_t* revision2, const
    svn_opt_revision_t* peg  );

  svn_error_t* diffRpWc( const char* path1, const svn_opt_revision_t* revision1,
    const char* path2, const svn_opt_revision_t* revision2, const
    svn_opt_revision_t* peg, bool rpwc );

  svn_error_t* run( const char* path1, const char* label1, const char* path2,
    const char* label2 );

private:
  apr_pool_t*       _pool;
  svn_client_ctx_t* _context;
  sc::String        _diffCmd;

  sc::String _removePath1;
  sc::String _removePath2;
};

} // namespace

#endif // _SVN_VISUALDIFF_H
