/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _PAINTER_SETUP_H
#define _PAINTER_SETUP_H

// qt
#include <qrect.h>
#include <qwidget.h>
#include <qpixmap.h>
#include <qpainter.h>


class PainterSetup
{
public:
  PainterSetup( QWidget* w, const QRect& pr, bool doubleBuffer = true )
    : _w(w), _pr(pr)
  {
    if( doubleBuffer )
    {
      _pm.resize( _pr.width(), _pr.height() );
      _pp.begin(&_pm);
      _pp.setFont(_w->font());
      _pp.setClipRect( 0, 0, _pr.width(), _pr.height() );

      // this lets us draw into the buffer with the same
      // coordinates  we use to draw into the window.
      _pp.translate( -_pr.x(), -_pr.y() );
    }
    else
    {
      _pp.begin(_w);
    }
  }

  ~PainterSetup()
  {
    if( _pm.isNull() )
    {
      return;
    }

    _pp.end();
    bitBlt( _w, _pr.topLeft(), &_pm );
  }

  QPainter& getPainter()
  {
    return _pp;
  }

private:
  QWidget*  _w;
  QRect     _pr;
  QPixmap   _pm;
  QPainter  _pp;
};


#endif // _PAINTER_SETUP_H

