/* ====================================================================
 * Copyright 2006,          Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "config.h"
#include "SubversionSettingsWidget.h"
#include "util/String.h"

// qt
#include <qlayout.h>
#include <qcheckbox.h>
#include <qtooltip.h>


SubversionSettingsWidget::SubversionSettingsWidget( QWidget *parent )
: super(parent,0)
{
  QVBoxLayout* vl = new QVBoxLayout(this);
  {
#ifdef _WIN32
    _aspDotNetHack = new QCheckBox( _q("&enable ASP_DOT_NET_HACK"), this );
    _aspDotNetHack->setTristate(false);
    QToolTip::add( _aspDotNetHack, _q("use _svn instead of .svn as subversion administrative directory") );
    vl->addWidget(_aspDotNetHack);

    connect( _aspDotNetHack, SIGNAL(clicked(void)), SLOT(clicked(void)) );
#endif // _WIN32

    vl->addStretch(1);
  }
}

SubversionSettingsWidget::~SubversionSettingsWidget()
{
}

void SubversionSettingsWidget::setAspDotNetHack( bool enabled )
{
  _aspDotNetHack->setChecked(enabled);
}

bool SubversionSettingsWidget::getAspDotNetHack()
{
  return _aspDotNetHack->isChecked();
}

void SubversionSettingsWidget::clicked()
{
  emit modified();
}
