/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "StatusCmd.h"
#include "StatusParam.h"
#include "CmdResultCallback.h"
#include "CmdProgressCallback.h"
#include "svn/Client.h"
#include "svn/WcStatus.h"
#include "svn/StatusBaton.h"

///////////////////////////////////////////////////////////////////////////////
//

class StatusBaton : public svn::StatusBaton
{
public:
  StatusBaton( svn::WcStatuss& statuss, bool repos )
    : svn::StatusBaton(), _repos(repos), _statuss(statuss)
  {
  }

  void status( const char* path, svn::WcStatusPtr status )
  {
    status->calcLockStatus(_repos);
    _statuss.push_back(status);
  }

  bool            _repos;
  svn::WcStatuss& _statuss;
};

//
///////////////////////////////////////////////////////////////////////////////

StatusCmd::StatusCmd( StatusParam* param, CmdResultCallback* cb )
: ScCmd(param->getId()), _param(param), _cb(cb)
{
}

StatusCmd::~StatusCmd()
{
  delete _cb;
}

void StatusCmd::run()
{
  sc::Error* err;
  StatusBaton baton(_param->getStatuss(),_param->getUpdate());

  _prgscb->started( getId(), _param, getCancel() );

  err = _client->status( &_param->getRevnumber(), _param->getPath(), *_param->getRevision(),
    &baton, _param->getRecurse(), _param->getAll(), _param->getUpdate(), _param->getIgnore() );

  _param->setError( err );
  _prgscb->finished( getId(), _param );

  _cb->handleResult( _param, err );
}
