/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_LOGPARAM_H
#define _SC_LOGPARAM_H

// sc
#include "ScParam.h"
#include "svn/ClientTypes.h"
#include "svn/LogBaton.h"
#include "svn/Revision.h"
#include "util/String.h"

namespace svn
{
  class Revision;
  class LogBaton;
}


/**
 * Parameter class for LogCmd.
 */
class LogParam : public ScParam
{
public:
  LogParam( const svn::Paths& pathsOrUrls, const svn::Revision* start, const svn::Revision* stop,
    int limit, bool changedPaths, bool strictHistory, svn::LogBaton* baton )
    : _pathsOrUrls(pathsOrUrls), _startRev(start), _stopRev(stop), _limit(limit),
    _changedPaths(changedPaths), _strictHistory(strictHistory), _baton(baton)
  {
  }

  ~LogParam()
  {
    delete _startRev;
    delete _stopRev;
    delete _baton;
  }

  const svn::Paths& getPathsOrUrls() const
  {
    return _pathsOrUrls;
  }

  const svn::Revision* getStartRevision() const
  {
    return _startRev;
  }

  const svn::Revision* getStopRevision() const
  {
    return _stopRev;
  }

  int getLimit() const
  {
    return _limit;
  }

  bool getChangedPaths() const
  {
    return _changedPaths;
  }

  bool getStrictHistory() const
  {
    return _strictHistory;
  }

  svn::LogBaton* getBaton() const
  {
    return _baton;
  }

  ScParamAccept(LogParam);

private:
  // in
  svn::Paths           _pathsOrUrls;
  const svn::Revision* _startRev;
  const svn::Revision* _stopRev;
  int                  _limit;
  bool                 _changedPaths;
  bool                 _strictHistory;
  svn::LogBaton*       _baton;
};

#endif // _SC_LOGPARAM_H
