/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_STATUSID_H
#define _SC_STATUSID_H

// sc
#include "ColorId.h"
#include "util/String.h"

// this must match with the columns added
// to the ListView in ListWidget
enum StatusColumns
{
  StatusColumnName,
  StatusColumnTextStatus,
  StatusColumnPropStatus,
  StatusColumnWcLocked,
  StatusColumnCopied,
  StatusColumnSwitched,
  StatusColumnRepLock,
  StatusColumnUpToDate,
  StatusColumnWcRev,
  StatusColumnCmtRev,
  StatusColumnCmtAuthor,
  StatusColumnEmpty
};


enum StatusId
{
  // general
  StatusNone = 0,
  StatusUnversioned,
  StatusNormal,
  StatusAdded,
  StatusMissing,
  StatusDeleted,   
  StatusReplaced,
  StatusModified,
  StatusMerged,
  StatusConflicted,
  StatusIgnored,
  StatusObstructed,
  StatusExternal,
  StatusIncomplete,
  StatusFallback,

  // working copy lock
  StatusWcLockNone,
  StatusWcLockLocked,

  // history
  StatusHistoryNone,
  StatusHistory,

  // switched
  StatusSwitchedNo,
  StatusSwitched,

  // update to date
  StatusUpToDateNo,
  StatusUpToDate,

  // repository lock
  StatusLockNone,
  StatusLockLocked,
  StatusLockStolen,
  StatusLockOther,
  StatusLockBroken
};

struct StatusCode
{
  StatusId   _sid;
  ColorId    _cid;
  sc::String _code;
  sc::String _name;
};

extern const StatusCode StatusCodes[];

#endif // #define _SC_STATUSID_H
