/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_MAIN_WINDOW_H
#define _SC_MAIN_WINDOW_H

// sc
#include "sublib/TargetId.h"
class Error;
class ListWidget;
class ScModel;
class DialogHandler;
class LoggingEvent;
class ConfigManager;
class ActionStorage;
class Project;
class SplitLayout;
class CancelStartEvent;
class CancelStopEvent;
class LogWidget;
class QAssistantClient;

namespace sc
{
  class Condition;
}

// qt
#include <qmainwindow.h>
class QLabel;
class QListView;
class QListViewItem;
class QPopupMenu;


class MainWindow : public QMainWindow, public TargetId
{
  typedef QMainWindow super;
  Q_OBJECT 

public:
  MainWindow( ScModel* model, ConfigManager*, QWidget *parent=0, const char *name=0 );
  virtual ~MainWindow();

  // MainWindow overwrite
  bool showDockMenu( const QPoint& globalPos );
  void customEvent( QCustomEvent* ce );
  bool eventFilter( QObject* t, QEvent* e );

public slots:
  void about();
  void manual();
  void manualError( const QString& msg ); 
  void settings();
  void settings( const QString& selected );
  void prjSettings( Project* prj );

  /**
   * \name toolbar buttons.
   */
  // @{
  void toggledOptionStatusAll();
  void toggledOptionStatusUpdates();
  void toggledOptionStatusIgnored();
  void toggledOptionStatusRecurse();

  void toggledOptionCommandForce();
  void toggledOptionCommandRecurse();
  // @} 

  void outputMenuRequested( QListViewItem*, const QPoint&, int );

  void runWcAutoUpdate();

public:
  ScModel* getModel();

private:
  void log( LoggingEvent* e );
  void log( CancelStartEvent* e );
  void log( CancelStopEvent* e );

  QLabel*           _sbar1;
  QLabel*           _sbar2;
  QLabel*           _sbar3;
  QLabel*           _sbar4;
  QLabel*           _status1;

  ActionStorage*    _actions;
  QPopupMenu*       _fileMenu;

  SplitLayout*      _split;
  ListWidget*       _list;
  LogWidget*        _output;

  ConfigManager*    _config;
  ScModel*          _model;
  QAssistantClient* _assistant;
};


#endif // _SC_MAIN_WINDOW_H
