/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_DIRENTRYLVI_H
#define _SC_DIRENTRYLVI_H

// sc
#include "svn/DirEntry.h"

// qt
#include <qlistview.h>
class QMimeSource;

class DirEntryLvi : public QListViewItem
{
  typedef QListViewItem super;

public:
  DirEntryLvi( QListView* parent, svn::DirEntryPtr entry );
  DirEntryLvi( QListViewItem* parent, svn::DirEntryPtr entry );

  void okRename( int col );

  bool acceptDrop( const QMimeSource* mime ) const;
  
  QString text( int column ) const;
  QString key( int column, bool ascending ) const;
  int compare( QListViewItem* i, int col, bool ascending ) const;

  void setParentUrl( const QString& parentUrl );
  const QString& getParentUrl() const;
  const svn::DirEntryPtr getEntry() const;

private:
  void init();
  const QString& getSortPrefix() const;

  QString          _parentUrl;
  svn::DirEntryPtr _entry;

  bool             _rename;      ///< we are in a rename?
};

#endif //  _SC_DIRENTRYLVI_H
