/* Copyright (C) 2000-2006  Thomas Bopp, Thorsten Hampel, Ludger Merkens
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * 
 * $Id: auth.pike,v 1.4 2006/10/13 10:41:50 exodusd Exp $
 */

inherit "/kernel/module";

#include <classes.h>
#include <database.h>
#include <events.h>
#include <macros.h>

#define DEPENDENCIES users ldap

static object usermod = get_module("users");
static object ldap = get_module("ldap");
static mapping config = ([ ]);
static array authentication_methods = ({ "database" });

/**
 * Find a user object if the submitted password is sent correctly.
 *  
 * @param string name - the user name
 * @param string pass - the users password
 * @return the user object or null, throws an error if the password is wrong
 */
object authenticate(string name, string pass)
{
  object user = _Persistence->lookup_user( name, pass );
  if ( objectp(user) ) {
    // restricted users are always checked locally:
    if ( _Persistence->user_restricted( name ) ) {
      if ( user->check_user_password( pass ) )
	return user;
      else return UNDEFINED;
    }

    // backdoor for root user?
    if ( Config.bool_value(config["root-backdoor"]) ) {
      if ( _ROOT->check_user_password(pass) )
        return user;
    }

    // check user activation:
    if ( user->get_activation() )
      steam_user_error("User "+name+" is not activated.");

    foreach ( authentication_methods, string method ) {
      switch ( method ) {
        case "ldap" : {
          if(!ldap)
            ldap = get_module("ldap");
          if ( objectp(ldap) && ldap->authorize_ldap(user, pass) )
            return user;
        } break;
        
        case "database" : {
          if ( user->check_user_password(pass) )
            return user;
        } break;
        
        default :
          werror( "Invalid authentication method: %s\n", method );
      }
    }
  }
  return 0;
}


string get_ticket(object user)
{
  // try to get ticket from user and possible store inside ldap
}


string get_identifier() { return "auth"; }


static void init_module ()
{
  config = Config.read_config_file( _Server.get_config_dir()+"/modules/auth.cfg" );
  if ( !mappingp(config) )
    config = ([ ]);
  if ( stringp(config["authenticate"]) ) {
    authentication_methods = ({ });
    array methods = config["authenticate"] / ",";
    foreach ( methods, string method ) {
      method = lower_case( String.trim_all_whites( method ) );
      if ( sizeof(method) > 0 )
        authentication_methods += ({ method });
    }
  }
  if ( !arrayp(authentication_methods) || sizeof(authentication_methods) < 1 )
    authentication_methods = ({ "database" });
}

int check_protocoll_access(object obj, object client)
{
    return 1;
}
