#ifndef __USE_POSIX
#define __USE_POSIX
#endif
#ifndef __USE_POSIX2
#define __USE_POSIX2
#endif
#ifndef __USE_MISC
#define __USE_MISC
#endif
#ifndef __USE_BSD
#define __USE_BSD
#endif

/*#ifndef __USE_GNU
#define __USE_GNU
#endif*/



#include <glib.h>

#include "config.h"

#include <arpa/inet.h>
#include <ctype.h>
#include <errno.h>
#ifdef HAVE_FCNTL_H
#include <fcntl.h>
#endif
#include <getopt.h>
#include <grp.h>
#include <math.h>
#include <netinet/in.h>
#include <pwd.h>
#include <regex.h>
#include <signal.h>
#include <sys/ioctl.h>

#include <sndfile.h>
#include <sys/soundcard.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <sys/socket.h>

#ifdef HAVE_TIME_H
#include <time.h>
#endif

#ifdef HAVE_SYS_TIME_H
#include <sys/time.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>

#ifdef HAVE_SYS_WAIT_H
#include <sys/wait.h>
#endif

#define __USE_GNU
#include <unistd.h>


#define BUFFER_LEN 2048
#define NET_PORT 7890
#define MAX_CHANNELS 4

#define DIE raise(SIGSEGV)
#define CONDGFREE(item) { if (item) { g_free(item); item=NULL; }}

/* error.c */

extern int debug_type;
extern char *debug_filename;
extern int nofork;

void check_memory_leaks();
void do_not_optimize_here(void *p);
void error(unsigned char *, ...);
void debug_msg(unsigned char *, ...);
void int_error(unsigned char *, ...);

void init_debug(void);
void free_debug(void);
void dbg(unsigned char *m, ...);

void sock_debug(int sock, unsigned char *m, ...);
extern int errline;
extern unsigned char *errfile;

#define internal errfile = __FILE__, errline = __LINE__, int_error
#define debug errfile = __FILE__, errline = __LINE__, debug_msg

#ifdef SPECIAL_MALLOC

void *sp_malloc(size_t);
void sp_free(void *);
void *sp_realloc(void *, size_t);

#define xmalloc sp_malloc
#define xfree sp_free
#define xrealloc sp_realloc

#else

#define xmalloc malloc
#define xfree free
#define xrealloc realloc

#endif

/* Copies at most dst_size chars into dst. Ensures null termination of dst. */

static inline unsigned char *safe_strncpy(unsigned char *dst, const unsigned char *src, size_t dst_size) {
    strncpy(dst, src, dst_size);
    if (strlen(src) >= dst_size) dst[dst_size - 1] = 0;
    return dst;
}


static inline unsigned char *safe_strncpy0(unsigned char *dst, const unsigned char *src, size_t dst_size) {
    if (!src) {
        *dst='\0';
        return dst;
    }

    strncpy(dst, src, dst_size);
    if (strlen(src) >= dst_size) dst[dst_size - 1] = 0;
    return dst;
}


struct list_head {
    void *next;
    void *prev;
};

#ifndef HAVE_TYPEOF

struct xlist_head {
    struct xlist_head *next;
    struct xlist_head *prev;
};

#endif

#define init_list(x) {(x).next=&(x); (x).prev=&(x);}
#define list_empty(x) ((x).next == &(x))
#define del_from_list(x) {((struct list_head *)(x)->next)->prev=(x)->prev; ((struct list_head *)(x)->prev)->next=(x)->next;}
/*#define add_to_list(l,x) {(x)->next=(l).next; (x)->prev=(typeof(x))&(l); (l).next=(x); if ((l).prev==&(l)) (l).prev=(x);}*/
#define add_at_pos(p,x) do {(x)->next=(p)->next; (x)->prev=(p); (p)->next=(x); (x)->next->prev=(x);} while(0)

#ifdef HAVE_TYPEOF
#define add_to_list(l,x) add_at_pos((typeof(x))&(l),(x))
#define foreach(e,l) for ((e)=(l).next; (e)!=(typeof(e))&(l); (e)=(e)->next)
#define foreachback(e,l) for ((e)=(l).prev; (e)!=(typeof(e))&(l); (e)=(e)->prev)
#else
#define add_to_list(l,x) add_at_pos((struct xlist_head *)&(l),(struct xlist_head *)(x))
#define foreach(e,l) for ((e)=(l).next; (e)!=(void *)&(l); (e)=(e)->next)
#define foreachback(e,l) for ((e)=(l).prev; (e)!=(void *)&(l); (e)=(e)->prev)
#endif
#define free_list(l) {while ((l).next != &(l)) {struct list_head *a=(l).next; del_from_list(a); mem_free(a); }}

#define DUMMY ((void *)-1L)


#ifdef LEAK_DEBUG

void *debug_mem_alloc(unsigned char *, int, size_t);
void debug_mem_free(unsigned char *, int, void *);
void *debug_mem_realloc(unsigned char *, int, void *, size_t);
void set_mem_comment(void *, unsigned char *, int);

#define mem_alloc(x) debug_mem_alloc(__FILE__, __LINE__, x)
#define mem_free(x) debug_mem_free(__FILE__, __LINE__, x)
//#define mem_realloc(x, y) debug_mem_realloc(__FILE__, __LINE__, x, y)

#else

static inline void *mem_alloc(size_t size)
{
    void *p;
    if (!size) return DUMMY;
    if (!(p = malloc(size))) {
        error("ERROR: out of memory (malloc returned NULL)\n");
        return NULL;
    }
    return p;
}

static inline void mem_free(void *p)
{
    if (p == DUMMY) return;
    if (!p) {
        internal("mem_free(NULL)");
        return;
    }
    free(p);
}

#if 0
static inline void *mem_realloc(void *p, size_t size)
{
    if (p == DUMMY) return mem_alloc(size);
    if (!p) {
        internal("mem_realloc(NULL, %d)", size);
        return NULL;
    }
    if (!size) {
        mem_free(p);
        return DUMMY;
    }
    if (!(p = realloc(p, size))) {
        error("ERROR: out of memory (realloc returned NULL)\n");
        return NULL;
    }
    return p;
}
#endif

static inline void *debug_mem_alloc(unsigned char *f, int l, size_t s) { return mem_alloc(s); }
static inline void debug_mem_free(unsigned char *f, int l, void *p) { mem_free(p); }
/*static inline void *debug_mem_realloc(unsigned char *f, int l, void *p, size_t s) { return mem_realloc(p, s); }*/
static inline void set_mem_comment(void *p, unsigned char *c, int l) {}

#endif

#define internal errfile = __FILE__, errline = __LINE__, int_error

/* select.h */
typedef long ttime;
typedef unsigned tcount;

extern int terminate;

long select_info(int);
void select_loop(void (*)());
/*int register_bottom_half(void (*)(void *), void *);*/
void check_bottom_halves();
int install_timer_(ttime, void (*)(void *), void *);
void kill_timer(int);
ttime get_timer_time(int);

#define H_READ  0
#define H_WRITE 1
#define H_ERROR 2
#define H_DATA  3

void *get_handler(int, int);
void set_handlers(int, void (*)(void *), void (*)(void *), void (*)(void *), void *);
void install_signal_handler(int, void (*)(void *), void *, int);
void set_sigcld();
void st_start();
void st_stop();

extern struct timeval start;
#define ST_START gettimeofday(&start, NULL)
#define ST_STOP {\
    struct timeval stop;\
    int sec, usec;\
    gettimeofday(&stop, NULL);\
    usec=stop.tv_usec-start.tv_usec;\
    sec=stop.tv_sec-start.tv_sec;\
    if (usec<0){usec+=1000000;sec--;}\
    dbg("stopky: %s: %d.%06d \n", __FUNCTION__, sec,usec);\
}

#define ST_START gettimeofday(&start, NULL)
#define ST_STOP {\
    struct timeval stop;\
    int sec, usec;\
    gettimeofday(&stop, NULL);\
    usec=stop.tv_usec-start.tv_usec;\
    sec=stop.tv_sec-start.tv_sec;\
    if (usec<0){usec+=1000000;sec--;}\
    dbg("stopky: %s: %d.%06d \n", __FUNCTION__, sec,usec);\
}


/* dsp */

struct dsp{
    gchar *filename;
    int fd;
    int fmt_mask;
    int format,channels,speed;
    int blksize;
    gchar *errstr;
    int rec;
};

/* format:
    0x10005     8 bit PCM
    0x10002     16 bit PCM    
    0x10010     u-law
    0x10011     a-law
    0x10012     IMA ADPCM
    0x10013     MS ADPCM
    0x10020     GSM 6.1  */

extern struct dsp *dsp;

struct dsp *init_dsp (gchar *filename);
void free_dsp(struct dsp *dsp);
int open_dsp(struct dsp *dsp, int rec);
int close_dsp(struct dsp *dsp);
int reset_dsp(struct dsp *dsp);
int sf2dsp(SF_INFO *sfinfo);
int dsp2sf(struct dsp *dsp);

/* play.c */

int init_play_file(char *filename);
void play_func(void *dummy);
int init_rec_file(char *filename);
void rec_func(void *dummy);
void play_close(void);
void play_abort(void);

/* ssbd.c */

struct cfg{
    gchar *filename;
    gchar *template;
    gchar *callsign;
    gint serno;
    gint format,channels,samplerate;

    gchar *user;
    gint umask;
    int euid;
};

extern struct sockaddr_in reply_sin;
extern socklen_t reply_socklen;
extern int udpsock;

void udp_read_handler(void *data);
void udp_exception_handler(void *data);

/* main.h */

void terminate_all_subsystems(void);
extern struct cfg *cfg;
int send_reply(void);


/* misc.h */

int mkdir_p(const char *s,mode_t mode);
int fmkdir_p(const char *filename, mode_t mode);

#define CE_NONE             0
#define CE_ONLY_STRFTIME    1
gchar *convert_esc(gchar *format, int flags);

gchar *unique_filename(gchar *filename);

/* mixer.h */

struct mixer {
	char *mixer;
    int recmask;
	int recsrc;
};

struct mixer *init_mixer(char *mixer_filename);
void free_mixer(struct mixer *mix);
void mixer_set_filename(struct mixer *mix, char *mixer_filename);
void mixer_set_source(struct mixer *mix, int source);


/* regex.c */

#define MAX_MATCHES 10

int regcmp(char *string, char *regex);
int regcmpi(char *string, char *regex);
int regmatch(char *string, char *regex, ...);

/* monitor.c */

extern short playmax[MAX_CHANNELS];
//extern struct timeval playmaxstamp[MAX_CHANNELS];

int init_mon(void);
void free_mon();
void mon_read_handler(void *data);
