/*
 *  SPL - The SPL Programming Language
 *  Copyright (C) 2004, 2005  Clifford Wolf <clifford@clifford.at>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  c-api-test2.c: Simple test for the assembler interface.
 */

#define _GNU_SOURCE

#include "spl.h"

int main()
{
	struct spl_vm *vm = spl_vm_create();
	struct spl_asm *as = spl_asm_create();

	spl_asm_add(as, SPL_OP_PUSHC, "hello ");
	spl_asm_add(as, SPL_OP_PUSHC, "world!");
	spl_asm_add(as, SPL_OP_CAT,   0);
	spl_asm_add(as, SPL_OP_DEBUG, 0);

	spl_asm_add(as, SPL_OP_PUSHC, "42");
	spl_asm_add(as, SPL_OP_RLRET, 0);

	struct spl_code *code = spl_asm_dump(as);
	spl_asm_destroy(as);

	struct spl_task *task = spl_task_create(vm, 0);
	spl_task_setcode(task, code);

	while ( spl_exec(task) != 42 ) {}

	spl_vm_destroy(vm);
	return 0;
}

