var SpeedDialUtils = {
  prefs: Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("extensions.speeddial."),
  thumbFolder: "SDThumbs",
  backupFolder: "SDBackups",
  cacheService: null,
  timeUnits: [ 1, 60, 3600, 86400 ],
  timeUnitNames: [ 'seconds', 'minutes', 'hours', 'days' ],
  faviconService: null,
  ioService: Components.classes["@mozilla.org/network/io-service;1"].getService(Components.interfaces.nsIIOService),
  fennecToolbarHeight: 74,
  checkedFirefox3: false,
  cachedFirefox3: false,
  checkedFirefox35: false,
  cachedFirefox35: false,
  checkedFennec: false,
  cachedFennec: false,

  isFirefox3: function() {
    if (SpeedDialUtils.checkedFirefox3)
      return SpeedDialUtils.cachedFirefox3;
    // Detect version
    var appInfo = Components.classes["@mozilla.org/xre/app-info;1"].getService(Components.interfaces.nsIXULAppInfo)
    // only if this is Firefox
    var versionChecker = Components.classes["@mozilla.org/xpcom/version-comparator;1"]
                        .getService(Components.interfaces.nsIVersionComparator);
    // only if the platform version is 1.9 or greater
    if (versionChecker.compare(appInfo.platformVersion, "1.9a1") >= 0) {
      SpeedDialUtils.cachedFirefox3 = true;
    }
    SpeedDialUtils.checkedFirefox3 = true;
    return SpeedDialUtils.cachedFirefox3;
  },
  
  isFirefox35: function() {
    if (SpeedDialUtils.checkedFirefox35)
      return SpeedDialUtils.cachedFirefox35;
    // Detect version
    var appInfo = Components.classes["@mozilla.org/xre/app-info;1"].getService(Components.interfaces.nsIXULAppInfo)
    // only if this is Firefox
    var versionChecker = Components.classes["@mozilla.org/xpcom/version-comparator;1"]
                        .getService(Components.interfaces.nsIVersionComparator);
    // only if the platform version is 1.9 or greater
    if (versionChecker.compare(appInfo.platformVersion, "1.9.1a1") >= 0) {
      SpeedDialUtils.cachedFirefox35 = true;
    }
    SpeedDialUtils.checkedFirefox35 = true;
    return SpeedDialUtils.cachedFirefox35;
  },
  
  isFennec: function() {
    if (SpeedDialUtils.checkedFennec)
      return SpeedDialUtils.cachedFennec;
    // Detect version
    var appInfo = Components.classes["@mozilla.org/xre/app-info;1"].getService(Components.interfaces.nsIXULAppInfo);
    SpeedDialUtils.cachedFennec = (appInfo.ID == "{a23983c0-fd0e-11dc-95ff-0800200c9a66}");
    SpeedDialUtils.checkedFennec = true;
    return SpeedDialUtils.cachedFennec;
  },
  
  getTopWindow: function() {
    if (SpeedDialUtils.isFennec()) {
      var wm = Components.classes['@mozilla.org/appshell/window-mediator;1'].getService(Components.interfaces.nsIWindowMediator);
      var windowIter = wm.getEnumerator('navigator:browser');
     
      if (windowIter.hasMoreElements()) {
        return windowIter.getNext();
      }
      return null;
    } else {
      try {
        return QueryInterface(Components.interfaces.nsIInterfaceRequestor).getInterface(Components.interfaces.nsIWebNavigation).QueryInterface(Components.interfaces.nsIDocShellTreeItem).rootTreeItem.QueryInterface(Components.interfaces.nsIInterfaceRequestor).getInterface(Components.interfaces.nsIDOMWindow);
      } catch (e) {
        if (window.opener) {
          return window.opener;
        }
        return window;
      }
    }
  },

  getCacheService: function() {
    if (SpeedDialUtils.cacheService == null) {
      SpeedDialUtils.cacheService = Components.classes["@uworks.net/speeddialcache;1"].getService().wrappedJSObject;
    }
    return SpeedDialUtils.cacheService;
  },
  
  removeThumbnailImage: function(thumbNumber) {
    var prefs = SpeedDialUtils.prefs;
    var file = Components.classes["@mozilla.org/file/directory_service;1"]
                       .getService(Components.interfaces.nsIProperties)
                       .get("ProfD", Components.interfaces.nsIFile);
    file.append(SpeedDialUtils.thumbFolder);
    
    if (file.exists() && file.isDirectory()) {
      // Delete all files that match this thumbnail!
      var rootNameMatch = "thumbnail-" + thumbNumber + "(-\\d+)?\\.(png|jpg)";
      var enumerator = file.directoryEntries;
      while (enumerator.hasMoreElements()) {
        var targetFile = enumerator.getNext().QueryInterface(Components.interfaces.nsIFile);
        if ((targetFile.isFile()) && (targetFile.leafName.match(rootNameMatch))) {
          try {
            targetFile.remove(false);
          } catch(e) {
            // Do nothing...
          }
        }
      }
    }
  },

  clearThumbnailData: function(thumbNumber) {
    var prefs = SpeedDialUtils.prefs;

    if (prefs.prefHasUserValue("thumbnail-" + thumbNumber + "-url")) {
      prefs.clearUserPref("thumbnail-" + thumbNumber + "-url");
    }

    if (prefs.prefHasUserValue("thumbnail-" + thumbNumber + "-icon")) {
      prefs.clearUserPref("thumbnail-" + thumbNumber + "-icon");
    }

    if (prefs.prefHasUserValue("thumbnail-" + thumbNumber + "-label")) {
      prefs.clearUserPref("thumbnail-" + thumbNumber + "-label");
    }

    if (prefs.prefHasUserValue("thumbnail-" + thumbNumber + "-lastsaved")) {
      prefs.clearUserPref("thumbnail-" + thumbNumber + "-lastsaved");
    }

    if (prefs.prefHasUserValue("thumbnail-" + thumbNumber + "-dynamictitle")) {
      prefs.clearUserPref("thumbnail-" + thumbNumber + "-dynamictitle");
    }
  
    if (prefs.prefHasUserValue("thumbnail-" + thumbNumber + "-refreshinterval")) {
      prefs.clearUserPref("thumbnail-" + thumbNumber + "-refreshinterval");
    }
  
    if (prefs.prefHasUserValue("thumbnail-" + thumbNumber + "-manualrefresh")) {
      prefs.clearUserPref("thumbnail-" + thumbNumber + "-manualrefresh");
    }

    if (prefs.prefHasUserValue("thumbnail-" + thumbNumber + "-format")) {
      prefs.clearUserPref("thumbnail-" + thumbNumber + "-format");
    }

    if (prefs.prefHasUserValue("thumbnail-" + thumbNumber + "-backgroundcolor")) {
      prefs.clearUserPref("thumbnail-" + thumbNumber + "-backgroundcolor");
    }

    if (prefs.prefHasUserValue("thumbnail-" + thumbNumber + "-layout")) {
      prefs.clearUserPref("thumbnail-" + thumbNumber + "-layout");
    }

    if (prefs.prefHasUserValue("thumbnail-" + thumbNumber + "-cropping")) {
      prefs.clearUserPref("thumbnail-" + thumbNumber + "-cropping");
    }

    if (prefs.prefHasUserValue("thumbnail-" + thumbNumber + "-thumbnailurl")) {
      prefs.clearUserPref("thumbnail-" + thumbNumber + "-thumbnailurl");
    }

    if (prefs.prefHasUserValue("thumbnail-" + thumbNumber + "-extra")) {
      prefs.clearUserPref("thumbnail-" + thumbNumber + "-extra");
    }

    if (prefs.prefHasUserValue("thumbnail-" + thumbNumber + "-js")) {
      prefs.clearUserPref("thumbnail-" + thumbNumber + "-js");
    }
  },
  
  deassignThumbnail: function(thumbNumber) {
    // Take out from cache
    SpeedDialUtils.getCacheService().setImage(null, thumbNumber);

    SpeedDialUtils.removeThumbnailImage(thumbNumber);
    
    SpeedDialUtils.clearThumbnailData(thumbNumber);
  },
  
  removeGroup: function(groupIndex, confirmDelete) {
    var prefs = SpeedDialUtils.prefs;

    var speedDialBundle = document.getElementById("bundle_speeddial");
    
    if (prefs.getBoolPref("reorderDialsAfterGroupDelete") &&
        prefs.getBoolPref("askBeforeRemovingGroup") &&
        speedDialBundle &&
        confirmDelete) {
      var ps = Components.classes["@mozilla.org/embedcomp/prompt-service;1"]
                                                .getService(Components.interfaces.nsIPromptService);
      var dontAskAgain= { value: false };
      var rv = ps.confirmEx(window,
                            speedDialBundle.getString("removewarning.title"),
                            speedDialBundle.getString("removewarning.message"),
                            Components.interfaces.nsIPromptService.STD_YES_NO_BUTTONS,
                            null, null, null,
                            speedDialBundle.getString("removewarning.dontask"),
                            dontAskAgain);
      if (dontAskAgain.value) {
        prefs.setBoolPref("askBeforeRemovingGroup", false);
      }
      if (rv != 0) return false;
    }
    
    var totalGroups = prefs.getIntPref("numGroups");
    
    if (totalGroups < 2) return false;
    
    if (prefs.getBoolPref("reorderDialsAfterGroupDelete")) {
      var initialDial = SpeedDialUtils.getGroupFirstDialNumber(groupIndex);
      var totalDials = SpeedDialUtils.getTotalDials();
      var currentRows;
      var currentCols;
      if (prefs.prefHasUserValue("group-" + groupIndex + "-rows")) {
        currentRows = prefs.getIntPref("group-" + groupIndex + "-rows");
      } else {
        currentRows = prefs.getIntPref("rows");
      }
      if (prefs.prefHasUserValue("group-" + groupIndex + "-columns")) {
        currentCols = prefs.getIntPref("group-" + groupIndex + "-columns");
      } else {
        currentCols = prefs.getIntPref("columns");
      }
      var groupDials = currentRows * currentCols;

      for (var c=initialDial; c<=totalDials; c++) {
        SpeedDialUtils.deassignThumbnail(c);
        SpeedDialUtils.removeThumbnailImage(c);
        if (c<=(totalDials - groupDials)) {
          SpeedDialUtils.copyThumbnailData(c+groupDials, c);
          SpeedDialUtils.moveThumbnailImage(c+groupDials, c);
        }
      }
    }
    
    
    // Move data
    for (var c=groupIndex; c<totalGroups; c++) {
      // Move title
      if (prefs.prefHasUserValue("group-" + (c+1) + "-title")) {
        prefs.setComplexValue("group-" + c + "-title", Components.interfaces.nsISupportsString, prefs.getComplexValue("group-" + (c+1) + "-title", Components.interfaces.nsISupportsString));
        prefs.clearUserPref("group-" + (c+1) + "-title");
      } else if (prefs.prefHasUserValue("group-" + c + "-title")) {
        prefs.clearUserPref("group-" + c + "-title");
      }
      
      // Move background color
      if (prefs.prefHasUserValue("group-" + (c+1) + "-backgroundColor")) {
        prefs.setCharPref("group-" + c + "-backgroundColor", prefs.getCharPref("group-" + (c+1) + "-backgroundColor"));
        prefs.clearUserPref("group-" + (c+1) + "-backgroundColor");
      } else if (prefs.prefHasUserValue("group-" + c + "-backgroundColor")) {
        prefs.clearUserPref("group-" + c + "-backgroundColor");
      }
      
      // Move text color
      if (prefs.prefHasUserValue("group-" + (c+1) + "-textColor")) {
        prefs.setCharPref("group-" + c + "-textColor", prefs.getCharPref("group-" + (c+1) + "-textColor"));
        prefs.clearUserPref("group-" + (c+1) + "-textColor");
      } else if (prefs.prefHasUserValue("group-" + c + "-textColor")) {
        prefs.clearUserPref("group-" + c + "-textColor");
      }
      
      // Move rows
      if (prefs.prefHasUserValue("group-" + (c+1) + "-rows")) {
        prefs.setIntPref("group-" + c + "-rows", prefs.getIntPref("group-" + (c+1) + "-rows"));
        prefs.clearUserPref("group-" + (c+1) + "-rows");
      } else if (prefs.prefHasUserValue("group-" + c + "-rows")) {
        prefs.clearUserPref("group-" + c + "-rows");
      }
      
      // Move hide unused
      if (prefs.prefHasUserValue("group-" + (c+1) + "-hideUnused")) {
        prefs.setBoolPref("group-" + c + "-hideUnused", prefs.getBoolPref("group-" + (c+1) + "-hideUnused"));
        prefs.clearUserPref("group-" + (c+1) + "-hideUnused");
      } else if (prefs.prefHasUserValue("group-" + c + "-hideUnused")) {
        prefs.clearUserPref("group-" + c + "-hideUnused");
      }
      
      // Move columns
      if (prefs.prefHasUserValue("group-" + (c+1) + "-columns")) {
        prefs.setIntPref("group-" + c + "-columns", prefs.getIntPref("group-" + (c+1) + "-columns"));
        prefs.clearUserPref("group-" + (c+1) + "-columns");
      } else if (prefs.prefHasUserValue("group-" + c + "-columns")) {
        prefs.clearUserPref("group-" + c + "-columns");
      }
      
      // Move back image
      if (prefs.prefHasUserValue("group-" + (c+1) + "-backImage")) {
        prefs.setCharPref("group-" + c + "-backImage", prefs.getCharPref("group-" + (c+1) + "-backImage"));
        prefs.clearUserPref("group-" + (c+1) + "-backImage");
      } else if (prefs.prefHasUserValue("group-" + c + "-backImage")) {
        prefs.clearUserPref("group-" + c + "-backImage");
      }
      
      // Move font
      if (prefs.prefHasUserValue("group-" + (c+1) + "-font")) {
        prefs.setCharPref("group-" + c + "-font", prefs.getCharPref("group-" + (c+1) + "-font"));
        prefs.clearUserPref("group-" + (c+1) + "-font");
      } else if (prefs.prefHasUserValue("group-" + c + "-font")) {
        prefs.clearUserPref("group-" + c + "-font");
      }
      
      // Move style
      if (prefs.prefHasUserValue("group-" + (c+1) + "-style")) {
        prefs.setCharPref("group-" + c + "-style", prefs.getCharPref("group-" + (c+1) + "-style"));
        prefs.clearUserPref("group-" + (c+1) + "-style");
      } else if (prefs.prefHasUserValue("group-" + c + "-style")) {
        prefs.clearUserPref("group-" + c + "-style");
      }
      
      // Move size
      if (prefs.prefHasUserValue("group-" + (c+1) + "-minimumWidth")) {
        prefs.setIntPref("group-" + c + "-minimumWidth", prefs.getIntPref("group-" + (c+1) + "-minimumWidth"));
        prefs.clearUserPref("group-" + (c+1) + "-minimumWidth");
      } else if (prefs.prefHasUserValue("group-" + c + "-minimumWidth")) {
        prefs.clearUserPref("group-" + c + "-minimumWidth");
      }
      if (prefs.prefHasUserValue("group-" + (c+1) + "-minimumHeight")) {
        prefs.setIntPref("group-" + c + "-minimumHeight", prefs.getIntPref("group-" + (c+1) + "-minimumHeight"));
        prefs.clearUserPref("group-" + (c+1) + "-minimumHeight");
      } else if (prefs.prefHasUserValue("group-" + c + "-minimumHeight")) {
        prefs.clearUserPref("group-" + c + "-minimumHeight");
      }
      if (prefs.prefHasUserValue("group-" + (c+1) + "-maximumWidth")) {
        prefs.setIntPref("group-" + c + "-maximumWidth", prefs.getIntPref("group-" + (c+1) + "-maximumWidth"));
        prefs.clearUserPref("group-" + (c+1) + "-maximumWidth");
      } else if (prefs.prefHasUserValue("group-" + c + "-maximumWidth")) {
        prefs.clearUserPref("group-" + c + "-maximumWidth");
      }
      if (prefs.prefHasUserValue("group-" + (c+1) + "-maximumHeight")) {
        prefs.setIntPref("group-" + c + "-maximumHeight", prefs.getIntPref("group-" + (c+1) + "-maximumHeight"));
        prefs.clearUserPref("group-" + (c+1) + "-maximumHeight");
      } else if (prefs.prefHasUserValue("group-" + c + "-maximumHeight")) {
        prefs.clearUserPref("group-" + c + "-maximumHeight");
      }
      if (prefs.prefHasUserValue("group-" + (c+1) + "-widthModifier")) {
        prefs.setIntPref("group-" + c + "-widthModifier", prefs.getIntPref("group-" + (c+1) + "-widthModifier"));
        prefs.clearUserPref("group-" + (c+1) + "-widthModifier");
      } else if (prefs.prefHasUserValue("group-" + c + "-widthModifier")) {
        prefs.clearUserPref("group-" + c + "-widthModifier");
      }
      if (prefs.prefHasUserValue("group-" + (c+1) + "-heightModifier")) {
        prefs.setIntPref("group-" + c + "-heightModifier", prefs.getIntPref("group-" + (c+1) + "-heightModifier"));
        prefs.clearUserPref("group-" + (c+1) + "-heightModifier");
      } else if (prefs.prefHasUserValue("group-" + c + "-heightModifier")) {
        prefs.clearUserPref("group-" + c + "-heightModifier");
      }
      if (prefs.prefHasUserValue("group-" + (c+1) + "-widthModifierType")) {
        prefs.setIntPref("group-" + c + "-widthModifierType", prefs.getIntPref("group-" + (c+1) + "-widthModifierType"));
        prefs.clearUserPref("group-" + (c+1) + "-widthModifierType");
      } else if (prefs.prefHasUserValue("group-" + c + "-widthModifierType")) {
        prefs.clearUserPref("group-" + c + "-widthModifierType");
      }
      if (prefs.prefHasUserValue("group-" + (c+1) + "-heightModifierType")) {
        prefs.setIntPref("group-" + c + "-heightModifierType", prefs.getIntPref("group-" + (c+1) + "-heightModifierType"));
        prefs.clearUserPref("group-" + (c+1) + "-heightModifierType");
      } else if (prefs.prefHasUserValue("group-" + c + "-heightModifierType")) {
        prefs.clearUserPref("group-" + c + "-heightModifierType");
      }
      
    }
    
    prefs.setIntPref("numGroups", totalGroups - 1);
    
    return true;
  },

  swapGroup: function(firstGroup, secondGroup) {
    var prefs = SpeedDialUtils.prefs;
    var firstGroupRows = prefs.getIntPref("rows");
    var firstGroupCols = prefs.getIntPref("columns");
    var secondGroupRows = firstGroupRows;
    var secondGroupCols = firstGroupCols;
    
    if (prefs.prefHasUserValue("group-" + firstGroup + "-rows")) {
      firstGroupRows = prefs.getIntPref("group-" + firstGroup + "-rows");
    }
    if (prefs.prefHasUserValue("group-" + firstGroup + "-columns")) {
      firstGroupCols = prefs.getIntPref("group-" + firstGroup + "-columns");
    }
    if (prefs.prefHasUserValue("group-" + secondGroup + "-rows")) {
      secondGroupRows = prefs.getIntPref("group-" + secondGroup + "-rows");
    }
    if (prefs.prefHasUserValue("group-" + secondGroup + "-columns")) {
      secondGroupCols = prefs.getIntPref("group-" + secondGroup + "-columns");
    }


    // Swap title
    if (prefs.prefHasUserValue("group-" + firstGroup + "-title")) {
      if (prefs.prefHasUserValue("group-" + secondGroup + "-title")) {
        // Swap
        var groupTitle = prefs.getComplexValue("group-" + firstGroup + "-title", Components.interfaces.nsISupportsString);
        prefs.setComplexValue("group-" + firstGroup + "-title", Components.interfaces.nsISupportsString, prefs.getComplexValue("group-" + secondGroup + "-title", Components.interfaces.nsISupportsString));
        prefs.setComplexValue("group-" + secondGroup + "-title", Components.interfaces.nsISupportsString, groupTitle);
      } else {
        // Move first to second
        prefs.setComplexValue("group-" + secondGroup + "-title", Components.interfaces.nsISupportsString, prefs.getComplexValue("group-" + firstGroup + "-title", Components.interfaces.nsISupportsString));
        prefs.clearUserPref("group-" + firstGroup + "-title");
      }
    } else if (prefs.prefHasUserValue("group-" + secondGroup + "-title")) {
      // Move second to first
      prefs.setComplexValue("group-" + firstGroup + "-title", Components.interfaces.nsISupportsString, prefs.getComplexValue("group-" + secondGroup + "-title", Components.interfaces.nsISupportsString));
      prefs.clearUserPref("group-" + secondGroup + "-title");
    }

    // Swap background color
    if (prefs.prefHasUserValue("group-" + firstGroup + "-backgroundColor")) {
      if (prefs.prefHasUserValue("group-" + secondGroup + "-backgroundColor")) {
        // Swap
        var groupBackgroundColor = prefs.getCharPref("group-" + firstGroup + "-backgroundColor");
        prefs.setCharPref("group-" + firstGroup + "-backgroundColor", prefs.getCharPref("group-" + secondGroup + "-backgroundColor"));
        prefs.setCharPref("group-" + secondGroup + "-backgroundColor", groupBackgroundColor);
      } else {
        // Move first to second
        prefs.setCharPref("group-" + secondGroup + "-backgroundColor", prefs.getCharPref("group-" + firstGroup + "-backgroundColor"));
        prefs.clearUserPref("group-" + firstGroup + "-backgroundColor");
      }
    } else if (prefs.prefHasUserValue("group-" + secondGroup + "-backgroundColor")) {
      // Move second to first
      prefs.setCharPref("group-" + firstGroup + "-backgroundColor", prefs.getCharPref("group-" + secondGroup + "-backgroundColor"));
      prefs.clearUserPref("group-" + secondGroup + "-backgroundColor");
    }
    
    // Swap hide unused
    if (prefs.prefHasUserValue("group-" + firstGroup + "-hideUnused")) {
      if (prefs.prefHasUserValue("group-" + secondGroup + "-hideUnused")) {
        // Swap
        var groupHideUnused = prefs.getBoolPref("group-" + firstGroup + "-hideUnused");
        prefs.setBoolPref("group-" + firstGroup + "-hideUnused", prefs.getBoolPref("group-" + secondGroup + "-hideUnused"));
        prefs.setBoolPref("group-" + secondGroup + "-hideUnused", groupHideUnused);
      } else {
        // Move first to second
        prefs.setBoolPref("group-" + secondGroup + "-hideUnused", prefs.getBoolPref("group-" + firstGroup + "-hideUnused"));
        prefs.clearUserPref("group-" + firstGroup + "-hideUnused");
      }
    } else if (prefs.prefHasUserValue("group-" + secondGroup + "-hideUnused")) {
      // Move second to first
      prefs.setBoolPref("group-" + firstGroup + "-hideUnused", prefs.getBoolPref("group-" + secondGroup + "-hideUnused"));
      prefs.clearUserPref("group-" + secondGroup + "-hideUnused");
    }
    
    // Swap text color
    if (prefs.prefHasUserValue("group-" + firstGroup + "-textColor")) {
      if (prefs.prefHasUserValue("group-" + secondGroup + "-textColor")) {
        // Swap
        var groupTextColor = prefs.getCharPref("group-" + firstGroup + "-textColor");
        prefs.setCharPref("group-" + firstGroup + "-textColor", prefs.getCharPref("group-" + secondGroup + "-textColor"));
        prefs.setCharPref("group-" + secondGroup + "-textColor", groupTextColor);
      } else {
        // Move first to second
        prefs.setCharPref("group-" + secondGroup + "-textColor", prefs.getCharPref("group-" + firstGroup + "-textColor"));
        prefs.clearUserPref("group-" + firstGroup + "-textColor");
      }
    } else if (prefs.prefHasUserValue("group-" + secondGroup + "-textColor")) {
      // Move second to first
      prefs.setCharPref("group-" + firstGroup + "-textColor", prefs.getCharPref("group-" + secondGroup + "-textColor"));
      prefs.clearUserPref("group-" + secondGroup + "-textColor");
    }

    // Swap background image
    if (prefs.prefHasUserValue("group-" + firstGroup + "-backImage")) {
      if (prefs.prefHasUserValue("group-" + secondGroup + "-backImage")) {
        // Swap
        var groupBackImage = prefs.getCharPref("group-" + firstGroup + "-backImage");
        prefs.setCharPref("group-" + firstGroup + "-backImage", prefs.getCharPref("group-" + secondGroup + "-backImage"));
        prefs.setCharPref("group-" + secondGroup + "-backImage", groupBackImage);
      } else {
        // Move first to second
        prefs.setCharPref("group-" + secondGroup + "-backImage", prefs.getCharPref("group-" + firstGroup + "-backImage"));
        prefs.clearUserPref("group-" + firstGroup + "-backImage");
      }
    } else if (prefs.prefHasUserValue("group-" + secondGroup + "-backImage")) {
      // Move second to first
      prefs.setCharPref("group-" + firstGroup + "-backImage", prefs.getCharPref("group-" + secondGroup + "-backImage"));
      prefs.clearUserPref("group-" + secondGroup + "-backImage");
    }

    // Swap font
    if (prefs.prefHasUserValue("group-" + firstGroup + "-font")) {
      if (prefs.prefHasUserValue("group-" + secondGroup + "-font")) {
        // Swap
        var groupFont = prefs.getCharPref("group-" + firstGroup + "-font");
        prefs.setCharPref("group-" + firstGroup + "-font", prefs.getCharPref("group-" + secondGroup + "-font"));
        prefs.setCharPref("group-" + secondGroup + "-font", groupFont);
      } else {
        // Move first to second
        prefs.setCharPref("group-" + secondGroup + "-font", prefs.getCharPref("group-" + firstGroup + "-font"));
        prefs.clearUserPref("group-" + firstGroup + "-font");
      }
    } else if (prefs.prefHasUserValue("group-" + secondGroup + "-font")) {
      // Move second to first
      prefs.setCharPref("group-" + firstGroup + "-font", prefs.getCharPref("group-" + secondGroup + "-font"));
      prefs.clearUserPref("group-" + secondGroup + "-font");
    }

    // Swap style
    if (prefs.prefHasUserValue("group-" + firstGroup + "-style")) {
      if (prefs.prefHasUserValue("group-" + secondGroup + "-style")) {
        // Swap
        var groupStyle = prefs.getCharPref("group-" + firstGroup + "-style");
        prefs.setCharPref("group-" + firstGroup + "-style", prefs.getCharPref("group-" + secondGroup + "-style"));
        prefs.setCharPref("group-" + secondGroup + "-style", groupStyle);
      } else {
        // Move first to second
        prefs.setCharPref("group-" + secondGroup + "-style", prefs.getCharPref("group-" + firstGroup + "-style"));
        prefs.clearUserPref("group-" + firstGroup + "-style");
      }
    } else if (prefs.prefHasUserValue("group-" + secondGroup + "-style")) {
      // Move second to first
      prefs.setCharPref("group-" + firstGroup + "-style", prefs.getCharPref("group-" + secondGroup + "-style"));
      prefs.clearUserPref("group-" + secondGroup + "-style");
    }
    
    // Swap size
    if (prefs.prefHasUserValue("group-" + firstGroup + "-minimumWidth")) {
      if (prefs.prefHasUserValue("group-" + secondGroup + "-minimumWidth")) {
        // Swap
        var groupMinimumWidth = prefs.getIntPref("group-" + firstGroup + "-minimumWidth");
        prefs.setIntPref("group-" + firstGroup + "-minimumWidth", prefs.getIntPref("group-" + secondGroup + "-minimumWidth"));
        prefs.setIntPref("group-" + secondGroup + "-minimumWidth", groupMinimumWidth);
      } else {
        // Move first to second
        prefs.setIntPref("group-" + secondGroup + "-minimumWidth", prefs.getIntPref("group-" + firstGroup + "-minimumWidth"));
        prefs.clearUserPref("group-" + firstGroup + "-minimumWidth");
      }
    } else if (prefs.prefHasUserValue("group-" + secondGroup + "-minimumWidth")) {
      // Move second to first
      prefs.setIntPref("group-" + firstGroup + "-minimumWidth", prefs.getIntPref("group-" + secondGroup + "-minimumWidth"));
      prefs.clearUserPref("group-" + secondGroup + "-minimumWidth");
    }
    if (prefs.prefHasUserValue("group-" + firstGroup + "-minimumHeight")) {
      if (prefs.prefHasUserValue("group-" + secondGroup + "-minimumHeight")) {
        // Swap
        var groupMinimumHeight = prefs.getIntPref("group-" + firstGroup + "-minimumHeight");
        prefs.setIntPref("group-" + firstGroup + "-minimumHeight", prefs.getIntPref("group-" + secondGroup + "-minimumHeight"));
        prefs.setIntPref("group-" + secondGroup + "-minimumHeight", groupMinimumHeight);
      } else {
        // Move first to second
        prefs.setIntPref("group-" + secondGroup + "-minimumHeight", prefs.getIntPref("group-" + firstGroup + "-minimumHeight"));
        prefs.clearUserPref("group-" + firstGroup + "-minimumHeight");
      }
    } else if (prefs.prefHasUserValue("group-" + secondGroup + "-minimumHeight")) {
      // Move second to first
      prefs.setIntPref("group-" + firstGroup + "-minimumHeight", prefs.getIntPref("group-" + secondGroup + "-minimumHeight"));
      prefs.clearUserPref("group-" + secondGroup + "-minimumHeight");
    }
    
    if (prefs.prefHasUserValue("group-" + firstGroup + "-maximumWidth")) {
      if (prefs.prefHasUserValue("group-" + secondGroup + "-maximumWidth")) {
        // Swap
        var groupMaximumWidth = prefs.getIntPref("group-" + firstGroup + "-maximumWidth");
        prefs.setIntPref("group-" + firstGroup + "-maximumWidth", prefs.getIntPref("group-" + secondGroup + "-maximumWidth"));
        prefs.setIntPref("group-" + secondGroup + "-maximumWidth", groupMaximumWidth);
      } else {
        // Move first to second
        prefs.setIntPref("group-" + secondGroup + "-maximumWidth", prefs.getIntPref("group-" + firstGroup + "-maximumWidth"));
        prefs.clearUserPref("group-" + firstGroup + "-maximumWidth");
      }
    } else if (prefs.prefHasUserValue("group-" + secondGroup + "-maximumWidth")) {
      // Move second to first
      prefs.setIntPref("group-" + firstGroup + "-maximumWidth", prefs.getIntPref("group-" + secondGroup + "-maximumWidth"));
      prefs.clearUserPref("group-" + secondGroup + "-maximumWidth");
    }
    
    if (prefs.prefHasUserValue("group-" + firstGroup + "-maximumHeight")) {
      if (prefs.prefHasUserValue("group-" + secondGroup + "-maximumHeight")) {
        // Swap
        var groupMaximumHeight = prefs.getIntPref("group-" + firstGroup + "-maximumHeight");
        prefs.setIntPref("group-" + firstGroup + "-maximumHeight", prefs.getIntPref("group-" + secondGroup + "-maximumHeight"));
        prefs.setIntPref("group-" + secondGroup + "-maximumHeight", groupMaximumHeight);
      } else {
        // Move first to second
        prefs.setIntPref("group-" + secondGroup + "-maximumHeight", prefs.getIntPref("group-" + firstGroup + "-maximumHeight"));
        prefs.clearUserPref("group-" + firstGroup + "-maximumHeight");
      }
    } else if (prefs.prefHasUserValue("group-" + secondGroup + "-maximumHeight")) {
      // Move second to first
      prefs.setIntPref("group-" + firstGroup + "-maximumHeight", prefs.getIntPref("group-" + secondGroup + "-maximumHeight"));
      prefs.clearUserPref("group-" + secondGroup + "-maximumHeight");
    }
    
    if (prefs.prefHasUserValue("group-" + firstGroup + "-widthModifier")) {
      if (prefs.prefHasUserValue("group-" + secondGroup + "-widthModifier")) {
        // Swap
        var groupWidthModifier = prefs.getIntPref("group-" + firstGroup + "-widthModifier");
        prefs.setIntPref("group-" + firstGroup + "-widthModifier", prefs.getIntPref("group-" + secondGroup + "-widthModifier"));
        prefs.setIntPref("group-" + secondGroup + "-widthModifier", groupWidthModifier);
      } else {
        // Move first to second
        prefs.setIntPref("group-" + secondGroup + "-widthModifier", prefs.getIntPref("group-" + firstGroup + "-widthModifier"));
        prefs.clearUserPref("group-" + firstGroup + "-widthModifier");
      }
    } else if (prefs.prefHasUserValue("group-" + secondGroup + "-widthModifier")) {
      // Move second to first
      prefs.setIntPref("group-" + firstGroup + "-widthModifier", prefs.getIntPref("group-" + secondGroup + "-widthModifier"));
      prefs.clearUserPref("group-" + secondGroup + "-widthModifier");
    }
    
    if (prefs.prefHasUserValue("group-" + firstGroup + "-widthModifierType")) {
      if (prefs.prefHasUserValue("group-" + secondGroup + "-widthModifierType")) {
        // Swap
        var groupWidthModifierType = prefs.getIntPref("group-" + firstGroup + "-widthModifierType");
        prefs.setIntPref("group-" + firstGroup + "-widthModifierType", prefs.getIntPref("group-" + secondGroup + "-widthModifierType"));
        prefs.setIntPref("group-" + secondGroup + "-widthModifierType", groupWidthModifierType);
      } else {
        // Move first to second
        prefs.setIntPref("group-" + secondGroup + "-widthModifierType", prefs.getIntPref("group-" + firstGroup + "-widthModifierType"));
        prefs.clearUserPref("group-" + firstGroup + "-widthModifierType");
      }
    } else if (prefs.prefHasUserValue("group-" + secondGroup + "-widthModifierType")) {
      // Move second to first
      prefs.setIntPref("group-" + firstGroup + "-widthModifierType", prefs.getIntPref("group-" + secondGroup + "-widthModifierType"));
      prefs.clearUserPref("group-" + secondGroup + "-widthModifierType");
    }
    
    if (prefs.prefHasUserValue("group-" + firstGroup + "-heightModifier")) {
      if (prefs.prefHasUserValue("group-" + secondGroup + "-heightModifier")) {
        // Swap
        var groupHeightModifier = prefs.getIntPref("group-" + firstGroup + "-heightModifier");
        prefs.setIntPref("group-" + firstGroup + "-heightModifier", prefs.getIntPref("group-" + secondGroup + "-heightModifier"));
        prefs.setIntPref("group-" + secondGroup + "-heightModifier", groupHeightModifier);
      } else {
        // Move first to second
        prefs.setIntPref("group-" + secondGroup + "-heightModifier", prefs.getIntPref("group-" + firstGroup + "-heightModifier"));
        prefs.clearUserPref("group-" + firstGroup + "-heightModifier");
      }
    } else if (prefs.prefHasUserValue("group-" + secondGroup + "-heightModifier")) {
      // Move second to first
      prefs.setIntPref("group-" + firstGroup + "-heightModifier", prefs.getIntPref("group-" + secondGroup + "-heightModifier"));
      prefs.clearUserPref("group-" + secondGroup + "-heightModifier");
    }
    
    if (prefs.prefHasUserValue("group-" + firstGroup + "-heightModifierType")) {
      if (prefs.prefHasUserValue("group-" + secondGroup + "-heightModifierType")) {
        // Swap
        var groupHeightModifierType = prefs.getIntPref("group-" + firstGroup + "-heightModifierType");
        prefs.setIntPref("group-" + firstGroup + "-heightModifierType", prefs.getIntPref("group-" + secondGroup + "-heightModifierType"));
        prefs.setIntPref("group-" + secondGroup + "-heightModifierType", groupHeightModifierType);
      } else {
        // Move first to second
        prefs.setIntPref("group-" + secondGroup + "-heightModifierType", prefs.getIntPref("group-" + firstGroup + "-heightModifierType"));
        prefs.clearUserPref("group-" + firstGroup + "-heightModifierType");
      }
    } else if (prefs.prefHasUserValue("group-" + secondGroup + "-heightModifierType")) {
      // Move second to first
      prefs.setIntPref("group-" + firstGroup + "-heightModifierType", prefs.getIntPref("group-" + secondGroup + "-heightModifierType"));
      prefs.clearUserPref("group-" + secondGroup + "-heightModifierType");
    }
    
    
    var firstGroupTotal = firstGroupRows * firstGroupCols;
    var secondGroupTotal = secondGroupRows * secondGroupCols;

    var thumbsPerGroup = firstGroupTotal;
    
    if (firstGroupTotal > secondGroupTotal) {
      SpeedDialUtils.setNewGroupSize(secondGroup, firstGroupRows, firstGroupCols);
      thumbsPerGroup = firstGroupTotal;
    } else if (firstGroupTotal < secondGroupTotal) {
      SpeedDialUtils.setNewGroupSize(firstGroup, secondGroupRows, secondGroupCols);
      thumbsPerGroup = secondGroupTotal;
    }
    
    var firstGroupInitialDial = SpeedDialUtils.getGroupFirstDialNumber(firstGroup);
    var secondGroupInitialDial = SpeedDialUtils.getGroupFirstDialNumber(secondGroup);
    
    for (var c=0; c<thumbsPerGroup; c++) {
      SpeedDialUtils.swapThumbnails(firstGroupInitialDial + c, secondGroupInitialDial + c);
    }
    
    SpeedDialUtils.setNewGroupSize(firstGroup, secondGroupRows, secondGroupCols);
    SpeedDialUtils.setNewGroupSize(secondGroup, firstGroupRows, firstGroupCols);
  },

  copyThumbnailData: function(originalDial, targetDial) {
    var prefs = SpeedDialUtils.prefs;

    // Copy data
    if (prefs.prefHasUserValue("thumbnail-" + originalDial + "-url")) {
      prefs.setCharPref("thumbnail-" + targetDial + "-url", prefs.getCharPref("thumbnail-" + originalDial + "-url"));
    }
  
    if (prefs.prefHasUserValue("thumbnail-" + originalDial + "-icon")) {
      prefs.setCharPref("thumbnail-" + targetDial + "-icon", prefs.getCharPref("thumbnail-" + originalDial + "-icon"));
    }
  
    if (prefs.prefHasUserValue("thumbnail-" + originalDial + "-label")) {
      prefs.setComplexValue("thumbnail-" + targetDial + "-label", Components.interfaces.nsISupportsString, prefs.getComplexValue("thumbnail-" + originalDial + "-label", Components.interfaces.nsISupportsString));
    }
  
    if (prefs.prefHasUserValue("thumbnail-" + originalDial + "-lastsaved")) {
      prefs.setCharPref("thumbnail-" + targetDial + "-lastsaved", prefs.getCharPref("thumbnail-" + originalDial + "-lastsaved"));
    }
  
    if (prefs.prefHasUserValue("thumbnail-" + originalDial + "-dynamictitle")) {
      prefs.setBoolPref("thumbnail-" + targetDial + "-dynamictitle", prefs.getBoolPref("thumbnail-" + originalDial + "-dynamictitle"));
    }
  
    if (prefs.prefHasUserValue("thumbnail-" + originalDial + "-refreshinterval")) {
      prefs.setIntPref("thumbnail-" + targetDial + "-refreshinterval", prefs.getIntPref("thumbnail-" + originalDial + "-refreshinterval"));
    }
  
    if (prefs.prefHasUserValue("thumbnail-" + originalDial + "-manualrefresh")) {
      prefs.setBoolPref("thumbnail-" + targetDial + "-manualrefresh", prefs.getBoolPref("thumbnail-" + originalDial + "-manualrefresh"));
    }
  
    if (prefs.prefHasUserValue("thumbnail-" + originalDial + "-format")) {
      prefs.setCharPref("thumbnail-" + targetDial + "-format", prefs.getCharPref("thumbnail-" + originalDial + "-format"));
    }
  
    if (prefs.prefHasUserValue("thumbnail-" + originalDial + "-backgroundcolor")) {
      prefs.setCharPref("thumbnail-" + targetDial + "-backgroundcolor", prefs.getCharPref("thumbnail-" + originalDial + "-backgroundcolor"));
    }
  
    if (prefs.prefHasUserValue("thumbnail-" + originalDial + "-layout")) {
      prefs.setIntPref("thumbnail-" + targetDial + "-layout", prefs.getIntPref("thumbnail-" + originalDial + "-layout"));
    }
  
    if (prefs.prefHasUserValue("thumbnail-" + originalDial + "-cropping")) {
      prefs.setCharPref("thumbnail-" + targetDial + "-cropping", prefs.getCharPref("thumbnail-" + originalDial + "-cropping"));
    }
  
    if (prefs.prefHasUserValue("thumbnail-" + originalDial + "-thumbnailurl")) {
      prefs.setCharPref("thumbnail-" + targetDial + "-thumbnailurl", prefs.getCharPref("thumbnail-" + originalDial + "-thumbnailurl"));
    }
  
    if (prefs.prefHasUserValue("thumbnail-" + originalDial + "-extra")) {
      prefs.setCharPref("thumbnail-" + targetDial + "-extra", prefs.getCharPref("thumbnail-" + originalDial + "-extra"));
    }
  
    if (prefs.prefHasUserValue("thumbnail-" + originalDial + "-js")) {
      prefs.setBoolPref("thumbnail-" + targetDial + "-js", prefs.getBoolPref("thumbnail-" + originalDial + "-js"));
    }
  },

  copyThumbnailImage: function(originalNumber, destinationNumber) {
    var prefs = SpeedDialUtils.prefs;
    var file = Components.classes["@mozilla.org/file/directory_service;1"]
                       .getService(Components.interfaces.nsIProperties)
                       .get("ProfD", Components.interfaces.nsIFile);
    file.append(SpeedDialUtils.thumbFolder);
    var thumbFolder = file.clone();
    
    var fileExtension = prefs.getCharPref("imageFormat");
    if (prefs.prefHasUserValue("thumbnail-" + originalNumber + "-format")) {
      fileExtension = prefs.getCharPref("thumbnail-" + originalNumber + "-format");
    } else if (prefs.prefHasUserValue("thumbnail-" + destinationNumber + "-format")) {
      fileExtension = prefs.getCharPref("thumbnail-" + destinationNumber + "-format");
    }  
    
    if (prefs.prefHasUserValue("thumbnail-" + originalNumber + "-lastsaved")) {
      file.append("thumbnail-" + originalNumber + "-" + prefs.getCharPref("thumbnail-" + originalNumber + "-lastsaved") + "." + fileExtension);
    } else {
      file.append("thumbnail-" + originalNumber + "." + fileExtension);
    }
    
    var destFileName;
    if (prefs.prefHasUserValue("thumbnail-" + destinationNumber + "-lastsaved")) {
      destFileName = "thumbnail-" + destinationNumber + "-" + prefs.getCharPref("thumbnail-" + destinationNumber + "-lastsaved") + "." + fileExtension;
    } else {
      destFileName = "thumbnail-" + destinationNumber + "." + fileExtension;
    }
    
    if (file.exists() && !file.isDirectory()) {
      file.copyTo(thumbFolder, destFileName);
    }
  },

  moveThumbnailImage: function(originalNumber, destinationNumber) {
    var prefs = SpeedDialUtils.prefs;
    var file = Components.classes["@mozilla.org/file/directory_service;1"]
                       .getService(Components.interfaces.nsIProperties)
                       .get("ProfD", Components.interfaces.nsIFile);
    file.append(SpeedDialUtils.thumbFolder);
    var thumbFolder = file.clone();
  
    var fileExtension = prefs.getCharPref("imageFormat");
    if (prefs.prefHasUserValue("thumbnail-" + originalNumber + "-format")) {
      fileExtension = prefs.getCharPref("thumbnail-" + originalNumber + "-format");
    } else if (prefs.prefHasUserValue("thumbnail-" + destinationNumber + "-format")) {
      fileExtension = prefs.getCharPref("thumbnail-" + destinationNumber + "-format");
    }
  
    if (prefs.prefHasUserValue("thumbnail-" + originalNumber + "-lastsaved")) {
      file.append("thumbnail-" + originalNumber + "-" + prefs.getCharPref("thumbnail-" + originalNumber + "-lastsaved") + "." + fileExtension);
    } else {
      file.append("thumbnail-" + originalNumber + "." + fileExtension);
    }
  
    var destFileName;
    if (prefs.prefHasUserValue("thumbnail-" + destinationNumber + "-lastsaved")) {
      destFileName = "thumbnail-" + destinationNumber + "-" + prefs.getCharPref("thumbnail-" + destinationNumber + "-lastsaved") + "." + fileExtension;
    } else {
      destFileName = "thumbnail-" + destinationNumber + "." + fileExtension;
    }
  //alert("file: " + file.path + ", to: " + destFileName);
    if (file.exists() && !file.isDirectory()) {
      try {
        file.moveTo(thumbFolder, destFileName);
      } catch (e) {
        try {
          file.copyTo(thumbFolder, destFileName);
        } catch (e) {
          SpeedDialUtils.log("Couldn't relocate thumbnail: " + e);
        }
      }
    }
  },
  
  updateLastSaved: function(targetNumber, newTime) {
    var prefs = SpeedDialUtils.prefs;
    var file = Components.classes["@mozilla.org/file/directory_service;1"]
                       .getService(Components.interfaces.nsIProperties)
                       .get("ProfD", Components.interfaces.nsIFile);
    file.append(SpeedDialUtils.thumbFolder);
    var thumbFolder = file.clone();
  
    var fileExtension = prefs.getCharPref("imageFormat");
    if (prefs.prefHasUserValue("thumbnail-" + targetNumber + "-format")) {
      fileExtension = prefs.getCharPref("thumbnail-" + targetNumber + "-format");
    } else if (prefs.prefHasUserValue("thumbnail-" + targetNumber + "-format")) {
      fileExtension = prefs.getCharPref("thumbnail-" + targetNumber + "-format");
    }
    
    if (prefs.prefHasUserValue("thumbnail-" + targetNumber + "-lastsaved")) {
      file.append("thumbnail-" + targetNumber + "-" + prefs.getCharPref("thumbnail-" + targetNumber + "-lastsaved") + "." + fileExtension);
    } else {
      file.append("thumbnail-" + targetNumber + "." + fileExtension);
    }
  
    prefs.setCharPref("thumbnail-" + targetNumber + "-lastsaved", "" + newTime);
    var destFileName = "thumbnail-" + targetNumber + "-" + newTime + "." + fileExtension;

    //alert("file: " + file.path + ", to: " + destFileName);
    if (file.exists() && !file.isDirectory()) {
      try {
        file.moveTo(thumbFolder, destFileName);
      } catch (e) {
        try {
          file.copyTo(thumbFolder, destFileName);
        } catch (e) {
          SpeedDialUtils.log("Couldn't relocate thumbnail: " + e);
        }
      }
    }
    
    // Store URL in cache...
    var URLSpec = Components.classes['@mozilla.org/network/protocol;1?name=file'] .createInstance(Components.interfaces.nsIFileProtocolHandler).getURLSpecFromFile(file);
//    window.setTimeout(SpeedDialUtils.updateCacheEntry, 0, targetNumber, URLSpec);
    SpeedDialUtils.updateCacheEntry(targetNumber, URLSpec);
  },
  
  swapThumbnailImage: function(firstNumber, secondNumber) {
    var prefs = SpeedDialUtils.prefs;
    var file = Components.classes["@mozilla.org/file/directory_service;1"]
                       .getService(Components.interfaces.nsIProperties)
                       .get("ProfD", Components.interfaces.nsIFile);
    file.append(SpeedDialUtils.thumbFolder);
    var thumbFolder = file.clone();
  
    var firstFileExtension = prefs.getCharPref("imageFormat");
    var secondFileExtension = firstFileExtension;
    if (prefs.prefHasUserValue("thumbnail-" + firstNumber + "-format")) {
      firstFileExtension = prefs.getCharPref("thumbnail-" + firstNumber + "-format");
    }
    if (prefs.prefHasUserValue("thumbnail-" + secondNumber + "-format")) {
      secondFileExtension = prefs.getCharPref("thumbnail-" + secondNumber + "-format");
    }
    
    var firstFile = file.clone();
    var secondFile = file.clone();
    var firstFileName;
    var secondFileName;
    if (prefs.prefHasUserValue("thumbnail-" + firstNumber + "-lastsaved")) {
      var lastSaved = prefs.getCharPref("thumbnail-" + firstNumber + "-lastsaved");
      firstFile.append("thumbnail-" + firstNumber + "-" + lastSaved + "." + firstFileExtension);
      secondFileName = "thumbnail-" + secondNumber + "-" + lastSaved + "." + firstFileExtension;
    } else {
      firstFile.append("thumbnail-" + firstNumber + "." + firstFileExtension);
      secondFileName = "thumbnail-" + secondNumber + "." + firstFileExtension;
    }
    if (prefs.prefHasUserValue("thumbnail-" + secondNumber + "-lastsaved")) {
      var lastSaved = prefs.getCharPref("thumbnail-" + secondNumber + "-lastsaved");
      secondFile.append("thumbnail-" + secondNumber + "-" + lastSaved + "." + secondFileExtension);
      firstFileName = "thumbnail-" + firstNumber + "-" + lastSaved + "." + secondFileExtension;
    } else {
      secondFile.append("thumbnail-" + secondNumber + "." + secondFileExtension);
      firstFileName = "thumbnail-" + firstNumber + "." + secondFileExtension;
    }
    
    var tempFileName = "thumbnail.tmp";
    file.append(tempFileName);
    
    if (!firstFile.exists() || firstFile.isDirectory()) {
      if (secondFile.exists() && !secondFile.isDirectory()) {
        secondFile.moveTo(thumbFolder, firstFileName);
      }
    } else if (!secondFile.exists() || secondFile.isDirectory()) {
      firstFile.moveTo(thumbFolder, secondFileName);
    } else {
      firstFile.moveTo(thumbFolder, tempFileName);
      secondFile.moveTo(thumbFolder, firstFileName);
      file.moveTo(thumbFolder, secondFileName);
    }
    
    // Swap cache, also
    var cacheService = SpeedDialUtils.getCacheService();
    var firstCache = cacheService.getImage(firstNumber);
    cacheService.setImageObject(cacheService.getImage(secondNumber), firstNumber);
    cacheService.setImageObject(firstCache, secondNumber);
  },
  
  swapThumbnails: function(firstDial, secondDial) {
    var prefs = SpeedDialUtils.prefs;

    var dialURL = null;
    var dialIcon = null;
    var dialLabel = null;
    var dialLastSaved = null;
    var dialDynamicTitle = null;
    var dialRefreshInterval = null;
    var dialManualRefresh = null;
    var dialFormat = null;
    var dialBackgroundColor = null;
    var dialLayout = null;
    var dialCropping = null;
    var dialThumbnailURL = null;
    var dialExtra = null;
    var dialJs = null;

    // Copy data
    if (prefs.prefHasUserValue("thumbnail-" + firstDial + "-url")) {
      dialURL = prefs.getCharPref("thumbnail-" + firstDial + "-url");
    }
  
    if (prefs.prefHasUserValue("thumbnail-" + firstDial + "-icon")) {
      dialIcon = prefs.getCharPref("thumbnail-" + firstDial + "-icon");
    }
  
    if (prefs.prefHasUserValue("thumbnail-" + firstDial + "-label")) {
      dialLabel = prefs.getComplexValue("thumbnail-" + firstDial + "-label", Components.interfaces.nsISupportsString);
    }
  
    if (prefs.prefHasUserValue("thumbnail-" + firstDial + "-lastsaved")) {
      dialLastSaved = prefs.getCharPref("thumbnail-" + firstDial + "-lastsaved");
    }
  
    if (prefs.prefHasUserValue("thumbnail-" + firstDial + "-dynamictitle")) {
      dialDynamicTitle = prefs.getBoolPref("thumbnail-" + firstDial + "-dynamictitle");
    }
  
    if (prefs.prefHasUserValue("thumbnail-" + firstDial + "-refreshinterval")) {
      dialRefreshInterval = prefs.getIntPref("thumbnail-" + firstDial + "-refreshinterval");
    }
  
    if (prefs.prefHasUserValue("thumbnail-" + firstDial + "-manualrefresh")) {
      dialManualRefresh = prefs.getBoolPref("thumbnail-" + firstDial + "-manualrefresh");
    }
  
    if (prefs.prefHasUserValue("thumbnail-" + firstDial + "-format")) {
      dialFormat = prefs.getCharPref("thumbnail-" + firstDial + "-format");
    }
  
    if (prefs.prefHasUserValue("thumbnail-" + firstDial + "-backgroundcolor")) {
      dialBackgroundColor = prefs.getCharPref("thumbnail-" + firstDial + "-backgroundcolor");
    }
  
    if (prefs.prefHasUserValue("thumbnail-" + firstDial + "-layout")) {
      dialLayout = prefs.getIntPref("thumbnail-" + firstDial + "-layout");
    }
  
    if (prefs.prefHasUserValue("thumbnail-" + firstDial + "-cropping")) {
      dialCropping = prefs.getCharPref("thumbnail-" + firstDial + "-cropping");
    }
  
    if (prefs.prefHasUserValue("thumbnail-" + firstDial + "-thumbnailurl")) {
      dialThumbnailURL = prefs.getCharPref("thumbnail-" + firstDial + "-thumbnailurl");
    }
    
    if (prefs.prefHasUserValue("thumbnail-" + firstDial + "-extra")) {
      dialExtra = prefs.getCharPref("thumbnail-" + firstDial + "-extra");
    }
  
    if (prefs.prefHasUserValue("thumbnail-" + firstDial + "-js")) {
      dialJs = prefs.getBoolPref("thumbnail-" + firstDial + "-js");
    }
  
    // Swap thumbnails
    SpeedDialUtils.swapThumbnailImage(secondDial, firstDial);
    
    // Clean first dial
    SpeedDialUtils.clearThumbnailData(firstDial);

    SpeedDialUtils.copyThumbnailData(secondDial, firstDial);
    
    if (dialURL != null) {
      prefs.setCharPref("thumbnail-" + secondDial + "-url", dialURL);
    } else if (prefs.prefHasUserValue("thumbnail-" + secondDial + "-url")) {
      prefs.clearUserPref("thumbnail-" + secondDial + "-url");
    }
    if (dialIcon != null) {
      prefs.setCharPref("thumbnail-" + secondDial + "-icon", dialIcon);
    } else if (prefs.prefHasUserValue("thumbnail-" + secondDial + "-icon")) {
      prefs.clearUserPref("thumbnail-" + secondDial + "-icon");
    }
    if (dialLabel != null) {
      prefs.setComplexValue("thumbnail-" + secondDial + "-label", Components.interfaces.nsISupportsString, dialLabel);
    } else if (prefs.prefHasUserValue("thumbnail-" + secondDial + "-label")) {
      prefs.clearUserPref("thumbnail-" + secondDial + "-label");
    }
    if (dialLastSaved != null) {
      prefs.setCharPref("thumbnail-" + secondDial + "-lastsaved", dialLastSaved);
    } else if (prefs.prefHasUserValue("thumbnail-" + secondDial + "-lastsaved")) {
      prefs.clearUserPref("thumbnail-" + secondDial + "-lastsaved");
    }
    if (dialDynamicTitle != null) {
      prefs.setBoolPref("thumbnail-" + secondDial + "-dynamictitle", dialDynamicTitle);
    } else if (prefs.prefHasUserValue("thumbnail-" + secondDial + "-dynamictitle")) {
      prefs.clearUserPref("thumbnail-" + secondDial + "-dynamictitle");
    }
    if (dialRefreshInterval != null) {
      prefs.setIntPref("thumbnail-" + secondDial + "-refreshinterval", dialRefreshInterval);
    } else if (prefs.prefHasUserValue("thumbnail-" + secondDial + "-refreshinterval")) {
      prefs.clearUserPref("thumbnail-" + secondDial + "-refreshinterval");
    }
    if (dialManualRefresh != null) {
      prefs.setBoolPref("thumbnail-" + secondDial + "-manualrefresh", dialManualRefresh);
    } else if (prefs.prefHasUserValue("thumbnail-" + secondDial + "-manualrefresh")) {
      prefs.clearUserPref("thumbnail-" + secondDial + "-manualrefresh");
    }
    if (dialFormat != null) {
      prefs.setCharPref("thumbnail-" + secondDial + "-format", dialFormat);
    } else if (prefs.prefHasUserValue("thumbnail-" + secondDial + "-format")) {
      prefs.clearUserPref("thumbnail-" + secondDial + "-format");
    }
    if (dialBackgroundColor != null) {
      prefs.setCharPref("thumbnail-" + secondDial + "-backgroundcolor", dialBackgroundColor);
    } else if (prefs.prefHasUserValue("thumbnail-" + secondDial + "-backgroundcolor")) {
      prefs.clearUserPref("thumbnail-" + secondDial + "-backgroundcolor");
    }
    if (dialLayout != null) {
      prefs.setIntPref("thumbnail-" + secondDial + "-layout", dialLayout);
    } else if (prefs.prefHasUserValue("thumbnail-" + secondDial + "-layout")) {
      prefs.clearUserPref("thumbnail-" + secondDial + "-layout");
    }
    if (dialCropping != null) {
      prefs.setCharPref("thumbnail-" + secondDial + "-cropping", dialCropping);
    } else if (prefs.prefHasUserValue("thumbnail-" + secondDial + "-cropping")) {
      prefs.clearUserPref("thumbnail-" + secondDial + "-cropping");
    }
    if (dialThumbnailURL != null) {
      prefs.setCharPref("thumbnail-" + secondDial + "-thumbnailurl", dialThumbnailURL);
    } else if (prefs.prefHasUserValue("thumbnail-" + secondDial + "-thumbnailurl")) {
      prefs.clearUserPref("thumbnail-" + secondDial + "-thumbnailurl");
    }
    if (dialExtra != null) {
      prefs.setCharPref("thumbnail-" + secondDial + "-extra", dialExtra);
    } else if (prefs.prefHasUserValue("thumbnail-" + secondDial + "-extra")) {
      prefs.clearUserPref("thumbnail-" + secondDial + "-extra");
    }
    if (dialJs != null) {
      prefs.setBoolPref("thumbnail-" + secondDial + "-js", dialJs);
    } else if (prefs.prefHasUserValue("thumbnail-" + secondDial + "-js")) {
      prefs.clearUserPref("thumbnail-" + secondDial + "-js");
    }
  },
  
  getDomain: function(url) {
    var result = url.split("/");
    if (result.length < 3) {
      return '';
    }
    
    var protocol = result[2].toLowerCase();
    if ((protocol != 'http') && (protocol != 'https')) {
      return '';
    }
    
    try {
      var domain = result[2].toLowerCase();
      var resultDot = domain.split(".");
      if (resultDot.length > 1) {
        return resultDot[resultDot.length - 2] + "." + resultDot[resultDot.length - 1];
      } else {
        return domain;
      }
    } catch (e) {
      return '';
    }
  },

  getDistinctUrls: function(aURIString) {
    var urls = new Array();
    if (aURIString.indexOf('|') > -1) {
      var targetString = aURIString.replace(/([^\\])\|/g, "$1||");
      urls = targetString.split(/\|\|/g);
      for (var c=0; c<urls.length; c++) {
        urls[c] = urls[c].replace(/\\\|/g, "|");
      }
    } else {
      urls[0] = aURIString;
    }
    return urls;
  },
  
  stringStartsWith: function(targetString, targetStart) {
    return (targetString.indexOf(targetStart) == 0);
  },
  
  fetchURL: function(targetURL) {
    var httpRequest = null;
    
    //Try to create our XMLHttpRequest Object
    try {
      httpRequest = new XMLHttpRequest();
      httpRequest.open("GET", targetURL, false, null, null);
      httpRequest.send('');
    } catch (e){
      return null;
    }
    
    //Make sure we received a valid response
    switch(httpRequest.readyState) {
      case 1,2,3:
        return null;
        break;
      case 4:
        if(httpRequest.status !=200) {
          return null;
        } else {
          return httpRequest.responseText;
        }
        break;
    }
  },
  
  asyncFetchURL: function(targetURL, callback) {
    var httpRequest = null;
    
    //Try to create our XMLHttpRequest Object
    try {
      httpRequest = new XMLHttpRequest();
      httpRequest.open("GET", targetURL, true);
      httpRequest.onreadystatechange = function() {
        callback(httpRequest);
      };
      httpRequest.send(null);
    } catch (e){
      return false;
    }
    return true;
  },

  updateCacheEntry: function(targetDial, imageURL) {
    var cacheService = SpeedDialUtils.getCacheService();

//    if (cacheService.wrappedJSObject.hasImage(targetDial)) {
//      var cachedImage = cacheService.wrappedJSObject.getImage(targetDial);
//      cachedImage.imageLoaded = false;
//      cachedImage.src = imageURL;
//    } else {
      cacheService.wrappedJSObject.setImage(imageURL, targetDial);
//    }
  },
  
  getTimeUnitIndex: function(targetValue) {
    var foundUnit = false;
    var currentIndex = 0;
    var lastValidIndex = 0;
    while (!foundUnit && (currentIndex < SpeedDialUtils.timeUnits.length)) {
      if (((targetValue % SpeedDialUtils.timeUnits[currentIndex]) < 1)&&((targetValue / SpeedDialUtils.timeUnits[currentIndex]) > 1)) {
        lastValidIndex = currentIndex;
      } else {
        foundUnit = true;
      }
      currentIndex++;
    }
    
    return lastValidIndex;
  },
  
  getTotalDials: function() {
    var prefs = SpeedDialUtils.prefs;
    var numGroups = prefs.getIntPref("numGroups");
    var rows = prefs.getIntPref("rows");
    var cols = prefs.getIntPref("columns");
    var totalDials = 0;
    for (var b=1; b<=numGroups; b++) {
      var currentRows = rows;
      var currentCols = cols;
      if (prefs.prefHasUserValue("group-" + b + "-rows")) {
        currentRows = prefs.getIntPref("group-" + b + "-rows");
      }
      if (prefs.prefHasUserValue("group-" + b + "-columns")) {
        currentCols = prefs.getIntPref("group-" + b + "-columns");
      }
      totalDials += currentRows * currentCols;
    }
    return totalDials;
  },
  
  getGroupFirstDialNumber: function(targetGroup) {
    var prefs = SpeedDialUtils.prefs;
    var rows = prefs.getIntPref("rows");
    var cols = prefs.getIntPref("columns");
    var returnDial = 1;
    for (var b=1; b<targetGroup; b++) {
      var currentRows = rows;
      var currentCols = cols;
      if (prefs.prefHasUserValue("group-" + b + "-rows")) {
        currentRows = prefs.getIntPref("group-" + b + "-rows");
      }
      if (prefs.prefHasUserValue("group-" + b + "-columns")) {
        currentCols = prefs.getIntPref("group-" + b + "-columns");
      }
      returnDial += currentRows * currentCols;
    }
    
    return returnDial;
  },

  getGroupTotalDials: function(targetGroup) {
    var prefs = SpeedDialUtils.prefs;
    var rows = prefs.getIntPref("rows");
    var cols = prefs.getIntPref("columns");
    if (prefs.prefHasUserValue("group-" + targetGroup + "-rows")) {
      rows = prefs.getIntPref("group-" + targetGroup + "-rows");
    }
    if (prefs.prefHasUserValue("group-" + targetGroup + "-columns")) {
      cols = prefs.getIntPref("group-" + targetGroup + "-columns");
    }
    
    return (rows * cols);
  },
  
  checkNewGroupSizeFits: function(targetGroup, newRows, newCols) {
    var prefs = SpeedDialUtils.prefs;
    var currentTotal = SpeedDialUtils.getGroupTotalDials(targetGroup);
    var newTotal = newRows * newCols;
    
    if (newTotal >= currentTotal)
      return true;
    
    var foundDial = false;
    var initialDial = SpeedDialUtils.getGroupFirstDialNumber(targetGroup);
    for (var c=newTotal;((c<currentTotal) && !foundDial);c++) {
      if (prefs.prefHasUserValue("thumbnail-" + (initialDial + c) + "-url")) {
        foundDial = true;
      }
    }
    
    return !foundDial;
  },
  
  setNewGroupSize: function(targetGroup, newRows, newCols) {
    var prefs = SpeedDialUtils.prefs;
    var rows = prefs.getIntPref("rows");
    var cols = prefs.getIntPref("columns");
    var currentRows = rows;
    var currentCols = cols;
    if (prefs.prefHasUserValue("group-" + targetGroup + "-rows")) {
      currentRows = prefs.getIntPref("group-" + targetGroup + "-rows");
    }
    if (prefs.prefHasUserValue("group-" + targetGroup + "-columns")) {
      currentCols = prefs.getIntPref("group-" + targetGroup + "-columns");
    }
    
    var currentTotal = currentRows * currentCols;
    var newTotal = newRows * newCols;
    var totalDials = SpeedDialUtils.getTotalDials();
    
    if (currentTotal == newTotal) {
      // Do nothing
    } else if (currentTotal < newTotal) {
      var nextGroupInitialDial = SpeedDialUtils.getGroupFirstDialNumber(targetGroup + 1);
      for (var c=totalDials;c>=nextGroupInitialDial;c--) {
        SpeedDialUtils.swapThumbnails(c, (c+newTotal-currentTotal));
      }
    } else { // if (currentTotal > newTotal) {
      var initialDial = SpeedDialUtils.getGroupFirstDialNumber(targetGroup);
      
      for (var c=newTotal;c<currentTotal;c++) {
        if (prefs.prefHasUserValue("thumbnail-" + (initialDial + c) + "-url")) {
          SpeedDialUtils.deassignThumbnail((initialDial + c));
        }
      }

      for (var c=initialDial + newTotal;c<=(totalDials-(currentTotal-newTotal));c++) {
        SpeedDialUtils.swapThumbnails(c, (c+currentTotal - newTotal));
      }
    }
    
    prefs.setIntPref("group-" + targetGroup + "-rows", newRows);
    prefs.setIntPref("group-" + targetGroup + "-columns", newCols);
  },
  
  getDialIcon: function(targetDial) {
    var prefs = SpeedDialUtils.prefs;
    var thumbnailIcon;
    var thumbnailURL = prefs.getCharPref("thumbnail-" + targetDial + "-url");
    if (SpeedDialUtils.stringStartsWith(thumbnailURL, "weather:")) {
      if (prefs.prefHasUserValue("thumbnail-" + targetDial + "-extra")) {
        var thumbnailExtras =  prefs.getCharPref("thumbnail-" + targetDial + "-extra").split('#');
        if (thumbnailExtras.length > 2) {
          thumbnailIcon = 'chrome://speeddial/skin/weather/' + thumbnailExtras[2] + '.png';
        }
      }
    } else if (SpeedDialUtils.stringStartsWith(thumbnailURL, "javascript:")) {
      thumbnailIcon = "moz-icon://dummy?size=16&contentType=application/x-javascript";
    } else if (SpeedDialUtils.stringStartsWith(thumbnailURL, "launch:")) {
      try {
        var obj = Components.classes["@mozilla.org/file/local;1"].
              createInstance(Components.interfaces.nsILocalFile);
        obj.initWithPath(thumbnailURL.substr("launch:".length));
        
        thumbnailIcon = "moz-icon:" +  SpeedDialUtils.ioService.newFileURI(obj).spec + "?size=16";
      } catch (e) {}
    } else if (SpeedDialUtils.stringStartsWith(thumbnailURL, "mailto:")) {
      thumbnailIcon = "moz-icon://.EML?size=16";
    } else if (SpeedDialUtils.stringStartsWith(thumbnailURL, "irc:")
      || SpeedDialUtils.stringStartsWith(thumbnailURL, "telnet:")
      || SpeedDialUtils.stringStartsWith(thumbnailURL, "plugin:")
      || SpeedDialUtils.stringStartsWith(thumbnailURL, "bbs2chreader:")
      ) {
      thumbnailIcon = "chrome://speeddial/skin/plugin16.png";
    } else {
      if (SpeedDialUtils.faviconService == null) {
        SpeedDialUtils.faviconService = Components.classes["@mozilla.org/browser/favicon-service;1"].getService(Components.interfaces.nsIFaviconService);
      }
      try {
        thumbnailIcon = SpeedDialUtils.faviconService.getFaviconImageForPage(SpeedDialUtils.ioService.newURI(thumbnailURL, null, null)).spec;
      } catch (e) { }
    }
    return thumbnailIcon;
  },
  
  setupWeatherDial: function() {
    var prefs = SpeedDialUtils.prefs;
    var foundWeather = false;
    var firstIndexAvailable = -1;
    var totalDials = SpeedDialUtils.getTotalDials();
    for (var c=1; (c<=totalDials)&&!foundWeather; c++) {
      if (prefs.prefHasUserValue("thumbnail-" + c + "-url")) {
        if (SpeedDialUtils.stringStartsWith(prefs.getCharPref("thumbnail-" + c + "-url"), "weather:")) {
          foundWeather = true;
        } else if (prefs.prefHasUserValue("thumbnail-" + c + "-thumbnailurl")) {
          if (SpeedDialUtils.stringStartsWith(prefs.getCharPref("thumbnail-" + c + "-thumbnailurl"), "weather:")) {
            foundWeather = true;
          }
        }
      } else if (firstIndexAvailable < 0) {
        firstIndexAvailable = c;
      }
    }
    
    if ((!foundWeather) && (firstIndexAvailable > -1)) {
      // Add dial
      SpeedDialUtils.clearThumbnailData(firstIndexAvailable);
      prefs.setIntPref("thumbnail-" + firstIndexAvailable + "-layout", 3);
      prefs.setIntPref("thumbnail-" + firstIndexAvailable + "-refreshinterval", 1800);
      prefs.setCharPref("thumbnail-" + firstIndexAvailable + "-cropping", "0,0,160,40");
      var str = Components.classes["@mozilla.org/supports-string;1"].createInstance(Components.interfaces.nsISupportsString);
      str.data = "Weather Dial";
      prefs.setComplexValue("thumbnail-" + firstIndexAvailable + "-label", Components.interfaces.nsISupportsString, str);
      
      if (!SpeedDialUtils.isFirefox3()) {
        prefs.setCharPref("thumbnail-" + firstIndexAvailable + "-icon", "data:");
      }
      prefs.setBoolPref("thumbnail-" + firstIndexAvailable + "-dynamictitle", true);
      prefs.setCharPref("thumbnail-" + firstIndexAvailable + "-url", "weather:");
    }
  },
  
  showOptions: function() {
    var globalPrefs = Components.classes["@mozilla.org/preferences-service;1"]
                   .getService(Components.interfaces.nsIPrefService)
                   .QueryInterface(Components.interfaces.nsIPrefBranch2);
    var features;
    try {
      var instantApply = globalPrefs.getBoolPref("browser.preferences.instantApply");
      features = "chrome,titlebar,toolbar,centerscreen," + (instantApply ? "dialog=no" : "modal,resizable");
    } catch (e) {
      features = "chrome,titlebar,toolbar,centerscreen,modal,resizable";
    }
    window.openDialog("chrome://speeddial/content/settings/settings.xul", "", features);
  },
  
  trim: function(str) {
    var	str = str.replace(/^\s\s*/, ''),
      ws = /\s/,
      i = str.length;
    while (ws.test(str.charAt(--i)));
    return str.slice(0, i + 1);
  },
  
  extendInt: function (aInput) {
    if (aInput < 10) return "0" + aInput.toString();
    else return aInput;
  },
  
  exportSettings: function(onlyDials) {
    var speedDialPrefBranch = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("extensions.speeddial.");
    var now = new Date();
    var sDate = SpeedDialUtils.extendInt(now.getMonth() + 1) + "/" + SpeedDialUtils.extendInt(now.getDate()) + "/" + now.getFullYear();
    var sTtime = SpeedDialUtils.extendInt(now.getHours()) + ":" + SpeedDialUtils.extendInt(now.getMinutes()) + ":" + SpeedDialUtils.extendInt(now.getSeconds());
    var sGMT = now.toGMTString();
  
    var speeddialExport = new Array;
    speeddialExport[0] = "-----------------------------------------------------------------------\n";
    speeddialExport[0] += "                       Speed Dial - ";
    if (onlyDials) {
      speeddialExport[0] += "Dials";
    } else {
      speeddialExport[0] += "Settings";
    }
    speeddialExport[0] += "\n";
    speeddialExport[0] += "          " + sDate + ", " + sTtime + " (" + sGMT + ")\n";
    speeddialExport[0] += "-----------------------------------------------------------------------\n";
    speeddialExport[0] += "                         DO NOT EDIT THIS FILE\n";
    speeddialExport[0] += "-----------------------------------------------------------------------";
  
    var count = { value : 0 };
    var childList = speedDialPrefBranch.getChildList("", count);
    var currentIndex = 1;
    for(var i = 0; i < count.value; i++) {
      try {
        if (!onlyDials 
          || (childList[i].match("^thumbnail-"))
          || (childList[i].match("^group-"))
          || (childList[i] == "numGroups")
        ) {
          if (childList[i].match("-lastsaved$") == null) {
            switch(speedDialPrefBranch.getPrefType(childList[i])) {
              case Components.interfaces.nsIPrefBranch.PREF_BOOL:
                speeddialExport[currentIndex] = childList[i] + '=' + speedDialPrefBranch.getBoolPref(childList[i]);
                break;
  
              case Components.interfaces.nsIPrefBranch.PREF_INT:
                speeddialExport[currentIndex] = childList[i] + '=' + speedDialPrefBranch.getIntPref(childList[i]);
                break;
  
              case Components.interfaces.nsIPrefBranch.PREF_STRING:
                if ((childList[i].match("^thumbnail.*-label$")) ||
                   (childList[i].match("^thumbnail.*-title$")) ||
                   (childList[i].match("^group.*-title$"))) {
                  var targetText = speedDialPrefBranch.getComplexValue(childList[i], Components.interfaces.nsISupportsString).data;
                  speeddialExport[currentIndex] = childList[i] + '=' + encodeURI(targetText);
                } else if (childList[i].match("^group.*-style$")) {
                  speeddialExport[currentIndex] = childList[i] + '=' + encodeURI(speedDialPrefBranch.getCharPref(childList[i]));
                } else {
                  speeddialExport[currentIndex] = childList[i] + '=' + speedDialPrefBranch.getCharPref(childList[i]);
                }
                break;
            }
            currentIndex++;
          }
        }
      } catch(e) { }
    }
  
    speeddialExport.sort();
    return speeddialExport;
  },
  
  automaticBackup: function() {
    try {
      // Save backup for today
      var numBackups = SpeedDialUtils.prefs.getIntPref("numBackups");
      var datatosave = SpeedDialUtils.exportSettings(true);
      var backupFolder = Components.classes["@mozilla.org/file/directory_service;1"]
                       .getService(Components.interfaces.nsIProperties)
                       .get("ProfD", Components.interfaces.nsIFile);
      if (numBackups == 0) {
        return;
      }
      var now = new Date();
      var currentYear=now.getFullYear();
      var currentMonth=now.getMonth()+1;
      var currentDay=now.getDate();
      var fileName = '' + currentYear;
      if (currentMonth < 10) {
        fileName += '0';
      }
      fileName += currentMonth;
      if (currentDay < 10) {
        fileName += '0';
      }
      fileName += currentDay;
      fileName += ".speeddial";
      
      backupFolder.append(SpeedDialUtils.backupFolder);
      if( !backupFolder.exists() || !backupFolder.isDirectory() ) {   // if it doesn't exist, create
        backupFolder.create(Components.interfaces.nsIFile.DIRECTORY_TYPE, 0755);
      }
      if (numBackups > 0) {
        var backupNameMatch = "\\d+\\.speeddial";
        var enumerator = backupFolder.directoryEntries;
        var fileArray = new Array();
        numBackups--;
        
        while (enumerator.hasMoreElements()) {
          var targetFile = enumerator.getNext().QueryInterface(Components.interfaces.nsIFile);
          if ((targetFile.isFile()) && (targetFile.leafName.match(backupNameMatch))) {
            fileArray.push(new SpeedDialUtils.FileRef(targetFile.leafName, targetFile));
            if (targetFile.leafName == fileName) {
              numBackups++;
            }
          }
        }
        if (fileArray.length >= numBackups) {
          fileArray.sort();
          for (var c=0;c<(fileArray.length-numBackups);c++) {
            fileArray[c].path.remove(false);
          }
        }
      }

      var stream = Components.classes["@mozilla.org/network/file-output-stream;1"].createInstance(Components.interfaces.nsIFileOutputStream);
      var backupFile = backupFolder.clone();
      backupFile.append(fileName);
      if(backupFile.exists()) backupFile.remove(true);
      backupFile.create(backupFile.NORMAL_FILE_TYPE, 0666);
      stream.init(backupFile, 0x02, 0x200, null);
  
      for(var i = 0; i < datatosave.length; i++) {
        datatosave[i] = datatosave[i] + "\n";
        stream.write(datatosave[i], datatosave[i].length);
      }
  
      stream.close();
    } catch (e) { alert(e); }
  },
  
  launch: function(targetFile) {
    try {
      var obj = Components.classes["@mozilla.org/file/local;1"].
            createInstance(Components.interfaces.nsILocalFile);
      obj.initWithPath(targetFile);
      if (obj.isExecutable()) {
        var process = Components.classes["@mozilla.org/process/util;1"].createInstance(Components.interfaces.nsIProcess);
        process.init(obj);
        process.run(false, [], 0);
      } else {
        try {
          obj.launch();
        } catch (e) {
          var uri = Components.classes["@mozilla.org/network/io-service;1"].getService(Components.interfaces.nsIIOService).newFileURI(obj);
          var protocolSvc = Components.classes["@mozilla.org/uriloader/external-protocol-service;1"].getService(Components.interfaces..nsIExternalProtocolService);
          protocolSvc.loadUrl(uri);
        }
      }
    } catch (e) { alert(e); }
    
  },
  
  FileRef: function (leafName, path) {
    this.leafName = leafName;
    this.path = path;
  },
  
  log: function(msg) {
    var consoleService = Components.classes["@mozilla.org/consoleservice;1"]
                                   .getService(Components.interfaces.nsIConsoleService);
    consoleService.logStringMessage(msg);
  }  
}

SpeedDialUtils.FileRef.prototype =
{
  leafName: null,
  path: null,
  
  toString: function() {
    return this.leafName;
  }
}
