// Global vars
var gPref = Components.classes["@mozilla.org/preferences-service;1"]
               .getService(Components.interfaces.nsIPrefService)
               .QueryInterface(Components.interfaces.nsIPrefBranch2);
var targetDial = -1;
var retVals = null;
var WEATHERSIZE_SMALL = '0,0,160,40';
var WEATHERSIZE_MEDIUM = '0,0,240,60,150';
var WEATHERSIZE_LARGE = '0,0,320,80,200';

function Startup() {
  // Set variables
  targetDial = window.arguments[0];
  retVals = window.arguments[1];

  if (gPref.prefHasUserValue("extensions.speeddial.thumbnail-" + targetDial + "-url")) {
    var targetURL = gPref.getCharPref("extensions.speeddial.thumbnail-" + targetDial + "-url");
    if (SpeedDialUtils.stringStartsWith(targetURL, "weather:")) {
      var targetWeather = targetURL.substring("weather:".length);
      if (targetWeather.indexOf('#') > -1) {
        var array = targetWeather.split('#');
        targetWeather = array[0];
        if (array[1].toLowerCase().charAt(0) == 'f') {
          document.getElementById("degreesUnit").selectedIndex = 1;
        }
      }
      document.getElementById("targetLocation").value = targetWeather;
      if (gPref.prefHasUserValue("extensions.speeddial.thumbnail-" + targetDial + "-cropping")) {
        var targetCrop = gPref.getCharPref("extensions.speeddial.thumbnail-" + targetDial + "-cropping");
        if (targetCrop == WEATHERSIZE_MEDIUM) {
          document.getElementById("weatherSize").selectedIndex = 1;
        } else if (targetCrop == WEATHERSIZE_LARGE) {
          document.getElementById("weatherSize").selectedIndex = 2;
        }
      }
    }
  }
}

function onOK(event) {
  var targetLocation = document.getElementById("targetLocation").value;
  var degreesUnitSelectedIndex = document.getElementById("degreesUnit").selectedIndex;
  var weatherSizeSelectedIndex = document.getElementById("weatherSize").selectedIndex;
  
  if (degreesUnitSelectedIndex > 0) {
    targetLocation += "#F";
  }
  
  // Delete thumbnail
  SpeedDialUtils.deassignThumbnail(targetDial);
  
  gPref.setCharPref("extensions.speeddial.thumbnail-" + targetDial + "-url", "weather:" + targetLocation);
  gPref.setBoolPref("extensions.speeddial.thumbnail-" + targetDial + "-js", false);
  gPref.setBoolPref("extensions.speeddial.thumbnail-" + targetDial + "-dynamictitle", true);
  gPref.setIntPref("extensions.speeddial.thumbnail-" + targetDial + "-layout", 3);
  gPref.setIntPref("extensions.speeddial.thumbnail-" + targetDial + "-refreshinterval", 1800);

  var str = Components.classes["@mozilla.org/supports-string;1"].createInstance(Components.interfaces.nsISupportsString);
  str.data = "Weather Dial";
  gPref.setComplexValue("extensions.speeddial.thumbnail-" + targetDial + "-label", Components.interfaces.nsISupportsString, str);
  
  if (weatherSizeSelectedIndex == 1) {
    gPref.setCharPref("extensions.speeddial.thumbnail-" + targetDial + "-cropping", WEATHERSIZE_MEDIUM);
  } else if (weatherSizeSelectedIndex == 2) {
    gPref.setCharPref("extensions.speeddial.thumbnail-" + targetDial + "-cropping", WEATHERSIZE_LARGE);
  } else {
    gPref.setCharPref("extensions.speeddial.thumbnail-" + targetDial + "-cropping", WEATHERSIZE_SMALL);
  }
  
  if (SpeedDialUtils.isFirefox3()) {
    gPref.setCharPref("extensions.speeddial.thumbnail-" + targetDial + "-icon", "data:");
  }
  
  return true;
}

function onCancel(event) {
  if (retVals != null) {
    retVals.canceled = true;
  }
  return true;
}

function openFullEdit() {
  window.opener.openDialog("chrome://speeddial/content/editDial.xul", "",
             "centerscreen,chrome,dialog,resizable,dependent",
             targetDial);
  window.close();
}
