var SpeedDialUtils = {
  prefs: null,
  thumbFolder: "SDThumbs",
  cacheService: null,

  getPrefs: function() {
    if (SpeedDialUtils.prefs == null) {
      SpeedDialUtils.prefs = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranch2);
    }
    return SpeedDialUtils.prefs;
  },
  
  getCacheService: function() {
    if (SpeedDialUtils.cacheService == null) {
      SpeedDialUtils.cacheService = Components.classes["@uworks.net/speeddialcache;1"].getService().wrappedJSObject;
    }
    return SpeedDialUtils.cacheService;
  },
  
  removeThumbnailImage: function(thumbNumber) {
    var prefs = SpeedDialUtils.getPrefs();
    var file = Components.classes["@mozilla.org/file/directory_service;1"]
                       .getService(Components.interfaces.nsIProperties)
                       .get("ProfD", Components.interfaces.nsIFile);
    file.append(SpeedDialUtils.thumbFolder);
    var fileExtension = "png";
    if (prefs.prefHasUserValue("extensions.speeddial.thumbnail-" + thumbNumber + "-format")) {
     fileExtension = prefs.getCharPref("extensions.speeddial.thumbnail-" + thumbNumber + "-format");
    }
    if (prefs.prefHasUserValue("extensions.speeddial.thumbnail-" + thumbNumber + "-lastsaved")) {
      file.append("thumbnail-" + thumbNumber + "-" + prefs.getCharPref("extensions.speeddial.thumbnail-" + thumbNumber + "-lastsaved") + "." + fileExtension);
    } else {
      file.append("thumbnail-" + thumbNumber + "." + fileExtension);
    }
    if (file.exists() && !file.isDirectory()) {
      try {
        file.remove(false);
      } catch(e) {
        // Do nothing...
        // TODO: retry later?
      }
    }
  },

  deassignThumbnail: function(thumbNumber) {
    var prefs = SpeedDialUtils.getPrefs();
    
    // Take out from cache
    SpeedDialUtils.getCacheService().setImage(null, thumbNumber);

    SpeedDialUtils.removeThumbnailImage(thumbNumber);

    if (prefs.prefHasUserValue("extensions.speeddial.thumbnail-" + thumbNumber + "-url")) {
      prefs.clearUserPref("extensions.speeddial.thumbnail-" + thumbNumber + "-url");
    }

    if (prefs.prefHasUserValue("extensions.speeddial.thumbnail-" + thumbNumber + "-icon")) {
      prefs.clearUserPref("extensions.speeddial.thumbnail-" + thumbNumber + "-icon");
    }

    if (prefs.prefHasUserValue("extensions.speeddial.thumbnail-" + thumbNumber + "-label")) {
      prefs.clearUserPref("extensions.speeddial.thumbnail-" + thumbNumber + "-label");
    }

    if (prefs.prefHasUserValue("extensions.speeddial.thumbnail-" + thumbNumber + "-lastsaved")) {
      prefs.clearUserPref("extensions.speeddial.thumbnail-" + thumbNumber + "-lastsaved");
    }

    if (prefs.prefHasUserValue("extensions.speeddial.thumbnail-" + thumbNumber + "-dynamictitle")) {
      prefs.clearUserPref("extensions.speeddial.thumbnail-" + thumbNumber + "-dynamictitle");
    }
  
    if (prefs.prefHasUserValue("extensions.speeddial.thumbnail-" + thumbNumber + "-refreshinterval")) {
      prefs.clearUserPref("extensions.speeddial.thumbnail-" + thumbNumber + "-refreshinterval");
    }
  
    if (prefs.prefHasUserValue("extensions.speeddial.thumbnail-" + thumbNumber + "-manualrefresh")) {
      prefs.clearUserPref("extensions.speeddial.thumbnail-" + thumbNumber + "-manualrefresh");
    }

    if (prefs.prefHasUserValue("extensions.speeddial.thumbnail-" + thumbNumber + "-format")) {
      prefs.clearUserPref("extensions.speeddial.thumbnail-" + thumbNumber + "-format");
    }

    if (prefs.prefHasUserValue("extensions.speeddial.thumbnail-" + thumbNumber + "-backgroundcolor")) {
      prefs.clearUserPref("extensions.speeddial.thumbnail-" + thumbNumber + "-backgroundcolor");
    }

    if (prefs.prefHasUserValue("extensions.speeddial.thumbnail-" + thumbNumber + "-layout")) {
      prefs.clearUserPref("extensions.speeddial.thumbnail-" + thumbNumber + "-layout");
    }

    if (prefs.prefHasUserValue("extensions.speeddial.thumbnail-" + thumbNumber + "-cropping")) {
      prefs.clearUserPref("extensions.speeddial.thumbnail-" + thumbNumber + "-cropping");
    }

    if (prefs.prefHasUserValue("extensions.speeddial.thumbnail-" + thumbNumber + "-thumbnailurl")) {
      prefs.clearUserPref("extensions.speeddial.thumbnail-" + thumbNumber + "-thumbnailurl");
    }
  }
}