var SpeedDial = {
  speedDialRows: 3,
  speedDialColumns: 3,
  speedDialSlots: 9,
  prefs: null,
  bundle: null,
  THUMB_FOLDER: "SDThumbs",
  isFirefox3: false,
  // Configuration parameters
  loadInNewWindow: false,
  loadInNewTab: false,
  loadInLastTab: false,
  clearURLBarOnLoad: false,
  showInTabContextMenu: false,
  showInAreaContextMenu: false,
  showInBookmarksMenu: false,
  overrideCtrlNumber: false,
  isSchedulerWindow: false,
  updateSchedules: null,
  prioritySchedules: null,
  scheduleTimer: null,
  processingPrioritySchedules: false,
  currentPrioritySchedule: -1,
  defaultRefreshInterval: 0,
  captureDelay: 500,
  captureTimeout: 20000,
  disableBackgroundBrowserJavascript: false,
  disableBackgroundBrowserPlugins: true,
  disableBackgroundBrowserAuth: true,
  popupOptionsAccess: true,
  enableCache: true,
  imageFormat: "png",
  urlBarShortcuts: true,
  timeOutId: null,
  openExistingFirst: true,
  openOnBlankTab: true,
  useJava: false,
  preScaling: true,
  enableGroups: false,
  numGroups: 1,
  multikeyForSingleDigit: false,
  thumbnailGenerationListeners: [],
  multikeyOverlayWidthModifier: 60,
  currentMultikeyWindow: null,
  useKeyCapture: true,
  
  assignPopupShowing: function(event, showUnassigned) {
    var menu = event.target;

    if (menu.hasAttribute("group")) return true;
    
    if (!SpeedDial.enableGroups) {
      SpeedDial.createPopup(menu, 1, showUnassigned);
    } else {
      // Empty current
      while (menu.firstChild)
        menu.removeChild(menu.firstChild);
      
      for (var c=1; c<=SpeedDial.numGroups; c++) {
        var groupMenu =  document.createElement("menu");
        if (SpeedDial.prefs.prefHasUserValue("extensions.speeddial.group-" + c + "-title")) {
          groupMenu.setAttribute("label", SpeedDial.prefs.getComplexValue("extensions.speeddial.group-" + c + "-title", Components.interfaces.nsISupportsString).data);
        } else {
          groupMenu.setAttribute("label",  SpeedDial.bundle.getFormattedString("untitledGroup.label", [c]));
        }
        groupMenu.setAttribute("class", "menu-iconic bookmark-item");
        groupMenu.setAttribute("container", "true");
        var groupPopup = document.createElement("menupopup");
        groupPopup.setAttribute("onpopupshowing", "SpeedDial.assignGroupPopupShowing(event, " + showUnassigned + ");");
        groupPopup.setAttribute("group", c);
        groupMenu.appendChild(groupPopup);
        menu.appendChild(groupMenu);
      }
      if (SpeedDial.popupOptionsAccess) {
        var menuSeparator = document.createElement("menuseparator");
        menu.appendChild(menuSeparator);
        var optionsMenuItem = document.createElement("menuitem");
        optionsMenuItem.setAttribute("label", SpeedDial.bundle.getString("options.label"));
        menu.appendChild(optionsMenuItem);
      }
    }
    return true;
  },
  
  assignGroupPopupShowing: function(event, showUnassigned) {
    var menu = event.target;

    if (!menu.hasAttribute("group")) return true;

    var targetGroup = parseInt(menu.getAttribute("group"));
    SpeedDial.createPopup(menu, targetGroup, showUnassigned);
    return true;
  },
  
  createPopup: function(menu, targetGroup, showUnassigned) {
    // Empty current
    while (menu.firstChild)
      menu.removeChild(menu.firstChild);

    var initialDial = (targetGroup - 1) * SpeedDial.speedDialRows * SpeedDial.speedDialColumns;
    // Create new
    for (var c=1; c<=(SpeedDial.speedDialRows*SpeedDial.speedDialColumns); c++) {
      var targetDial = initialDial + c;
      if (showUnassigned || SpeedDial.prefs.prefHasUserValue("extensions.speeddial.thumbnail-" + targetDial + "-url")) {
        var menuitem = document.createElement("menuitem");
        if (SpeedDial.prefs.prefHasUserValue("extensions.speeddial.thumbnail-" + targetDial + "-url")) {
          var thumbnailTitle = SpeedDial.prefs.getComplexValue("extensions.speeddial.thumbnail-" + targetDial + "-label", Components.interfaces.nsISupportsString).data;
          var thumbnailURL =  SpeedDial.prefs.getCharPref("extensions.speeddial.thumbnail-" + targetDial + "-url");
          var thumbnailIcon =  SpeedDial.prefs.getCharPref("extensions.speeddial.thumbnail-" + targetDial + "-icon");
          if (thumbnailTitle == "") {
            menuitem.setAttribute("label", "" + targetDial + " - " + SpeedDial.bundle.getString("untitled.label"));
          } else {
            menuitem.setAttribute("label", "" + targetDial + " - " + thumbnailTitle);
          }
          menuitem.setAttribute("tooltiptext", thumbnailURL);
          if (thumbnailIcon == "data:") {
            menuitem.setAttribute("image", "");
          } else {
            menuitem.setAttribute("image", thumbnailIcon);
          }
        } else {
          menuitem.setAttribute("label", "" + targetDial + " - " + SpeedDial.bundle.getString("unassigned.label"));
        }
        if (targetDial < 10) {
          menuitem.setAttribute("accesskey", targetDial);
        } else if (targetDial == 10) {
          menuitem.setAttribute("accesskey", 0);
        }
        menuitem.setAttribute("speeddial", targetDial);
        menuitem.setAttribute("class", "menuitem-iconic bookmark-item");
        menu.appendChild(menuitem);
      }
    }
    if (SpeedDial.popupOptionsAccess && !SpeedDial.enableGroups) {
      var menuSeparator = document.createElement("menuseparator");
      menu.appendChild(menuSeparator);
      var optionsMenuItem = document.createElement("menuitem");
      optionsMenuItem.setAttribute("label", SpeedDial.bundle.getString("options.label"));
      menu.appendChild(optionsMenuItem);
    }
  },

  setAsSpeedDial: function(event, targetTab) {
    var speedDial = event.target.getAttribute("speeddial");
    if (!speedDial) {
      if (SpeedDial.popupOptionsAccess) {
        // Must be options
        SpeedDial.showOptions();
      }
      return false;
    }
    
    var browser;

    if (targetTab) {
      browser = targetTab.linkedBrowser;
    } else {
      browser = getBrowser().mCurrentBrowser;
    }

    if (SpeedDial.prefs.prefHasUserValue("extensions.speeddial.thumbnail-" + speedDial + "-url")) {
      if (!confirm(SpeedDial.bundle.getString("overwrite.warning"))) {
        return false;
      }
    }

    SpeedDial.prefs.setCharPref("extensions.speeddial.thumbnail-" + speedDial + "-icon", "");

    if (browser.mIconURL) {
      SpeedDial.loadIcon(browser.mIconURL, speedDial);
    }
    
    SpeedDial.prefs.setCharPref("extensions.speeddial.thumbnail-" + speedDial + "-url", browser.contentDocument.location);

    var str = Components.classes["@mozilla.org/supports-string;1"].createInstance(Components.interfaces.nsISupportsString);
    str.data = browser.contentDocument.title;
    SpeedDial.prefs.setComplexValue("extensions.speeddial.thumbnail-" + speedDial + "-label", Components.interfaces.nsISupportsString, str);

    SpeedDial.prefs.setBoolPref("extensions.speeddial.thumbnail-" + speedDial + "-dynamictitle", false);
    
    if (SpeedDial.defaultRefreshInterval > 0) {
      SpeedDial.prefs.setIntPref("extensions.speeddial.thumbnail-" + speedDial + "-refreshinterval", SpeedDial.defaultRefreshInterval);
    }
    // Take screenshot
    SpeedDial.saveSnapshot(browser, speedDial);

    return true;
  },

  showWelcomeScreenIfNeeded: function() {
    var currentVersion = SpeedDial.prefs.getCharPref("extensions.speeddial.currentVersion");

    if (currentVersion == "none") {
      // Detect screen resolution
      if (screen.width > 1600) {
        SpeedDial.prefs.setIntPref("extensions.speeddial.thumbnailImageWidth", 800);
        SpeedDial.prefs.setIntPref("extensions.speeddial.thumbnailImageHeight", 800);
        SpeedDial.prefs.setIntPref("extensions.speeddial.maximumWidth", 2400);
      } else if (screen.width > 1280) {
        SpeedDial.prefs.setIntPref("extensions.speeddial.thumbnailImageWidth", 600);
        SpeedDial.prefs.setIntPref("extensions.speeddial.thumbnailImageHeight", 600);
        SpeedDial.prefs.setIntPref("extensions.speeddial.maximumWidth", 1800);
      } else {
        SpeedDial.prefs.setIntPref("extensions.speeddial.thumbnailImageWidth", 400);
        SpeedDial.prefs.setIntPref("extensions.speeddial.thumbnailImageHeight", 400);
        SpeedDial.prefs.setIntPref("extensions.speeddial.maximumWidth", 1200);
      }
      if ((screen.width / screen.height) > 1.4) {
        SpeedDial.prefs.setIntPref("extensions.speeddial.widthModifier", 80);
      }
    }
    
    if (currentVersion != "/*#echo version*/") {
      SpeedDial.prefs.setCharPref("extensions.speeddial.currentVersion", "/*#echo version*/");

      // Show first time configuration dialog
      if (currentVersion == "none") {
        openDialog("chrome://speeddial/content/firstTimeConfig.xul", "",
                   "centerscreen,chrome,dialog,resizable,modal");
      }

      if (SpeedDial.prefs.getBoolPref("extensions.speeddial.firstRunRedirection")) {
        var targetURL;
        if (currentVersion == "none") {
          targetURL = "http://speeddial.uworks.net/welcome.html";
        } else {
          targetURL = "http://speeddial.uworks.net/updated.html";
        }
        var newTab = getBrowser().addTab(targetURL);
        getBrowser().selectedTab = newTab;
      }
    }
  },

  addToolbarIcon: function() {
    var toolbarId = "nav-bar";
    var buttonId = "btn_speeddial";
    var toolbar = document.getElementById(toolbarId);
    var toolbarButton = document.getElementById(buttonId);
    if (toolbar && !toolbarButton)
    {
      var newSet = toolbar.currentSet + "," + buttonId;
      toolbar.setAttribute("currentset", newSet);
      toolbar.currentSet = newSet;
      document.persist(toolbarId, "currentset");
  
      try {
        BrowserToolboxCustomizeDone(true);
      } catch (e) {}
    }
  },

  loadIcon: function(url, entry) {
    if (url.indexOf("data:") == 0) {
      SpeedDial.setSpeedDialIcon(url, entry);
      return;
    }
    var IOSVC = Components.classes["@mozilla.org/network/io-service;1"].getService(Components.interfaces.nsIIOService);
    var chan = IOSVC.newChannel(url, null, null);
    var listener = new SpeedDial.SpeedDialIconLoadListener(chan, entry);
    chan.notificationCallbacks = listener;
    chan.asyncOpen(listener, null);
  },

  openDialCheckMiddleClick: function(node, event) {
    if (event.button == 1) {
      var func = new Function("event",node.getAttribute("oncommand"));
      func.call(node,event);
      if ("tagName" in node) {
        if (node.namespaceURI == "http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul" && (node.tagName == "menupopup" || node.tagName == "popup"))
          node.hidePopup();
      }
    }
  },

  openDial: function(event) {
    var targetSpeedDial = event.target.getAttribute("speeddial");

    if (!targetSpeedDial) {
      if (SpeedDial.popupOptionsAccess) {
        // Must be options
        SpeedDial.showOptions();
      }
      return false;
    }

    if (!SpeedDial.prefs.prefHasUserValue("extensions.speeddial.thumbnail-" + targetSpeedDial + "-url"))
      return false;

    var thumbnailURL =  SpeedDial.prefs.getCharPref("extensions.speeddial.thumbnail-" + targetSpeedDial + "-url");
    var where = whereToOpenLink(event);
    openUILinkIn(thumbnailURL, where);
    
    return true;
  },

  setSpeedDialIcon: function(data, speedDial) {
    SpeedDial.prefs.setCharPref("extensions.speeddial.thumbnail-" + speedDial + "-icon", data);
  },

  saveSnapshot: function(browser, speedDial) {
    var isImage = false;
    var croppingValues = null;
    var imageDecoder;
    
    // Verify folder
    SpeedDial.verifySpeedDialThumbFolder();
    
    // Detect special types
    if (browser.contentDocument instanceof ImageDocument) {
      // Capture image
      isImage = true;
      imageDecoder = browser.contentDocument.imageRequest.decoderObserver;
    }
    
    if ((speedDial > 0) && SpeedDial.prefs.prefHasUserValue("extensions.speeddial.thumbnail-" + speedDial + "-cropping")) {
      croppingValues = SpeedDial.prefs.getCharPref("extensions.speeddial.thumbnail-" + speedDial + "-cropping").split(",");
    }

    var thumbnailWidth, thumbnailHeight;

    if (croppingValues != null) {
      thumbnailWidth = croppingValues[2];
      thumbnailHeight = croppingValues[3];
    } else if (isImage) {
      if (imageDecoder.naturalWidth) {
        thumbnailWidth = imageDecoder.naturalWidth;
      } else {
        thumbnailWidth = imageDecoder.width;
      }
      if (imageDecoder.naturalHeight) {
        thumbnailHeight = imageDecoder.naturalHeight;
      } else {
        thumbnailHeight = imageDecoder.height;
      }
    } else if (speedDial == 0) {
      thumbnailWidth = browser.contentWindow.innerWidth;
      thumbnailHeight = browser.contentWindow.innerHeight;
    } else {
      thumbnailWidth= SpeedDial.prefs.getIntPref("extensions.speeddial.thumbnailImageWidth");
      thumbnailHeight = SpeedDial.prefs.getIntPref("extensions.speeddial.thumbnailImageHeight");
    }
    var currentCanvas;
    
    if (speedDial > 0) {
      currentCanvas = document.createElementNS("http://www.w3.org/1999/xhtml", "canvas");
    } else {
      currentCanvas = SpeedDial.thumbnailGenerationListeners[0].getTargetCanvas();
    }

    var ctx = currentCanvas.getContext("2d");
  
    if (isImage) {
      currentCanvas.width = thumbnailWidth;
      currentCanvas.height = thumbnailHeight;

      if (croppingValues != null) {
        ctx.drawImage(imageDecoder, 
          croppingValues[0], croppingValues[1], croppingValues[2], croppingValues[3], 
          0, 0, thumbnailWidth, thumbnailHeight);
      } else {
        ctx.drawImage(imageDecoder, 0, 0, thumbnailWidth, thumbnailHeight);
      }
    } else {
      if (croppingValues != null) {
          currentCanvas.width = thumbnailWidth;
          currentCanvas.height = thumbnailHeight;
          ctx.drawWindow(browser.contentWindow, 
              croppingValues[0], 
              croppingValues[1], 
              croppingValues[2], 
              croppingValues[3], 
              "rgb(255,255,255)");
      } else {
        var scaleThumbnail = ((SpeedDial.isFirefox3 && !SpeedDial.preScaling) || (!SpeedDial.isFirefox3 && (!SpeedDial.useJava || !window.navigator.javaEnabled())));
    
        if (!scaleThumbnail && (speedDial > 0)) {
          currentCanvas.width = browser.contentWindow.innerWidth;
          currentCanvas.height = Math.floor((browser.contentWindow.innerWidth / SpeedDial.prefs.getIntPref("extensions.speeddial.thumbnailImageWidth")) * SpeedDial.prefs.getIntPref("extensions.speeddial.thumbnailImageHeight"));
        } else {
          currentCanvas.width = thumbnailWidth;
          currentCanvas.height = thumbnailHeight;
        }
        
        if (scaleThumbnail && (speedDial > 0)) {
          ctx.save();
          ctx.scale(currentCanvas.width/browser.contentWindow.innerWidth, currentCanvas.width/browser.contentWindow.innerWidth);
        }
        
        // bug 313178: when painting thumbnails without scroll, there's an important bug
        if (browser.contentWindow.scrollY != 0) {
          ctx.drawWindow(browser.contentWindow, 
              0, 
              0, 
              browser.contentWindow.innerWidth, 
              browser.contentWindow.innerHeight + browser.contentWindow.scrollMaxY, 
              "rgb(255,255,255)");
        } else {
          ctx.drawWindow(browser.contentWindow, 
              0, 
              0, 
              browser.contentWindow.innerWidth, 
              currentCanvas.height * browser.contentWindow.innerWidth / currentCanvas.width, 
              "rgb(255,255,255)");
        }
      
        if (speedDial > 0) {
          if (scaleThumbnail) {
            ctx.restore();
          } else if (SpeedDial.isFirefox3 && SpeedDial.preScaling && (croppingValues == null) && !isImage) {
            var finalCanvas = document.createElementNS("http://www.w3.org/1999/xhtml", "canvas");
            finalCanvas.width = thumbnailWidth;
            finalCanvas.height = thumbnailHeight;
            
            ctx = finalCanvas.getContext("2d");
            ctx.drawImage(currentCanvas, 0, 0, currentCanvas.width, currentCanvas.height, 0, 0, finalCanvas.width, finalCanvas.height);
            currentCanvas = finalCanvas;
          }
        }
      }
    }

    if (speedDial > 0) {
      var saveTime = (new Date()).getTime();
  
      var file = Components.classes["@mozilla.org/file/directory_service;1"]
                       .getService(Components.interfaces.nsIProperties)
                       .get("ProfD", Components.interfaces.nsIFile);
      file.append(SpeedDialUtils.thumbFolder);
  
      // If there's a previous one, delete it
      SpeedDialUtils.removeThumbnailImage(speedDial);
  
      file.append("thumbnail-" + speedDial + "-" + saveTime + "." + SpeedDial.imageFormat);
  
      SpeedDial.saveCanvas(currentCanvas, file, speedDial, thumbnailWidth, thumbnailHeight);
  
      // Store URL in cache...
      var URLSpec = Components.classes['@mozilla.org/network/protocol;1?name=file'] .createInstance(Components.interfaces.nsIFileProtocolHandler).getURLSpecFromFile(file);
  
      if (SpeedDial.enableCache) {
        window.setTimeout(SpeedDial.updateCacheEntry, 0, speedDial, URLSpec);
      }
  
      // Save preference, we've updated the thumbnail
      SpeedDial.prefs.setCharPref("extensions.speeddial.thumbnail-" + speedDial + "-format", SpeedDial.imageFormat);
      SpeedDial.prefs.setCharPref("extensions.speeddial.thumbnail-" + speedDial + "-lastsaved", saveTime);
    } else {
      // Set style sizes
      currentCanvas.style.width = currentCanvas.width + "px";
      currentCanvas.style.height = currentCanvas.height + "px";
      currentCanvas.style.minWidth = currentCanvas.width + "px";
      currentCanvas.style.minHeight = currentCanvas.height + "px";
      currentCanvas.style.maxWidth = currentCanvas.width + "px";
      currentCanvas.style.maxHeight = currentCanvas.height + "px";
    }
  },
  
  updateCacheEntry: function(targetDial, imageURL) {
    var cacheService = Components.classes["@uworks.net/speeddialcache;1"].getService();

    if (cacheService.wrappedJSObject.hasImage(targetDial)) {
      var cachedImage = cacheService.wrappedJSObject.getImage(targetDial);
      cachedImage.imageLoaded = false;
      cachedImage.src = imageURL;
    } else {
      cacheService.wrappedJSObject.setImage(imageURL, targetDial);
    }
  },

  addSpeedDialTabContextMenu: function() {
    // get strings 
    var menuLabel = SpeedDial.bundle.getString("speeddialCmd.label");
    var menuAccessKey = SpeedDial.bundle.getString("speeddialCmd.accesskey");

    // create new menu item
    var speedDialTabItem = document.createElement("menu");
    speedDialTabItem.setAttribute("id", "tabContextSpeedDial");
    speedDialTabItem.setAttribute("label", menuLabel);
    speedDialTabItem.setAttribute("accesskey", menuAccessKey);
    var speedDialTabMenu = document.createElement("menupopup");
    speedDialTabMenu.setAttribute("onpopupshowing", "return SpeedDial.assignPopupShowing(event, true);");
    speedDialTabMenu.setAttribute("oncommand", "SpeedDial.setAsSpeedDial(event,document.popupNode);");
    speedDialTabItem.appendChild(speedDialTabMenu);

    // add to tab context menu
    var tabbrowser = getBrowser();
    var tabMenu = document.getAnonymousElementByAttribute(tabbrowser,"anonid","tabContextMenu");

    var insertPos = document.getElementById("tabContextUndoCloseTab");

    if (!insertPos) {
      insertPos = tabMenu.lastChild.previousSibling;
    }
    tabMenu.insertBefore(speedDialTabItem, insertPos);

    speedDialTabItem.hidden = !SpeedDial.showInTabContextMenu;
  },

  verifySpeedDialThumbFolder: function() {
    var file = Components.classes["@mozilla.org/file/directory_service;1"]
                     .getService(Components.interfaces.nsIProperties)
                     .get("ProfD", Components.interfaces.nsIFile);
    file.append(SpeedDialUtils.thumbFolder);
    if( !file.exists() || !file.isDirectory() ) {   // if it doesn't exist, create
      file.create(Components.interfaces.nsIFile.DIRECTORY_TYPE, 0755);
    }
  },

  saveCanvas: function(canvas, destFile, targetDial, targetWidth, targetHeight) {
    var useJava = !SpeedDial.isFirefox3 && SpeedDial.useJava && window.navigator.javaEnabled();
    if (useJava) {
      var imageData = canvas.toDataURL("image/png").substring("data:image/png;base64,".length);
      var imageBytes = new sun.misc.BASE64Decoder().decodeBuffer(imageData);
      var bais = new java.io.ByteArrayInputStream(imageBytes);
      var javaImage = Packages.javax.imageio.ImageIO.read(bais);

      var finalImage;
      var w = canvas.width;
      var h = canvas.height;
      do {
        if (w > targetWidth) {
          w /= 2;
          if (w < targetWidth) {
            w = targetWidth;
          }
        }

        if (h > targetHeight) {
          h /= 2;
          if (h < targetHeight) {
            h = targetHeight;
          }
        }
        finalImage = new java.awt.image.BufferedImage(w, h, java.awt.image.BufferedImage.TYPE_INT_RGB);
        var g2 = finalImage.createGraphics();
        g2.setRenderingHint(java.awt.RenderingHints.KEY_INTERPOLATION, java.awt.RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2.drawImage(javaImage, 0, 0, w, h, null);
        g2.dispose();
        javaImage = finalImage;
      } while (w != targetWidth || h != targetHeight);
      
      Packages.javax.imageio.ImageIO.write(finalImage, SpeedDial.imageFormat, new java.io.File(destFile.path));
    } else {
      // convert string filepath to an nsIFile
      var file = Components.classes["@mozilla.org/file/local;1"]
                       .createInstance(Components.interfaces.nsILocalFile);

      // create a data url from the canvas and then create URIs of the source and targets  
      var io = Components.classes["@mozilla.org/network/io-service;1"]
                       .getService(Components.interfaces.nsIIOService);
      var mimeType;
      if (SpeedDial.imageFormat == "jpg") {
        mimeType = "image/jpeg";
      } else {
        mimeType = "image/png";
      }
      var dataURL = canvas.toDataURL(mimeType, "");

      var source = io.newURI(dataURL, "UTF8", null);
      var target = io.newFileURI(destFile)
  
      // prepare to save the canvas data
      var persist = Components.classes["@mozilla.org/embedding/browser/nsWebBrowserPersist;1"]
                          .createInstance(Components.interfaces.nsIWebBrowserPersist);
  
      persist.persistFlags = Components.interfaces.nsIWebBrowserPersist.PERSIST_FLAGS_REPLACE_EXISTING_FILES;
      persist.persistFlags |= Components.interfaces.nsIWebBrowserPersist.PERSIST_FLAGS_AUTODETECT_APPLY_CONVERSION;
  
      // displays a download dialog (remove these 3 lines for silent download)
/*
      var xfer = Components.classes["@mozilla.org/transfer;1"]
                       .createInstance(Components.interfaces.nsITransfer);
      xfer.init(source, target, "", null, null, null, persist);
      persist.progressListener = xfer;
*/
  
      // save the canvas data to the file
      persist.saveURI(source, null, null, null, null, destFile);
    }
  },

  contentAreaAttrListener: function(event) {
    if (!SpeedDial.showInAreaContextMenu) {
      document.getElementById("speeddialContext").hidden = true;
      return;
    }

    if (event.attrName == "hidden") {
      if (event.attrChange != event.REMOVAL) {
        document.getElementById("speeddialContext").hidden = event.newValue;
      } else {
        document.getElementById("speeddialContext").hidden = false;
      }
    }
  },

  checkNewBrowser: function(attempts) {
    var domWindow = getBrowser().mCurrentBrowser.docShell
                            .QueryInterface(Components.interfaces.nsIInterfaceRequestor)
                            .getInterface(Components.interfaces.nsIDOMWindow);
    var webNav = domWindow.QueryInterface(Components.interfaces.nsIInterfaceRequestor)
                            .getInterface(Components.interfaces.nsIWebNavigation);

    if (!webNav.currentURI && attempts) {
      window.setTimeout(SpeedDial.checkNewBrowser, 100, --attempts);
      return;
    }

    if (gIsLoadingBlank && (getBrowser().mTabs.length < 2) && (webNav.currentURI.spec == "about:blank") && !webNav.canGoBack && !webNav.canGoForward && !getBrowser().mCurrentTab.hasAttribute("busy")) {
      webNav.loadURI("chrome://speeddial/content/speeddial.xul", null, null, null, null);
      getBrowser().mCurrentBrowser.userTypedValue = undefined;
      
      if (gURLBar)
        setTimeout(function() { gURLBar.focus(); }, 0);
    }
  },

  ctrlNumberSpeedDial: function (event) {
    if (event.altKey && event.keyCode == KeyEvent.DOM_VK_RETURN) {
      // XXXblake Proper fix is to just check whether focus is in the urlbar. However, focus with the autocomplete widget is all
      // hacky and broken and there's no way to do that right now. So this just patches it to ensure that alt+enter works when focus
      // is on a link.
      if (!(document.commandDispatcher.focusedElement instanceof HTMLAnchorElement)) {
        // Don't let winxp beep on ALT+ENTER, since the URL bar uses it.
        event.preventDefault();
        return;
      }
    }
/*
    if (!event.ctrlKey)
      return;

    var index = event.charCode - 48;

    if (index < 1 || index > 9)
    return;

    if (!SpeedDial.prefs.prefHasUserValue("extensions.speeddial.thumbnail-" + index + "-url"))
      return;

    var thumbnailURL =  SpeedDial.prefs.getCharPref("extensions.speeddial.thumbnail-" + index + "-url");
    if (thumbnailURL) {
      if (event.shiftKey) {
        openUILinkIn(thumbnailURL, "tab");
      } else {
        openUILinkIn(thumbnailURL, "current");
      }
    } else {
      return;
    }

    event.preventDefault();
    event.preventBubble();
    event.preventCapture();
    event.stopPropagation();
    */
  },
  
  BrowserLoadURL: function(aTriggeringEvent, aPostDataRef) {
    if (!gURLBar) return;
    
    var url;
    
    if (window.gIeTab) {
      url = gIeTab.getHandledURL(gURLBar.value, gURLBar.isModeIE);
    } else {
      url = gURLBar.value
    }

    if (url == ("" + parseInt(url))) {
      // Single number, check if it's a dial!
      if (SpeedDial.prefs.prefHasUserValue("extensions.speeddial.thumbnail-" + url + "-url")) {
        gURLBar.value = SpeedDial.prefs.getCharPref("extensions.speeddial.thumbnail-" + url + "-url");
      }
    }
    
    window.originalBrowserLoadURL(aTriggeringEvent, aPostDataRef);
  },
  
  multikeyDialSelected: function(number, targetAction) {
    if ((number < 1) || (number > SpeedDial.speedDialSlots)) {
      var statusTextFld = document.getElementById("statusbar-display");
      statusTextFld.label = SpeedDial.bundle.getString("outofrange.warning");
    } else if (SpeedDial.prefs.prefHasUserValue("extensions.speeddial.thumbnail-" + number + "-url")) {
      SpeedDial.performAction(number, targetAction, true)
    } else {
      var statusTextFld = document.getElementById("statusbar-display");
      statusTextFld.label = SpeedDial.bundle.getString("unassigned.warning");
    }
  },
  
  processKey: function(event, number) {
    if (MultiKey.showingMultiKey) {
      event.preventDefault();
      event.preventBubble();
      event.preventCapture();
      event.stopPropagation();
      return;
    }
    var targetAction = 0;
    var doMultiKey = false;
    
    if (event.ctrlKey) {
      if (event.shiftKey) {
        if ((event.altKey) || (event.metaKey)) {
          targetAction = SpeedDial.prefs.getIntPref("extensions.speeddial.ctrlAltShiftShortcutAction");
          doMultiKey = SpeedDial.prefs.getBoolPref("extensions.speeddial.ctrlAltShiftShortcutMultikey");
        } else {
          targetAction = SpeedDial.prefs.getIntPref("extensions.speeddial.ctrlShiftShortcutAction");
          doMultiKey = SpeedDial.prefs.getBoolPref("extensions.speeddial.ctrlShiftShortcutMultikey");
        }
      } else if (!event.altKey) {
        targetAction = SpeedDial.prefs.getIntPref("extensions.speeddial.ctrlShortcutAction");
        doMultiKey = SpeedDial.prefs.getBoolPref("extensions.speeddial.ctrlShortcutMultikey");
      }
    } else if ((event.altKey) || (event.metaKey)) {
      if (event.shiftKey) {
        targetAction = SpeedDial.prefs.getIntPref("extensions.speeddial.altShiftShortcutAction");
        doMultiKey = SpeedDial.prefs.getBoolPref("extensions.speeddial.altShiftShortcutMultikey");
      } else {
        targetAction = SpeedDial.prefs.getIntPref("extensions.speeddial.altShortcutAction");
        doMultiKey = SpeedDial.prefs.getBoolPref("extensions.speeddial.altShortcutMultikey");
      }
    }

    if (targetAction > 0) {
      if (doMultiKey && ((SpeedDial.speedDialSlots > 10) || SpeedDial.multikeyForSingleDigit) && (targetAction != 6)) {
        // "centerscreen,chrome,dialog",
        MultiKey.initialNumber = number;
        MultiKey.numberThumbnails = SpeedDial.speedDialSlots;
        MultiKey.ctrlPressed = event.ctrlKey;
        MultiKey.shiftPressed = event.shiftKey;
        MultiKey.altPressed = ((event.altKey) || (event.metaKey));
        MultiKey.targetAction = targetAction;
        MultiKey.show();
      } else {
        if (number == 0) {
          number = 10;
        }
        SpeedDial.performAction(number, targetAction, false);
      }
      // Absorb key
      event.preventDefault();
      event.preventBubble();
      event.preventCapture();
      event.stopPropagation();
    }
  },
  
  performAction: function(number, targetAction, fromMultikey) {
    if (!fromMultikey) {
      if (number == 0) number = 10;
    }
    
    // Perform action
    if ((targetAction >= 1) && (targetAction <= 5)) {
      if (!SpeedDial.prefs.prefHasUserValue("extensions.speeddial.thumbnail-" + number + "-url"))
        return;

      var thumbnailURL =  SpeedDial.prefs.getCharPref("extensions.speeddial.thumbnail-" + number + "-url");
      if (thumbnailURL) {
        if (targetAction == 1) {
          // Open in current tab
          openUILinkIn(thumbnailURL, "current");
        } else if (targetAction == 2) {
          // Open in tab
          openUILinkIn(thumbnailURL, "tabshifted");
        } else if (targetAction == 3) {
          // Open in background tab
          openUILinkIn(thumbnailURL, "tab");
        } else if (targetAction == 4) {
          // Open in new window
          openUILinkIn(thumbnailURL, "window");
        } else if (targetAction == 5) {
          // Open Save
          openUILinkIn(thumbnailURL, "save");
        }
      } else {
        return;
      }
    } else if (targetAction == 6) {
      // Select tab

      // [Ctrl]+[9] always selects the last tab
      if ((number == 9) && (!fromMultikey)) {
        number = getBrowser().tabContainer.childNodes.length;
      } else if (number > getBrowser().tabContainer.childNodes.length) {
        return;
      }

      var tabbrowser = getBrowser();
      var oldTab = tabbrowser.selectedTab;
      var newTab = tabbrowser.tabContainer.childNodes[number-1];
      if (newTab != oldTab) {
        oldTab.selected = false;
        tabbrowser.selectedTab = newTab;
      }
    }
  },

  browserOpenTab: function(event) {
    if (SpeedDial.loadInNewTab) {
      var newTab = gBrowser.loadOneTab("chrome://speeddial/content/speeddial.xul", null, null, null, false, false);
      newTab.linkedBrowser.userTypedValue = undefined;
      
      if (gURLBar)
        setTimeout(function() { gURLBar.focus(); }, 0);
    } else {
      window.originalBrowserOpenTab(event);
    }
  },
  
  init: function () {
    try {
    SpeedDial.prefs = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranch2);
    SpeedDial.bundle = document.getElementById("bundle_speeddial");

    // Load settings
    SpeedDial.loadInNewWindow = SpeedDial.prefs.getBoolPref("extensions.speeddial.loadInNewWindow");
    SpeedDial.loadInNewTab = SpeedDial.prefs.getBoolPref("extensions.speeddial.loadInNewTab");
    SpeedDial.loadInLastTab = SpeedDial.prefs.getBoolPref("extensions.speeddial.loadInLastTab");
    SpeedDial.clearURLBarOnLoad = SpeedDial.prefs.getBoolPref("extensions.speeddial.clearURLBarOnLoad");
    SpeedDial.showInTabContextMenu = SpeedDial.prefs.getBoolPref("extensions.speeddial.showInTabContextMenu");
    SpeedDial.showInAreaContextMenu = SpeedDial.prefs.getBoolPref("extensions.speeddial.showInAreaContextMenu");
    SpeedDial.showInBookmarksMenu = SpeedDial.prefs.getBoolPref("extensions.speeddial.showInBookmarksMenu");
    SpeedDial.overrideCtrlNumber = SpeedDial.prefs.getBoolPref("extensions.speeddial.overrideCtrlNumber");
    SpeedDial.defaultRefreshInterval = SpeedDial.prefs.getIntPref("extensions.speeddial.defaultRefreshInterval");
    SpeedDial.captureDelay = SpeedDial.prefs.getIntPref("extensions.speeddial.captureDelay");
    SpeedDial.captureTimeout = SpeedDial.prefs.getIntPref("extensions.speeddial.captureTimeout");
    SpeedDial.disableBackgroundBrowserJavascript = SpeedDial.prefs.getBoolPref("extensions.speeddial.disableBackgroundBrowserJavascript");
    SpeedDial.disableBackgroundBrowserPlugins = SpeedDial.prefs.getBoolPref("extensions.speeddial.disableBackgroundBrowserPlugins");
    SpeedDial.disableBackgroundBrowserAuth = SpeedDial.prefs.getBoolPref("extensions.speeddial.disableBackgroundBrowserAuth");
    SpeedDial.speedDialColumns = SpeedDial.prefs.getIntPref("extensions.speeddial.columns");
    SpeedDial.speedDialRows = SpeedDial.prefs.getIntPref("extensions.speeddial.rows");
    SpeedDial.enableGroups = SpeedDial.prefs.getBoolPref("extensions.speeddial.enableGroups");
    if (SpeedDial.enableGroups) {
      SpeedDial.numGroups = SpeedDial.prefs.getIntPref("extensions.speeddial.numGroups");
    } else {
      SpeedDial.numGroups = 1;
    }
    SpeedDial.speedDialSlots = SpeedDial.speedDialColumns * SpeedDial.speedDialRows * SpeedDial.numGroups;
    SpeedDial.popupOptionsAccess = SpeedDial.prefs.getBoolPref("extensions.speeddial.popupOptionsAccess");
    SpeedDial.enableCache = SpeedDial.prefs.getBoolPref("extensions.speeddial.enableCache");
    SpeedDial.imageFormat = SpeedDial.prefs.getCharPref("extensions.speeddial.imageFormat");
    SpeedDial.urlBarShortcuts = SpeedDial.prefs.getBoolPref("extensions.speeddial.urlBarShortcuts");
    SpeedDial.openExistingFirst = SpeedDial.prefs.getBoolPref("extensions.speeddial.openExistingFirst");
    SpeedDial.openOnBlankTab = SpeedDial.prefs.getBoolPref("extensions.speeddial.openOnBlankTab");
    SpeedDial.useJava = SpeedDial.prefs.getBoolPref("extensions.speeddial.useJava");
    SpeedDial.preScaling = SpeedDial.prefs.getBoolPref("extensions.speeddial.preScaling");
    SpeedDial.multikeyForSingleDigit = SpeedDial.prefs.getBoolPref("extensions.speeddial.multikeyForSingleDigit");
    SpeedDial.multikeyOverlayWidthModifier = SpeedDial.prefs.getIntPref("extensions.speeddial.multikeyOverlayWidthModifier");
    SpeedDial.useKeyCapture = SpeedDial.prefs.getBoolPref("extensions.speeddial.useKeyCapture");
    
    // Detect version
    var appInfo = Components.classes["@mozilla.org/xre/app-info;1"].getService(Components.interfaces.nsIXULAppInfo)
    // only if this is Firefox
    var versionChecker = Components.classes["@mozilla.org/xpcom/version-comparator;1"]
                        .getService(Components.interfaces.nsIVersionComparator);
    // only if the platform version is 1.9 or greater
    if (versionChecker.compare(appInfo.platformVersion, "1.9a1") >= 0) {
      SpeedDial.isFirefox3 = true;
    }

    // Register listeners
    var bookmarkContextItem = document.getElementById("context-bookmarkpage");
    bookmarkContextItem.addEventListener("DOMAttrModified", SpeedDial.contentAreaAttrListener, false);
//    document.addEventListener("SSTabRestoring", SpeedDial.tabRestoringListener, false);
    SpeedDialPrefObserver.addPrefObserver();

    // Register window observer
    var watcherService =
      Components.classes["@mozilla.org/embedcomp/window-watcher;1"]
        .getService(Components.interfaces.nsIWindowWatcher);
    watcherService.registerNotification(SpeedDialWindowObserver);
    
    addEventListener("keyup", function(event) { SpeedDial.keyUpHandler(event); }, true);
    addEventListener("keydown", function(event) { SpeedDial.keyDownHandler(event); }, true);

    // Check if this window is the scheduler
    SpeedDial.checkWindow();

    // Hide some things
    if (!SpeedDial.showInAreaContextMenu ) {
      document.getElementById("speeddialContext").hidden = true;
    }
    if (!SpeedDial.showInBookmarksMenu) {
      document.getElementById("speeddialBookmarksMenu").hidden = true;
    }

    // Add to tab context menu
    setTimeout(SpeedDial.addSpeedDialTabContextMenu, 100);

    // Substitute ctrl+number
    if (SpeedDial.overrideCtrlNumber) {
      window.originalCtrlNumberTabSelection = window.ctrlNumberTabSelection;
      window.ctrlNumberTabSelection = SpeedDial.ctrlNumberSpeedDial;
    }

    // Substitute BrowserLoadURL
    if (SpeedDial.urlBarShortcuts) {
      window.setTimeout(function() {
      window.originalBrowserLoadURL = window.BrowserLoadURL;
      window.BrowserLoadURL = SpeedDial.BrowserLoadURL;
      }, 0);
    }
    
    // Substitute last tab code
//    if (SpeedDial.loadInLastTab) {
     eval("getBrowser().removeTab ="+getBrowser().removeTab.toString().replace(
        'this.addTab\("about:blank"\);',
        'if \(SpeedDial.loadInLastTab\) { this.addTab\("chrome://speeddial/content/speeddial.xul"\)} else { this.addTab\("about:blank"\)}'
     ));
//    }

    // Catch new tab
    if (window.TBP_BrowserOpenTab) {
      getBrowser().removeEventListener("NewTab", window.TBP_BrowserOpenTab, true);
      window.originalBrowserOpenTab = window.TBP_BrowserOpenTab;
      window.TBP_BrowserOpenTab = SpeedDial.browserOpenTab;
      getBrowser().addEventListener("NewTab", window.TBP_BrowserOpenTab, true);
    } else {
      getBrowser().removeEventListener("NewTab", window.BrowserOpenTab, false);
      window.originalBrowserOpenTab = window.BrowserOpenTab;
      window.BrowserOpenTab = SpeedDial.browserOpenTab;
      getBrowser().addEventListener("NewTab", window.BrowserOpenTab, false);
    }

    if (SpeedDial.clearURLBarOnLoad) {
      var newLocationChange = nsBrowserStatusHandler.prototype.onLocationChange.toString();
      newLocationChange = newLocationChange.replace(/location == \"about:blank\"/g, "location == \"about:blank\" || (location.indexOf(\"chrome://speeddial/content\") == 0)");
      eval('nsBrowserStatusHandler.prototype.onLocationChange = ' + newLocationChange + ';');
      // Check current window...
      if (SpeedDial.loadInNewWindow)
        setTimeout(SpeedDial.checkNewBrowser, 100, 10);
    }
    
    // Check current window...
    if (SpeedDial.loadInNewWindow) {
      setTimeout(SpeedDial.checkNewBrowser, 100, 10);
    }
    } catch (e) {
      alert(e);
    }

    setTimeout(function() {SpeedDial.showWelcomeScreenIfNeeded() }, 400);
  },

  unload: function () {
    // Unregister listeners
    var bookmarkContextItem = document.getElementById("context-bookmarkpage");
    bookmarkContextItem.removeEventListener("DOMAttrModified", SpeedDial.contentAreaAttrListener, false);
//    document.removeEventListener("SSTabRestoring", SpeedDial.tabRestoringListener, false);
    SpeedDialPrefObserver.removePrefObserver();

    // Unregister window observer
    var watcherService =
      Components.classes["@mozilla.org/embedcomp/window-watcher;1"]
        .getService(Components.interfaces.nsIWindowWatcher);
    watcherService.unregisterNotification(SpeedDialWindowObserver);

    if (SpeedDial.isSchedulerWindow) {
      SpeedDial.stopScheduling();
    }
  },
  
  keyDownHandler: function(event) {
    if (MultiKey.showingMultiKey) {
      MultiKey.keyDownHandler(event);
    }
    
    if (SpeedDial.useKeyCapture || MultiKey.showingMultiKey) {
      if ((event.keyCode >= 48) && (event.keyCode <= 57)) {
        if (MultiKey.showingMultiKey) {
          MultiKey.processKey(event, (event.keyCode - 48));
        } else {
          SpeedDial.processKey(event, (event.keyCode - 48));
        }
      } else if ((event.keyCode >= 96) && (event.keyCode <= 105)) {
        if (MultiKey.showingMultiKey) {
          MultiKey.processKey(event, (event.keyCode - 96));
        } else {
          SpeedDial.processKey(event, (event.keyCode - 96));
        }
      }
    }
  },

  keyUpHandler: function(event) {
    if (MultiKey.showingMultiKey) {
      MultiKey.keyUpHandler(event);
    }
  },


  unregisterBackgroundLoader: function() {
    var loaderBrowser = document.getElementById("speedDialLoaderBrowser");
    if (loaderBrowser) {
      loaderBrowser.removeEventListener("pageshow", SpeedDialBackgroundBrowserListener, true);
      loaderBrowser.removeEventListener("load", SpeedDialBackgroundBrowserListener, true);
      loaderBrowser.removeEventListener("unload", SpeedDialBackgroundBrowserListener, true);
      loaderBrowser.removeEventListener("DOMSubtreeModified", SpeedDialBackgroundBrowserListener, true);
      loaderBrowser.removeEventListener("DOMLinkAdded", SpeedDialBackgroundBrowserListener, true);
    }
  },

  startBackgroundLoad: function() {
    var loaderBrowser = document.createElement("browser");

    loaderBrowser.setAttribute("type", "content");
    loaderBrowser.setAttribute("disablehistory", "true");
    loaderBrowser.setAttribute("flex", "1");
    loaderBrowser.setAttribute("id", "speedDialLoaderBrowser");

    var backgroundBrowserWidth = SpeedDial.prefs.getIntPref("extensions.speeddial.backgroundBrowserWidth");
    var backgroundBrowserHeight = SpeedDial.prefs.getIntPref("extensions.speeddial.backgroundBrowserHeight");

    var speedDialLoaderSubBox = document.getElementById("speedDialLoaderSubBox");
    if (speedDialLoaderSubBox.firstChild) {
      speedDialLoaderSubBox.firstChild.removeEventListener("pageshow", SpeedDialBackgroundBrowserListener, true);
      speedDialLoaderSubBox.firstChild.removeEventListener("load", SpeedDialBackgroundBrowserListener, true);
      speedDialLoaderSubBox.firstChild.removeEventListener("unload", SpeedDialBackgroundBrowserListener, true);
      speedDialLoaderSubBox.firstChild.removeEventListener("DOMSubtreeModified", SpeedDialBackgroundBrowserListener, true);
      speedDialLoaderSubBox.firstChild.removeEventListener("DOMLinkAdded", SpeedDialBackgroundBrowserListener, true);
      speedDialLoaderSubBox.replaceChild(loaderBrowser, speedDialLoaderSubBox.firstChild);
    } else {
      speedDialLoaderSubBox.appendChild(loaderBrowser);
    }

//    loaderBrowser.addProgressListener(SpeedDialBackgroundBrowserListener, Components.interfaces.nsIWebProgress.NOTIFY_ALL);
    loaderBrowser.addEventListener("pageshow", SpeedDialBackgroundBrowserListener, true);
    loaderBrowser.addEventListener("load", SpeedDialBackgroundBrowserListener, true);
    loaderBrowser.addEventListener("unload", SpeedDialBackgroundBrowserListener, true);
    loaderBrowser.addEventListener("DOMSubtreeModified", SpeedDialBackgroundBrowserListener, true);
    loaderBrowser.addEventListener("DOMLinkAdded", SpeedDialBackgroundBrowserListener, true);
    SpeedDialBackgroundBrowserListener.captureStarted();

    speedDialLoaderSubBox.setAttribute("width", backgroundBrowserWidth);
    speedDialLoaderSubBox.setAttribute("minwidth", backgroundBrowserWidth);
    speedDialLoaderSubBox.setAttribute("maxwidth", backgroundBrowserWidth);
    speedDialLoaderSubBox.setAttribute("height", backgroundBrowserHeight);
    speedDialLoaderSubBox.setAttribute("minheight", backgroundBrowserHeight);
    speedDialLoaderSubBox.setAttribute("maxheight", backgroundBrowserHeight);

    speedDialLoaderSubBox.style.width = backgroundBrowserWidth + "px !important";
    speedDialLoaderSubBox.style.maxWidth = speedDialLoaderSubBox.style.width;
    speedDialLoaderSubBox.style.minWidth = speedDialLoaderSubBox.style.width;
    speedDialLoaderSubBox.style.height = backgroundBrowserHeight + "px !important";
    speedDialLoaderSubBox.style.maxHeight = speedDialLoaderSubBox.style.height;
    speedDialLoaderSubBox.style.minHeight = speedDialLoaderSubBox.style.height;

    loaderBrowser.docShell.allowAuth = !SpeedDial.disableBackgroundBrowserAuth;
    loaderBrowser.docShell.allowJavascript = !SpeedDial.disableBackgroundBrowserJavascript;
    loaderBrowser.docShell.allowPlugins = !SpeedDial.disableBackgroundBrowserPlugins;
    loaderBrowser.mIconURL = null;
  
    SpeedDialBackgroundBrowserListener.alreadyLoaded = false;
    SpeedDialBackgroundBrowserListener.loadFinished = false;
    
    var targetURL;
    
    if (SpeedDial.currentPrioritySchedule > 0) {
      if (SpeedDial.prefs.prefHasUserValue("extensions.speeddial.thumbnail-" + SpeedDial.currentPrioritySchedule + "-thumbnailurl")) {
        targetURL = SpeedDial.prefs.getCharPref("extensions.speeddial.thumbnail-" + SpeedDial.currentPrioritySchedule + "-thumbnailurl");
      } else {
        targetURL = SpeedDial.prefs.getCharPref("extensions.speeddial.thumbnail-" + SpeedDial.currentPrioritySchedule + "-url");
      }
    } else {
      targetURL = SpeedDial.thumbnailGenerationListeners[0].getTargetURL();
    }
    loaderBrowser.setAttribute("src", targetURL);
  },

  backgroundIconLoaded: function(url) {
    if (SpeedDial.currentPrioritySchedule > 0) {
      var loaderBrowser = document.getElementById("speedDialLoaderBrowser");
      loaderBrowser.mIconURL = url;
      SpeedDial.loadIcon(url, SpeedDial.currentPrioritySchedule);
    }
  },

  openSpeedDial: function() {
    var tabbrowser = getBrowser();

    if (SpeedDial.openExistingFirst && ((!tabbrowser.selectedTab.linkedBrowser.currentURI) || (tabbrowser.selectedTab.linkedBrowser.currentURI.spec.indexOf("chrome://speeddial/content/") != 0))) {
      for (var i = 0; i < tabbrowser.mTabContainer.childNodes.length; i++) {
        var tab = tabbrowser.mTabContainer.childNodes[i];
        if (tab.linkedBrowser.currentURI && (tab.linkedBrowser.currentURI.spec.indexOf("chrome://speeddial/content/") == 0)) {
          tabbrowser.selectedTab = tab;
          return;
        }
      }
    }
    
    if (SpeedDial.openOnBlankTab && (tabbrowser.mCurrentBrowser.currentURI.spec == "about:blank")) {
      // Don't open a new tab
      tabbrowser.mCurrentBrowser.loadURI('chrome://speeddial/content/speeddial.xul');
    } else {
      var selectedTab = tabbrowser.addTab('chrome://speeddial/content/speeddial.xul');
      tabbrowser.selectedTab = selectedTab;
      selectedTab.linkedBrowser.userTypedValue = undefined;
    }
      
    if (gURLBar)
      setTimeout(function() { gURLBar.focus(); }, 0);
  },

  backgroundLoadFinished: function(event) {
//alert("entering backgroundLoadFinished");
    var loaderBrowser = document.getElementById("speedDialLoaderBrowser");
    if (SpeedDial.currentPrioritySchedule > -1) {
      try {
        // Get the IOService so we can make URIs
        const ioService = Components.classes["@mozilla.org/network/io-service;1"].getService(Components.interfaces.nsIIOService);
        var origURI = ioService.newURI(loaderBrowser.contentDocument.documentURI, loaderBrowser.contentDocument.characterSet, null);

        if (origURI.spec.substr(0, "about:neterror".length) == "about:neterror") {
          if (SpeedDial.currentPrioritySchedule > 0) {
            if (SpeedDial.prefs.prefHasUserValue("extensions.speeddial.thumbnail-" + SpeedDial.currentPrioritySchedule + "-lastsaved")) {
              // Do nothing
            } else {
              // It's the first time we've loaded the page.. place some error information
              if (SpeedDial.prefs.prefHasUserValue("extensions.speeddial.thumbnail-" + SpeedDial.currentPrioritySchedule + "-dynamictitle") &&
                  SpeedDial.prefs.getBoolPref("extensions.speeddial.thumbnail-" + SpeedDial.currentPrioritySchedule + "-dynamictitle")) {
                var str = Components.classes["@mozilla.org/supports-string;1"].createInstance(Components.interfaces.nsISupportsString);
                str.data = loaderBrowser.contentDocument.title;
                SpeedDial.prefs.setComplexValue("extensions.speeddial.thumbnail-" + SpeedDial.currentPrioritySchedule + "-label", Components.interfaces.nsISupportsString, str);
              }
              // Show thumbnail of error
              SpeedDial.saveSnapshot(loaderBrowser, SpeedDial.currentPrioritySchedule);
            }
          } else {
            SpeedDial.thumbnailGenerationListeners[0].thumbnailLoadError();
          }
        } else {
          // Check if we've to get default icon
          if (!loaderBrowser.mIconURL && (SpeedDial.currentPrioritySchedule > 0) && !(loaderBrowser.contentDocument instanceof ImageDocument)) {
            if (("schemeIs" in loaderBrowser.currentURI) && (loaderBrowser.currentURI.schemeIs("http") || loaderBrowser.currentURI.schemeIs("https"))) {
              var url = loaderBrowser.currentURI.prePath + "/favicon.ico";
              SpeedDial.loadIcon(url, SpeedDial.currentPrioritySchedule);
            }
          }

          // Check if dynamic title...
          if ((SpeedDial.currentPrioritySchedule > 0) && SpeedDial.prefs.prefHasUserValue("extensions.speeddial.thumbnail-" + SpeedDial.currentPrioritySchedule + "-dynamictitle") &&
               SpeedDial.prefs.getBoolPref("extensions.speeddial.thumbnail-" + SpeedDial.currentPrioritySchedule + "-dynamictitle")) {
            var str = Components.classes["@mozilla.org/supports-string;1"].createInstance(Components.interfaces.nsISupportsString);
            str.data = loaderBrowser.contentDocument.title;
            SpeedDial.prefs.setComplexValue("extensions.speeddial.thumbnail-" + SpeedDial.currentPrioritySchedule + "-label", Components.interfaces.nsISupportsString, str);
          }

          SpeedDial.saveSnapshot(loaderBrowser, SpeedDial.currentPrioritySchedule);
          if (SpeedDial.currentPrioritySchedule == 0) {
            SpeedDial.thumbnailGenerationListeners[0].thumbnailLoadCompleted();
          }
        }

        SpeedDial.finishCurrentBackgroundLoad();
      } catch (e) {
        alert("backgroundLoadFinished: " + e);
      }
    }
//alert("exiting backgroundLoadFinished");
  },
  
  finishCurrentBackgroundLoad: function() {
//alert("entering finishCurrentBackgroundLoad");
    // Remove manual refresh preference if necessary
    if (SpeedDial.currentPrioritySchedule == 0) {
      SpeedDial.thumbnailGenerationListeners.shift();
      if (SpeedDial.thumbnailGenerationListeners.length > 0) {
        SpeedDial.processingPrioritySchedules = false;
        SpeedDial.processPrioritySchedules();
        return;
      }
    } else {
      if (SpeedDial.prefs.prefHasUserValue("extensions.speeddial.thumbnail-" + SpeedDial.currentPrioritySchedule + "-manualrefresh")) {
        SpeedDial.prefs.clearUserPref("extensions.speeddial.thumbnail-" + SpeedDial.currentPrioritySchedule + "-manualrefresh");
      }
    }
  
    SpeedDial.prioritySchedules.shift();
    SpeedDial.currentPrioritySchedule = -1;
    SpeedDial.processingPrioritySchedules = false;
    SpeedDial.processPrioritySchedules();
//alert("exiting finishCurrentBackgroundLoad");
  },

  checkWindow: function() {
    if (SpeedDial.isSchedulerWindow) return;

    var wm = Components.classes['@mozilla.org/appshell/window-mediator;1'].getService(Components.interfaces.nsIWindowMediator);
    var windowIter = wm.getEnumerator('navigator:browser');
   
    if (windowIter.hasMoreElements() && (window == windowIter.getNext())) {
      // We're the scheduler window now!
      setTimeout(SpeedDial.startScheduling, 0);
    }
  },

  startScheduling: function() {
    SpeedDial.isSchedulerWindow = true;
    
    // Add background browser
    var loaderBox = document.createElement("hbox");
    loaderBox.setAttribute("id", "speedDialLoaderBox");
    loaderBox.setAttribute("style", "overflow: hidden;");
    loaderBox.setAttribute("flex", "1");
    loaderBox.setAttribute("height", "0");
    loaderBox.setAttribute("maxheight", "0");
    loaderBox.setAttribute("minheight", "0");
    var loaderSubBox = document.createElement("vbox");
    loaderSubBox.setAttribute("id", "speedDialLoaderSubBox");
    loaderSubBox.setAttribute("flex", "0");
    loaderBox.appendChild(loaderSubBox);
    document.documentElement.appendChild(loaderBox);

    SpeedDial.scheduleTimer = Components.classes["@mozilla.org/timer;1"].createInstance(Components.interfaces.nsITimer);
    SpeedDial.prioritySchedules = new Array();
    SpeedDial.updateSchedules = new Array();
    
    setTimeout(SpeedDial.checkThumbnailRefreshing, 0);
  },

  stopScheduling: function() {
    SpeedDial.isSchedulerWindow = false;

    SpeedDial.unregisterBackgroundLoader();

    SpeedDial.scheduleTimer.cancel();
    SpeedDial.scheduleTimer = null;
  },

  checkThumbnailRefreshing: function() {
//alert("entering checkThumbnailRefreshing");
    // Cancel current updates
    SpeedDial.scheduleTimer.cancel();

    SpeedDial.updateSchedules.length = 0;

    // Determine update and priority schedules
    for (var c=1; c<=SpeedDial.speedDialSlots; c++) {
      if (SpeedDial.prefs.prefHasUserValue("extensions.speeddial.thumbnail-" + c + "-url")) {
        if (!SpeedDial.prefs.prefHasUserValue("extensions.speeddial.thumbnail-" + c + "-lastsaved") || SpeedDial.prefs.prefHasUserValue("extensions.speeddial.thumbnail-" + c + "-manualrefresh")) {
          SpeedDial.addPrioritySchedule(c);
        } else if (SpeedDial.prefs.prefHasUserValue("extensions.speeddial.thumbnail-" + c + "-refreshinterval")) {
          SpeedDial.updateSchedules.push(c);
        }
      }
    }
//alert("processed schedules: priority " + SpeedDial.prioritySchedules.length + ", updates " + SpeedDial.updateSchedules.length);

    if (SpeedDial.updateSchedules.length > 0) {
      // Calculate wait time
      var smallestWait = 0;
      var currentTime = (new Date()).getTime();
      
      for (var c=0; c<SpeedDial.updateSchedules.length; c++) {
        var lastSaved = parseInt(SpeedDial.prefs.getCharPref("extensions.speeddial.thumbnail-" + SpeedDial.updateSchedules[c] + "-lastsaved"));
        var currentWait = lastSaved + SpeedDial.prefs.getIntPref("extensions.speeddial.thumbnail-" + SpeedDial.updateSchedules[c] + "-refreshinterval") * 1000 - currentTime;
        
        if (currentWait < smallestWait) smallestWait = currentWait;
      }

      if (smallestWait < 100) smallestWait = 100;
//alert("smallestWait: " + smallestWait);
      SpeedDial.scheduleTimer.initWithCallback(SpeedDialTimerListener, smallestWait, Components.interfaces.nsITimer.TYPE_ONE_SHOT);
    }
//alert("exiting checkThumbnailRefreshing");
  },

  addPrioritySchedule: function(targetDial) {
    if (SpeedDial.prioritySchedules.indexOf(targetDial) < 0) {
      SpeedDial.prioritySchedules.push(targetDial);
      if (!SpeedDial.processingPrioritySchedules) {
        SpeedDial.processPrioritySchedules();
      }
    }
  },

  processPrioritySchedules: function() {
    if (SpeedDial.prioritySchedules.length > 0) {
      SpeedDial.currentPrioritySchedule = SpeedDial.prioritySchedules[0];
//alert("" + SpeedDial.prioritySchedules[0] + "," + SpeedDial.processingPrioritySchedules);
      if (!SpeedDial.processingPrioritySchedules) {
        SpeedDial.processingPrioritySchedules = true;
        SpeedDial.startBackgroundLoad();
      }
    } else {
      SpeedDial.processingPrioritySchedules = false;
    }
  },

  checkSchedule: function() {
     if (SpeedDial.updateSchedules.length < 1) return;

     // Find our target
     var smallestWait = 0;
     var currentTime = (new Date()).getTime();
     
     for (var c=0; c<SpeedDial.updateSchedules.length; c++) {
       var targetIndex = SpeedDial.updateSchedules[c];
       if (SpeedDial.prioritySchedules.indexOf(targetIndex) < 0) {
         if (SpeedDial.prefs.prefHasUserValue("extensions.speeddial.thumbnail-" + targetIndex + "-url")) {
           var lastSaved = 0;
           if (SpeedDial.prefs.prefHasUserValue("extensions.speeddial.thumbnail-" + targetIndex + "-lastsaved")) {
             lastSaved = parseInt(SpeedDial.prefs.getCharPref("extensions.speeddial.thumbnail-" + targetIndex + "-lastsaved"));
           }
           var currentWait = lastSaved + SpeedDial.prefs.getIntPref("extensions.speeddial.thumbnail-" + targetIndex + "-refreshinterval") * 1000 - currentTime;
           if (currentWait < 0) {
             SpeedDial.addPrioritySchedule(targetIndex);
           } else if (currentWait < smallestWait) {
             smallestWait = currentWait;
           }
         }
       }
     }

     if (smallestWait > 100) {
       SpeedDial.scheduleTimer.initWithCallback(SpeedDialTimerListener, smallestWait, Components.interfaces.nsITimer.TYPE_ONE_SHOT);
     } else {
       // Re-check again
       SpeedDial.scheduleTimer.initWithCallback(SpeedDialTimerListener, 100, Components.interfaces.nsITimer.TYPE_ONE_SHOT);
     }
  },

  isBackgroundLoaderBusy: function() {
    // TODO: implement multiple browsers to do parallel background loading... future feature
    // It should show it's busy when all parallel browsers are working
    return SpeedDial.processingPrioritySchedules;
  },

  SpeedDialIconLoadListener: function(channel, speedDial) {
    this.mChannel = channel;
    this.mData = "";
    this.mSpeedDial = speedDial;
  },

  showOptions: function() {
    var features;
    try {
      var prefs = Components.classes["@mozilla.org/preferences-service;1"]
                          .getService(Components.interfaces.nsIPrefBranch);
      var instantApply = prefs.getBoolPref("browser.preferences.instantApply");
      features = "chrome,titlebar,toolbar,centerscreen," + (instantApply ? "dialog=no" : "modal,resizable");
    } catch (e) {
      features = "chrome,titlebar,toolbar,centerscreen,modal,resizable";
    }
    openDialog("chrome://speeddial/content/settings/settings.xul", "", features);
  },


  log: function(msg) {
    var consoleService = Components.classes["@mozilla.org/consoleservice;1"]
                                 .getService(Components.interfaces.nsIConsoleService);
    consoleService.logStringMessage(msg);
  }
};

SpeedDial.SpeedDialIconLoadListener.prototype =
{
    mCountRead: null,
    mChannel: null,
    mBytes: Array (),
    mStream: null,
    mData: null,
    mSpeedDial: -1,
    
    QueryInterface: function (iid)
    {
        if (!iid.equals(Components.interfaces.nsISupports) &&
            !iid.equals(Components.interfaces.nsIInterfaceRequestor) &&
            !iid.equals(Components.interfaces.nsIRequestObserver) &&
            !iid.equals(Components.interfaces.nsIProgressEventSink) &&
            !iid.equals(Components.interfaces.nsIStreamListener)) {
          throw Components.results.NS_ERROR_NO_INTERFACE;
        }
        return this;
    },
    
    getInterface: function(iid)
    {
        return this.QueryInterface(iid);
    },
    
    onStartRequest: function (aRequest, aContext)
    {
        this.mStream = Components.classes['@mozilla.org/binaryinputstream;1'].createInstance(Components.interfaces.nsIBinaryInputStream);
    },
    
    onStopRequest: function (aRequest, aContext, aStatusCode)
    {
       this.mData = "data:" + this.mChannel.contentType + ";base64," + btoa(String.fromCharCode.apply(null, this.mBytes));
       SpeedDial.setSpeedDialIcon(this.mData, this.mSpeedDial);
       this. mChannel = null;
    },
    
    onDataAvailable: function (aRequest, aContext, aInputStream, aOffset, aCount)
    {
        this. mStream. setInputStream (aInputStream);
        var chunk = this. mStream. readByteArray (aCount);
        this. mBytes = this. mBytes. concat (chunk);
    },
    onProgress: function ( aRequest , aContext , aProgress , aProgressMax ) {},
    onStatus: function ( aRequest , aContext , aStatus , aStatusArg ) {}
}

var SpeedDialPrefObserver = 
{
  updateTimer: null,

  prefObserver : {
    observe: function(subject, topic, data) {
      // subject is the nsIPrefBranch we're observing (after appropriate QI)
      // data is the name of the pref that's been changed (relative to subject)
      if (topic == "nsPref:changed") {
        var updateThumbnailsNumber = false;
        
        if (data.indexOf("extensions.speeddial.thumbnail-") == 0) {
          // A thumbnail has been updated!
          if (SpeedDialPrefObserver.updateTimer == null) {
            SpeedDialPrefObserver.updateTimer = Components.classes["@mozilla.org/timer;1"].createInstance(Components.interfaces.nsITimer);
          }
          SpeedDialPrefObserver.updateTimer.cancel();
          SpeedDialPrefObserver.updateTimer.initWithCallback(SpeedDialPrefObserver.prefObserver, 100, Components.interfaces.nsITimer.TYPE_ONE_SHOT);
        } else {
          switch (data) {
            case "extensions.speeddial.loadInNewWindow":
              SpeedDial.loadInNewWindow = SpeedDial.prefs.getBoolPref("extensions.speeddial.loadInNewWindow");
              break;
            case "extensions.speeddial.loadInNewTab":
              SpeedDial.loadInNewTab = SpeedDial.prefs.getBoolPref("extensions.speeddial.loadInNewTab");
              break;
            case "extensions.speeddial.loadInLastTab":
              SpeedDial.loadInLastTab = SpeedDial.prefs.getBoolPref("extensions.speeddial.loadInLastTab");
              break;
            case "extensions.speeddial.clearURLBarOnLoad":
              SpeedDial.clearURLBarOnLoad = SpeedDial.prefs.getBoolPref("clearURLBarOnLoad");
              break;
            case "extensions.speeddial.showInTabContextMenu":
              SpeedDial.showInTabContextMenu = SpeedDial.prefs.getBoolPref("extensions.speeddial.showInTabContextMenu");
              document.getElementById("tabContextSpeedDial").hidden = !SpeedDial.showInTabContextMenu;
              break;
            case "extensions.speeddial.showInAreaContextMenu":
              SpeedDial.showInAreaContextMenu = SpeedDial.prefs.getBoolPref("extensions.speeddial.showInAreaContextMenu");
              document.getElementById("speeddialContext").hidden = !SpeedDial.showInAreaContextMenu;
              break;
            case "extensions.speeddial.showInBookmarksMenu":
              SpeedDial.showInBookmarksMenu = SpeedDial.prefs.getBoolPref("extensions.speeddial.showInBookmarksMenu");
              document.getElementById("speeddialBookmarksMenu").hidden = !SpeedDial.showInBookmarksMenu;
              break;
            case "extensions.speeddial.overrideCtrlNumber":
              SpeedDial.overrideCtrlNumber = SpeedDial.prefs.getBoolPref("extensions.speeddial.overrideCtrlNumber");

              window.removeEventListener("keypress", window.ctrlNumberTabSelection, false);

              if (SpeedDial.overrideCtrlNumber) {
                if (!window.originalCtrlNumberTabSelection)
                  window.originalCtrlNumberTabSelection = window.ctrlNumberTabSelection;
                window.ctrlNumberTabSelection = SpeedDial.ctrlNumberSpeedDial;
              } else {
                if (window.originalCtrlNumberTabSelection)
                  window.ctrlNumberTabSelection = window.originalCtrlNumberTabSelection;
              }

              window.addEventListener("keypress", window.ctrlNumberTabSelection, false);
              break;
            case "extensions.speeddial.defaultRefreshInterval":
              SpeedDial.defaultRefreshInterval = SpeedDial.prefs.getIntPref("extensions.speeddial.defaultRefreshInterval");
              break;
            case "extensions.speeddial.captureDelay":
              SpeedDial.captureDelay = SpeedDial.prefs.getIntPref("extensions.speeddial.captureDelay");
              break;
            case "extensions.speeddial.captureTimeout":
              SpeedDial.captureTimeout = SpeedDial.prefs.getIntPref("extensions.speeddial.captureTimeout");
              break;
            case "extensions.speeddial.disableBackgroundBrowserJavascript":
              SpeedDial.disableBackgroundBrowserJavascript = SpeedDial.prefs.getBoolPref("extensions.speeddial.disableBackgroundBrowserJavascript");
              break;
            case "extensions.speeddial.disableBackgroundBrowserPlugins":
              SpeedDial.disableBackgroundBrowserPlugins = SpeedDial.prefs.getBoolPref("extensions.speeddial.disableBackgroundBrowserPlugins");
              break;
            case "extensions.speeddial.disableBackgroundBrowserAuth":
              SpeedDial.disableBackgroundBrowserAuth = SpeedDial.prefs.getBoolPref("extensions.speeddial.disableBackgroundBrowserAuth");
              break;
            case "extensions.speeddial.columns":
              SpeedDial.speedDialColumns = SpeedDial.prefs.getIntPref("extensions.speeddial.columns");
              updateThumbnailsNumber = true;
              break;
            case "extensions.speeddial.rows":
              SpeedDial.speedDialRows = SpeedDial.prefs.getIntPref("extensions.speeddial.rows");
              updateThumbnailsNumber = true;
              break;
            case "extensions.speeddial.enableGroups":
              SpeedDial.enableGroups = SpeedDial.prefs.getBoolPref("extensions.speeddial.enableGroups");
              updateThumbnailsNumber = true;
              break;
            case "extensions.speeddial.numGroups":
              updateThumbnailsNumber = true;
              break;
            case "extensions.speeddial.popupOptionsAccess":
              SpeedDial.popupOptionsAccess = SpeedDial.prefs.getBoolPref("extensions.speeddial.popupOptionsAccess");
              break;
            case "extensions.speeddial.enableCache":
              SpeedDial.enableCache = SpeedDial.prefs.getBoolPref("extensions.speeddial.enableCache");
              break;
            case "extensions.speeddial.imageFormat":
              SpeedDial.imageFormat = SpeedDial.prefs.getCharPref("extensions.speeddial.imageFormat");
              break;
            case "extensions.speeddial.urlBarShortcuts":
              SpeedDial.urlBarShortcuts = SpeedDial.prefs.getCharPref("extensions.speeddial.urlBarShortcuts");
              break;
            case "extensions.speeddial.openExistingFirst":
              SpeedDial.openExistingFirst = SpeedDial.prefs.getBoolPref("extensions.speeddial.openExistingFirst");
              break;
            case "extensions.speeddial.openOnBlankTab":
              SpeedDial.openOnBlankTab = SpeedDial.prefs.getBoolPref("extensions.speeddial.openOnBlankTab");
              break;
            case "extensions.speeddial.useJava":
              SpeedDial.useJava = SpeedDial.prefs.getBoolPref("extensions.speeddial.useJava");
              break;
            case "extensions.speeddial.preScaling":
              SpeedDial.preScaling = SpeedDial.prefs.getBoolPref("extensions.speeddial.preScaling");
              break;
            case "extensions.speeddial.multikeyForSingleDigit":
              SpeedDial.multikeyForSingleDigit = SpeedDial.prefs.getBoolPref("extensions.speeddial.multikeyForSingleDigit");
              break;
            case "extensions.speeddial.multikeyOverlayWidthModifier":
              SpeedDial.multikeyOverlayWidthModifier = SpeedDial.prefs.getIntPref("extensions.speeddial.multikeyOverlayWidthModifier");
              break;
            case "extensions.speeddial.useKeyCapture":
              SpeedDial.useKeyCapture = SpeedDial.prefs.getBoolPref("extensions.speeddial.useKeyCapture");
              break;
          }
        }
        
        if (updateThumbnailsNumber) {
          if (SpeedDial.enableGroups) {
            SpeedDial.numGroups = SpeedDial.prefs.getIntPref("extensions.speeddial.numGroups");
          } else {
            SpeedDial.numGroups = 1;
          }
          SpeedDial.speedDialSlots = SpeedDial.speedDialRows * SpeedDial.speedDialColumns * SpeedDial.numGroups;
        }
      }
    },

    QueryInterface : function (aIID) {
      if (aIID.equals(Components.interfaces.nsIObserver) || 
      aIID.equals(Components.interfaces.nsITimerCallback) ||
      aIID.equals(Components.interfaces.nsISupports) ||
      aIID.equals(Components.interfaces.nsISupportsWeakReference))
        return this;
      throw Components.results.NS_NOINTERFACE;
    },

    notify: function(timer) {
      SpeedDial.checkThumbnailRefreshing();
    }
  },

  addPrefObserver : function () {
    if (!SpeedDial.prefs) return;
    SpeedDial.prefs.addObserver("extensions.speeddial.", SpeedDialPrefObserver.prefObserver, true);
  },

  removePrefObserver : function () {
    if (!SpeedDial.prefs) return;
    SpeedDial.prefs.removeObserver("extensions.speeddial.", SpeedDialPrefObserver.prefObserver);
  }
};

// Window close observer
var SpeedDialWindowObserver = {
  observe: function(subject,topic,data){
    switch(topic){
      case 'domwindowclosed':
        setTimeout(SpeedDial.checkWindow, 0);
        break;
    }
  }
};

// Thumbnail scheduler
var SpeedDialTimerListener = {
    QueryInterface : function (aIID) {
      if (aIID.equals(Components.interfaces.nsITimerCallback) ||
      aIID.equals(Components.interfaces.nsISupports) ||
      aIID.equals(Components.interfaces.nsISupportsWeakReference))
        return this;
      throw Components.results.NS_NOINTERFACE;
    },

    notify: function(timer) {
      if (!SpeedDial.isSchedulerWindow) return;

      SpeedDial.checkSchedule();
    }
};

var SpeedDialBackgroundBrowserListener =
{
  alreadyLoaded: false,
  firstLoadTime: -1,
  currentTimeoutId: -1,
  loadFinished: false,

  QueryInterface: function(aIID)
  {
   if (aIID.equals(Components.interfaces.nsIDOMEventListener) ||
       aIID.equals(Components.interfaces.nsISupportsWeakReference) ||
       aIID.equals(Components.interfaces.nsISupports))
     return this;
   throw Components.results.NS_NOINTERFACE;
  },

  handleEvent: function(event) {
    if (SpeedDialBackgroundBrowserListener.loadFinished) return;
    
  
    if ((event.type == "load") || (event.type == "pageshow")) {
      if (!SpeedDialBackgroundBrowserListener.alreadyLoaded) {
        if (event.currentTarget.contentDocument != event.originalTarget)
          return;
        SpeedDialBackgroundBrowserListener.alreadyLoaded = true;
        SpeedDialBackgroundBrowserListener.firstLoadTime = (new Date()).getTime();
      }
      SpeedDialBackgroundBrowserListener.resetTimer();
    } else if (event.type == "unload") {
      if (event.currentTarget.contentDocument == event.originalTarget) {
        SpeedDialBackgroundBrowserListener.alreadyLoaded = false;
        if (SpeedDialBackgroundBrowserListener.currentTimeoutId != -1) {
          clearTimeout(SpeedDialBackgroundBrowserListener.currentTimeoutId);
        }
        SpeedDialBackgroundBrowserListener.captureStarted();
      } else {
        SpeedDialBackgroundBrowserListener.resetTimer();
      }
    } else if (event.type == "DOMSubtreeModified") {
      if (SpeedDialBackgroundBrowserListener.alreadyLoaded) {
        SpeedDialBackgroundBrowserListener.resetTimer();
      }
    } else if (event.type == "DOMLinkAdded") {
      if (!event.originalTarget.rel.match((/(?:^|\s)icon(?:\s|$)/i)))
        return;

      // We have an icon.
      var href = event.originalTarget.href;
      if (!href)
        return;

      SpeedDial.backgroundIconLoaded(href);
    }
  },
  
  resetTimer: function() {
    if (SpeedDialBackgroundBrowserListener.currentTimeoutId != -1) {
      clearTimeout(SpeedDialBackgroundBrowserListener.currentTimeoutId);
    }
    if ((new Date()).getTime() > (SpeedDialBackgroundBrowserListener.firstLoadTime + SpeedDial.captureTimeout)) {
      // Just do it
      SpeedDialBackgroundBrowserListener.captureFinished();
    } else {
      SpeedDialBackgroundBrowserListener.currentTimeoutId = setTimeout(SpeedDialBackgroundBrowserListener.captureFinished, SpeedDial.captureDelay);
    }
  },
  
  captureStarted: function() {
    SpeedDialBackgroundBrowserListener.alreadyLoaded = false;
    SpeedDialBackgroundBrowserListener.loadFinished = false;
    SpeedDialBackgroundBrowserListener.firstLoadTime = (new Date()).getTime();
    SpeedDialBackgroundBrowserListener.currentTimeoutId = setTimeout(SpeedDialBackgroundBrowserListener.captureFinished, SpeedDial.captureTimeout);
  },
  
  captureFinished: function() {
    if (SpeedDialBackgroundBrowserListener.loadFinished) return;
    SpeedDialBackgroundBrowserListener.loadFinished = true;
    SpeedDial.backgroundLoadFinished();
  }
}


function SpeedDialTabListener(tab, eventCallback) {
  var _this = this;
  this.tab = tab;
  this.eventCallback = eventCallback;

  this.handleEvent = function(event) {
    _this.eventCallback(_this.tab);
    _this.tab.linkedBrowser.removeEventListener("pageshow", _this.handleEvent, false);
    _this.tab = null;
    _this.eventCallback = null;
    _this.handleEvent = null;
  }

  tab.linkedBrowser.addEventListener("pageshow", this.handleEvent, false);
}


window.addEventListener("load", function(e) { SpeedDial.init(); }, false);
window.addEventListener("unload", function(e) { SpeedDial.unload(); }, false);
