-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

with GNAT.OS_Lib;

package CMD
is
   Valid             : Boolean := False;

   All_Files         : Boolean := False; -- -a flag
   Verbose           : Boolean := False; -- -V flag
   Version_Requested : Boolean := False; -- -v flag

   Run_Simplifier    : Boolean := True; -- made False by -ns
   Run_Zombiescope   : Boolean := True; -- made False by -nz
   Run_Victor        : Boolean := False; -- made True by -victor

   Dry_Run           : Boolean := False; -- -n flag

   Log_Output        : Boolean := False; -- -l flag
   Echo_Output       : Boolean := False; -- -e flag
   Sort_VCGs         : Boolean := False; -- -t flag
   Reverse_Order     : Boolean := False; -- -r flag
   Processes         : Positive := 1;    -- -p=N flag

   -- References to strings for the binaries
   Simplifier_Exe_Switch  : GNAT.OS_Lib.String_Access := null;
   ZombieScope_Exe_Switch : GNAT.OS_Lib.String_Access := null;

   --  Returns the arguments in the "sargs" section of the command
   --  line.  The returned array has exactly the number of elements
   --  required.  The returned array can be null (i.e. no elements)
   SArgs : GNAT.OS_Lib.Argument_List_Access := null;

   -- Ditto for the "zargs" section
   ZArgs : GNAT.OS_Lib.Argument_List_Access := null;

   -- Ditto for the "vargs" section
   VArgs : GNAT.OS_Lib.Argument_List_Access := null;

   ------------------------------------------------
   -- Reads and parses the command line and sets --
   -- program-wide flags as appropriate.         --
   ------------------------------------------------
   procedure Process_Command_Line (Switch_Char : in Character);

   --------------------------------------------
   -- Print command name, options and brief  --
   -- description of each to Standard_Output --
   --------------------------------------------
   procedure Usage;

end CMD;
