-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

with Sparklalr_IO;
with Sparklalr_Common;
--# inherit Command_Line_Options,
--#         Sparklalr_Common,
--#         Sparklalr_Error,
--#         Sparklalr_IO,
--#         Sparklalr_Memory,
--#         Symbols_Dump;

package Sparklalr_Goto
--# own State;
is

   type Next_T is private;

   Next_False_Const : constant Next_T;

   procedure Initialise;
   --# global out State;
   --# derives State from ;

   function Goto_Search (State_Index, Non_Term_Index : in Integer) return Integer;
   --# global in State;

   procedure Go_Out (I : in Integer);
   --# global in out State;
   --# derives State from *,
   --#                    I;

   procedure Dump_Goto (F : in Sparklalr_IO.File_Type);
   --# global in     Sparklalr_Memory.Stat_No;
   --#        in     State;
   --#        in     Symbols_Dump.State;
   --#        in out Sparklalr_IO.Outputs;
   --# derives Sparklalr_IO.Outputs from *,
   --#                                   F,
   --#                                   Sparklalr_Memory.Stat_No,
   --#                                   State,
   --#                                   Symbols_Dump.State;

   procedure Goto_Gen
     (F                                      : in     Sparklalr_IO.File_Type;
      Insertion, State_Index, Non_Term_Index : in     Integer;
      Call_Pa_Insert                         :    out Boolean);
   --# global in     Command_Line_Options.State;
   --#        in     Symbols_Dump.State;
   --#        in out Sparklalr_Error.State;
   --#        in out Sparklalr_IO.Outputs;
   --#        in out State;
   --# derives Call_Pa_Insert        from Non_Term_Index &
   --#         Sparklalr_Error.State,
   --#         State                 from *,
   --#                                    Insertion,
   --#                                    Non_Term_Index,
   --#                                    State,
   --#                                    State_Index &
   --#         Sparklalr_IO.Outputs  from *,
   --#                                    Command_Line_Options.State,
   --#                                    F,
   --#                                    Insertion,
   --#                                    Non_Term_Index,
   --#                                    State,
   --#                                    State_Index,
   --#                                    Symbols_Dump.State;

   procedure Goto_Out (F : in Sparklalr_IO.File_Type);
   --# global in     Symbols_Dump.State;
   --#        in out Sparklalr_IO.Outputs;
   --#        in out State;
   --# derives Sparklalr_IO.Outputs from *,
   --#                                   F,
   --#                                   State,
   --#                                   Symbols_Dump.State &
   --#         State                from *,
   --#                                   Symbols_Dump.State;

   procedure Goto_Out_Sp (F : in Sparklalr_IO.File_Type);
   --# global in     Sparklalr_Memory.Stat_No;
   --#        in     Symbols_Dump.State;
   --#        in out Sparklalr_IO.Outputs;
   --#        in out State;
   --# derives Sparklalr_IO.Outputs from *,
   --#                                   F,
   --#                                   Sparklalr_Memory.Stat_No,
   --#                                   State,
   --#                                   Symbols_Dump.State &
   --#         State                from *,
   --#                                   Symbols_Dump.State;

   procedure Goto_Stats (F : in Sparklalr_IO.File_Type);
   --# global in     State;
   --#        in out Sparklalr_IO.Outputs;
   --# derives Sparklalr_IO.Outputs from *,
   --#                                   F,
   --#                                   State;

   procedure Init_Goto_List (I : in Sparklalr_Common.Non_Term_Range);
   --# global in out State;
   --# derives State from *,
   --#                    I;

   function Get_Goto_List_Count return Integer;
   --# global in State;

   function Get_Next (Next : in Next_T;
                      I    : in Sparklalr_Common.Term_Range) return Boolean;

   procedure Set_Next (Next  : in out Next_T;
                       I     : in     Sparklalr_Common.Term_Range;
                       Value : in     Boolean);
   --# derives Next from *,
   --#                   I,
   --#                   Value;

private

   type Next_T is array (Sparklalr_Common.Term_Range) of Boolean;

   Next_False_Const : constant Next_T := Next_T'(others => False);

end Sparklalr_Goto;
