-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

package body SPARK.Ada.Text_IO.Not_SPARK is
   --# hide SPARK.Ada.Text_IO.Not_SPARK;

   pragma Warnings ("Y"); -- Turn off warnings for Ada 2005 features

   function Name (File : File_Type) return String is
   begin
      return Standard.Ada.Text_IO.Name
        (File => Standard.Ada.Text_IO.File_Type (File));
   end Name;

   function Form (File : File_Type) return String is
   begin
      return Standard.Ada.Text_IO.Form
        (File => Standard.Ada.Text_IO.File_Type (File));
   end Form;

   procedure Set_Input (File : File_Type) is
   begin
      Standard.Ada.Text_IO.Set_Input
        (File => Standard.Ada.Text_IO.File_Type (File));
   end Set_Input;

   procedure Set_Output (File : File_Type) is
   begin
      Standard.Ada.Text_IO.Set_Output
        (File => Standard.Ada.Text_IO.File_Type (File));
   end Set_Output;

   procedure Set_Error (File : File_Type) is
   begin
      Standard.Ada.Text_IO.Set_Error
        (File => Standard.Ada.Text_IO.File_Type (File));
   end Set_Error;

   function Current_Input return File_Type is
      function Get_Current_Input return Standard.Ada.Text_IO.File_Type
        renames Standard.Ada.Text_IO.Current_Input;
   begin
      return File_Type (Get_Current_Input);
   end Current_Input;

   function Current_Output return File_Type is
      function Get_Current_Output return Standard.Ada.Text_IO.File_Type
        renames Standard.Ada.Text_IO.Current_Output;
   begin
      return File_Type (Get_Current_Output);
   end Current_Output;

   function Current_Error return File_Type is
      function Get_Current_Error return Standard.Ada.Text_IO.File_Type
        renames Standard.Ada.Text_IO.Current_Error;
   begin
      return File_Type (Get_Current_Error);
   end Current_Error;

   function Standard_Input return File_Access is
      function Get_Standard_Input return Standard.Ada.Text_IO.File_Access
        renames Standard.Ada.Text_IO.Standard_Input;
   begin
      return File_Access (Get_Standard_Input);
   end Standard_Input;

   function Standard_Output return File_Access is
      function Get_Standard_Output return Standard.Ada.Text_IO.File_Access
        renames Standard.Ada.Text_IO.Standard_Output;
   begin
      return File_Access (Get_Standard_Output);
   end Standard_Output;

   function Standard_Error return File_Access is
      function Get_Standard_Error return Standard.Ada.Text_IO.File_Access
        renames Standard.Ada.Text_IO.Standard_Error;
   begin
      return File_Access (Get_Standard_Error);
   end Standard_Error;

   function Current_Input return File_Access is
      function Get_Current_Input return Standard.Ada.Text_IO.File_Access
        renames Standard.Ada.Text_IO.Current_Input;
   begin
      return File_Access (Get_Current_Input);
   end Current_Input;

   function Current_Output return File_Access is
      function Get_Current_Output return Standard.Ada.Text_IO.File_Access
        renames Standard.Ada.Text_IO.Current_Output;
   begin
      return File_Access (Get_Current_Output);
   end Current_Output;

   function Current_Error return File_Access is
      function Get_Current_Error return Standard.Ada.Text_IO.File_Access
        renames Standard.Ada.Text_IO.Current_Error;
   begin
      return File_Access (Get_Current_Error);
   end Current_Error;

   function Get_Line (File : File_Type) return String is
   begin
      return Standard.Ada.Text_IO.Get_Line
        (File => Standard.Ada.Text_IO.File_Type (File));
   end Get_Line;

   function Get_Line return String is
   begin
      return Standard.Ada.Text_IO.Get_Line;
   end Get_Line;

   ------------------------------------------------
   -- Conversion functions from SPARK.Ada to Ada --
   ------------------------------------------------

   function To_File_Type
     (From : File_Type) return Standard.Ada.Text_IO.File_Type is
   begin
      return Standard.Ada.Text_IO.File_Type (From);
   end To_File_Type;

   function To_File_Mode
     (From : File_Mode) return Standard.Ada.Text_IO.File_Mode is
   begin
      case From is
         when In_File =>
            return Standard.Ada.Text_IO.In_File;
         when Out_File =>
            return Standard.Ada.Text_IO.Out_File;
         when Append_File =>
            return Standard.Ada.Text_IO.Append_File;
      end case;
   end To_File_Mode;

   function To_Type_Set
     (From : Type_Set) return Standard.Ada.Text_IO.Type_Set is
   begin
      case From is
         when Lower_Case =>
            return Standard.Ada.Text_IO.Lower_Case;
         when Upper_Case =>
            return Standard.Ada.Text_IO.Upper_Case;
      end case;
   end To_Type_Set;

end SPARK.Ada.Text_IO.Not_SPARK;
