-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Sem.CompUnit)
package body Stack
--# own State is S, TopPtr;
is
   subtype IndexRange is Integer range 1 .. ExaminerConstants.WfCompilationUnitStackMax;
   type StackArray is array (IndexRange) of Boolean;
   subtype TopRange is Integer range 0 .. ExaminerConstants.WfCompilationUnitStackMax;

   S      : StackArray;
   TopPtr : TopRange;

   procedure Init
   --# global out S;
   --#        out TopPtr;
   --# derives S,
   --#         TopPtr from ;
   is
   begin
      TopPtr := 0;
      S      := StackArray'(1      => False,
                            others => False);
   end Init;

   procedure Push (X : in Boolean)
   --# global in out S;
   --#        in out TopPtr;
   --# derives S      from *,
   --#                     TopPtr,
   --#                     X &
   --#         TopPtr from *;
   is
   begin
      if TopPtr < ExaminerConstants.WfCompilationUnitStackMax then
         TopPtr     := TopPtr + 1;
         S (TopPtr) := X;
      else
         SystemErrors.Fatal_Error (Sys_Err => SystemErrors.Wf_Compilation_Unit_Stack_Overflow,
                                   Msg     => "");
      end if;
   end Push;

   -- return of Item removed, it is never used, pop just clears a stack item
   procedure Pop
   --# global in out TopPtr;
   --# derives TopPtr from *;
   is
   begin
      if TopPtr > 0 then
         TopPtr := TopPtr - 1;
      else
         -- stack underflow raises system error
         SystemErrors.Fatal_Error (Sys_Err => SystemErrors.Wf_Compilation_Unit_Stack_Underflow,
                                   Msg     => "");
      end if;
   end Pop;

   function Top return Boolean
   --# global in S;
   --#        in TopPtr;
   is
   begin
      --# accept Flow, 10, "Expected ineffective assignment to TopPtr";
      if TopPtr = 0 then
         --# end accept;
         SystemErrors.Fatal_Error (Sys_Err => SystemErrors.Wf_Compilation_Unit_Stack_Underflow,
                                   Msg     => "");
      end if;
      return S (TopPtr);
   end Top;

end Stack;
