-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Dictionary)
procedure AddGenericAssociation
  (SubprogramOrPackage : in Symbol;
   Comp_Unit           : in ContextManager.UnitDescriptors;
   Declaration         : in Location;
   FormalSym           : in Symbol;
   ActualSym           : in Symbol) is
   TheAssociation : Symbol;
   Previous       : Symbol;

begin -- AddGenericAssociation
   RawDict.CreateGenericAssociation
     (Formal       => FormalSym,
      ActualSymbol => ActualSym,
      Comp_Unit    => Comp_Unit,
      Loc          => Declaration.Start_Position,
      Association  => TheAssociation);

   if IsPackage (SubprogramOrPackage) then
      null;
      -- dictionary doesn't currently support generic parameters for packages --GenericTBD
   else -- assume subprogram
      Previous := RawDict.GetSubprogramLastGenericAssociation (SubprogramOrPackage);
      if Previous = NullSymbol then
         RawDict.SetSubprogramFirstGenericAssociation (SubprogramOrPackage, TheAssociation);
      else
         RawDict.SetNextGenericAssociation (Previous, TheAssociation);
      end if;
      RawDict.SetSubprogramLastGenericAssociation (SubprogramOrPackage, TheAssociation);
   end if;
end AddGenericAssociation;
