

#ifndef OUTPUTDIRECTORY_H
#define OUTPUTDIRECTORY_H

#include <qwidget.h>
#include <kprocess.h>

class FileListItem;

class Config;
class KComboBox;
class KLineEdit;
class KToolBarButton;

/**
 * @short The input area for the output directory
 * @author Daniel Faust <hessijames@gmail.com>
 * @version 0.3
 */
class OutputDirectory : public QWidget
{
    Q_OBJECT
public:
    enum Mode {
//         Default,
        MetaData,
        Source,
        Specify,
        CopyStructure
    };

    /**
     * Constructor
     */
    OutputDirectory( Config*, QWidget* parent = 0, const char* name = 0 );

    Mode mode();
    void setMode( Mode );
    QString directory();
    void setDirectory( const QString& );

    static QString calcPath( FileListItem* fileListItem, Config* config, QString extension = "" );
    static QString changeExtension( const QString& filename, const QString& extension );
    static QString uniqueFileName( const QString& filename );
    static QString makePath( const QString& path );
    static QString vfatPath( const QString& path );

    /**
     * Destructor
     */
    virtual ~OutputDirectory();

public slots:
    //void setActive( bool );
    void enable();
    void disable();

private slots:
    void modeChangedSlot( int );
    void directoryChangedSlot( const QString& );
    void selectDir();
    void gotoDir();
    //void modeInfo();
    //void dirInfo();
    //void savePaths();

private:
    KComboBox* cMode;
    //KToolBarButton* pModeInfo;
    KLineEdit* lDir;
    KToolBarButton* pDirSelect;
    KToolBarButton* pDirGoto;
    //KToolBarButton* pDirInfo;
    KToolBarButton* pClear;

    bool modeJustChanged;

    KProcess kfm;

    Config* config;

/*    QString sharedDirPath;
    QString metadataPath;
    QString copyStructurePath;
*/
signals:
    void modeChanged( OutputDirectory::Mode );
    void directoryChanged( const QString& );
};

#endif // OUTPUTDIRECTORY_H
