

#include "soundkonverterapp.h"

#include "tplugins.h"

#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>

static const char description[] =
    I18N_NOOP("soundKonverter is a frontend to various sound en- and decoding programs.");

static const char version[] = "0.3.6";

static KCmdLineOptions options[] =
{
    { "replaygain", I18N_NOOP("Open the Replay Gain tool an add all given files"), 0 },
//     { "repair", I18N_NOOP("Open the repair files tool an add all given files"), 0 },
    { "rip <device>", I18N_NOOP("List all tracks on the cd drive <device>, 'auto' will search for a cd"), 0 },
    { "profile <profile>", I18N_NOOP("Add all files using the given profile"), 0 },
    { "format <format>", I18N_NOOP("Add all files using the given format"), 0 },
    { "output <directory>", I18N_NOOP("Output all files to <directory>"), 0 },
    { "invisible", I18N_NOOP("Start soundKonverter invisible"), 0 },
    { "autoclose", I18N_NOOP("Close soundKonverter after all files are converted (enabled when using '--invisible')"), 0 },
    { "command <command>", I18N_NOOP("Execute <command> after each file has been converted"), 0 },
    { "+[files]", I18N_NOOP("Audio file(s) to append to the file list"), 0 },
    KCmdLineLastOption
};

int main(int argc, char **argv)
{
    KAboutData about("soundkonverter", I18N_NOOP("soundKonverter"), version, description,
        KAboutData::License_GPL, "(C) 2007 Daniel Faust", 0, 0, "hessijames@gmail.com");
    about.addAuthor( "Daniel Faust", 0, "hessijames@gmail.com" );
    about.addCredit( "David Vignoni", "Nuvola icon theme", 0, "http://www.icon-king.com" );
    about.addCredit( "Scott Wheeler", "TagLib", "wheeler@kde.org", "http://ktown.kde.org/~wheeler" );
    about.addCredit( "Amarok developers", "Amarok", 0, "http://amarok.kde.org" );
    about.addCredit( "Kaffeine developers", "Kaffeine", 0, "http://kaffeine.sourceforge.net" );
    about.addCredit( "All programmers of audioconverters", "Backends" );
    KCmdLineArgs::init(argc, argv, &about);
    KCmdLineArgs::addCmdLineOptions( options );

    soundKonverterApp::addCmdLineOptions();
    if( !soundKonverterApp::start() ) {
        return 0;
    }

    soundKonverterApp app;

    registerTaglibPlugins();

    // mainWin has WDestructiveClose flag by default, so it will delete itself.
    return app.exec();
}

/*
new strings:
"There are new plugin updates available.\nClick on this button in order to open the configuration dialog."

methods and files to update:
outputdirectory.cpp: vfatPath( const QString& path )
metadata/
cddb.cpp, cddb.h
cdmanager.cpp, cdmanager.h


audio/x-musepack;application/x-musepack;audio/musepack;application/musepack;
application/x-ape;audio/ape;audio/x-ape;
audio/x-mp3;application/x-id3;audio/mpeg;audio/x-mpeg;audio/x-mpeg-3;audio/mpeg3;audio/mp3;audio/x-mp3;application/x-id3;audio/mpeg;audio/x-mpeg;audio/x-mpeg-3;audio/mpeg3;audio/mp3;
audio/mp4;audio/x-m4a;audio/x-m4a;
audio/mpc;audio/x-mpc;audio/mp;audio/x-mp;audio/mpc;audio/x-mpc;audio/mp;audio/x-mp;
application/ogg;application/x-ogg;application/x-vorbis+ogg;audio/x-vorbis+ogg;audio/vorbis;audio/x-vorbis;audio/ogg;audio/x-ogg;application/ogg;application/x-ogg;audio/vorbis;audio/x-vorbis;audio/ogg;audio/x-ogg;
audio/x-flac;application/x-flac;audio/flac;audio/x-flac;application/x-flac;audio/flac;
audio/x-s3m;audio/x-mod;audio/x-xm;audio/x-it;audio/x-s3m;audio/x-mod;audio/x-xm;audio/x-it

*/

