
#include "dirdialog.h"
#include "config.h"

#include <qlayout.h>
#include <qlabel.h>
#include <qdir.h>
#include <qcheckbox.h>

#include <klocale.h>
#include <kiconloader.h>
#include <klineedit.h>
#include <kpushbutton.h>
// #include <kurlrequester.h>
#include <klistbox.h>
#include <kfiledialog.h>

DirDialog::DirDialog( Config* config, Mode mode, QWidget *parent, const char *name, bool modal, WFlags f )
    : KDialog( parent, name, modal, f )
{
    // create an icon loader object for loading icons
    KIconLoader* iconLoader = new KIconLoader();

    setCaption( i18n("Add folder") );
    resize( 400, 235 );
    setIcon( iconLoader->loadIcon("folder_open",KIcon::Small) );

    QGridLayout* grid = new QGridLayout( this, 4, 1, 11, 6 );

    QHBoxLayout* directoryBox = new QHBoxLayout();
    grid->addLayout( directoryBox, 0, 0 );

    QLabel* labelDirectory = new QLabel( i18n("Directory:"), this, "labelDirectory" );
    directoryBox->addWidget( labelDirectory );

//     uDirectory = new KURLRequester( this, "uDirectory" );
//     uDirectory->setMode( KFile::Directory | KFile::ExistingOnly | KFile::LocalOnly );
//     uDirectory->setURL( QDir::homeDirPath() );
//     directoryBox->addWidget( uDirectory );

    lDirectory = new KLineEdit( this, "lDirectory" );
    directoryBox->addWidget( lDirectory );

    pDirectory = new KPushButton( iconLoader->loadIcon("folder_open",KIcon::Small), "", this, "pDirectory" );
    directoryBox->addWidget( pDirectory );
    connect( pDirectory, SIGNAL(clicked()),
               this, SLOT(selectDirectoryClicked())
             );

    QHBoxLayout* fileTypesBox = new QHBoxLayout();
    grid->addLayout( fileTypesBox, 1, 0 );

    fileTypes = new KListBox( this, "fileTypes" );
    if( mode == Convert ) fileTypes->insertStringList( config->fileTypes() );
    else if( mode == ReplayGain ) fileTypes->insertStringList( config->replayGainFileTypes() );
    fileTypes->setSelectionMode( QListBox::Multi );
    for( int i = 0; i < fileTypes->count(); i++ ) fileTypes->setSelected( i, true );
    fileTypesBox->addWidget( fileTypes );

    QVBoxLayout* fileTypesButtonsBox = new QVBoxLayout();
    fileTypesBox->addLayout( fileTypesButtonsBox );

    pSelectAll = new KPushButton( iconLoader->loadIcon("font",KIcon::Small), i18n("Select all"), this, "pSelectAll" );
    fileTypesButtonsBox->addWidget( pSelectAll );
    connect( pSelectAll, SIGNAL(clicked()),
               this, SLOT(selectAllClicked())
             );

    pSelectNone = new KPushButton( iconLoader->loadIcon("empty",KIcon::Small), i18n("Select none"), this, "pSelectNone" );
    fileTypesButtonsBox->addWidget( pSelectNone );
    connect( pSelectNone, SIGNAL(clicked()),
               this, SLOT(selectNoneClicked())
             );

    cRecursive = new QCheckBox( i18n("Recursive"), this, "cRecursive" );
    cRecursive->setChecked( true );
    recursive = true;
    fileTypesButtonsBox->addWidget( cRecursive );
    connect( cRecursive, SIGNAL(toggled(bool)),
             this, SLOT(recursiveToggled(bool))
           );

    fileTypesButtonsBox->addStretch();

    QHBoxLayout* buttonBox = new QHBoxLayout();
    grid->addLayout( buttonBox, 2, 0 );

    pOk = new KPushButton( iconLoader->loadIcon("folder_open",KIcon::Small), i18n("Open"), this, "pOk" );
    buttonBox->addWidget( pOk );
    connect( pOk, SIGNAL(clicked()),
               this, SLOT(okClicked())
             );

    buttonBox->addStretch();

    pCancel = new KPushButton( iconLoader->loadIcon("cancel",KIcon::Small),i18n("Cancel"), this, "pCancel" );
    pOk->setFocus();
    buttonBox->addWidget( pCancel );
    connect( pCancel, SIGNAL(clicked()),
               this, SLOT(reject())
             );

    // delete the icon loader object
    delete iconLoader;

    QString directory = KFileDialog::getExistingDirectory( ":file_open", this, i18n("Choose a directory") );
    if( !directory.isEmpty() )
    {
        lDirectory->setText( directory );
    }
    else
    {
        lDirectory->setText( QDir::homeDirPath() );
    }
}

DirDialog::~DirDialog()
{}

void DirDialog::okClicked()
{
    selectedFileTypes.clear();
    for( int i = 0; i < fileTypes->count(); i++ ) {
        if( fileTypes->isSelected(i) ) selectedFileTypes += QStringList::split(", ",fileTypes->text(i));
    }
    directory = lDirectory->text();

    emit accept();
}

void DirDialog::selectDirectoryClicked()
{
    QString directory = KFileDialog::getExistingDirectory( lDirectory->text(), this, i18n("Choose a directory") );
    if( !directory.isEmpty() )
    {
        lDirectory->setText( directory );
    }
}

void DirDialog::selectAllClicked()
{
    for( int i = 0; i < fileTypes->count(); i++ ) fileTypes->setSelected( i, true );
}

void DirDialog::selectNoneClicked()
{
    for( int i = 0; i < fileTypes->count(); i++ ) fileTypes->setSelected( i, false );
}

void DirDialog::recursiveToggled( bool checked )
{
    recursive = checked;
}

