# Solfege - free ear training software
# Copyright (C) 2007 Tom Cato Amundsen
# License is GPL, see file COPYING


import unittest
import mpd

class TestClefs(unittest.TestCase):
    def test_raise_on_bad_clef(self):
        for clef in ('XX', ):
            def f():
                score = mpd.parser.parse_to_score_object(r"\staff{ \clef %s c' }" % clef)
                score.get_engravers(20)
            self.assertRaises(mpd.parser.UnknownClefException, f)
    def test_clefs(self):
        testdata =        [('violin', 6),
                           ('treble', 6),
                           ('G', 6),
                           ('G2', 6),
                           ('alto', 0),
                           ('C', 0),
                           ('tenor', -2),
                           ('bass', -6),
                           ('french', 8),
                           ('soprano', 4),
                           ('mezzosoprano', 2),
                           ('baritone', -4),
                           ('varbaritone', -4),
                           ('subbass', -8),
                           ]
        testdata = testdata + [('"%s"' % c, i) for (c, i) in testdata]
        testdata.extend([
            ('"violin_8"', 6 - 7),
            ('"violin_15"', 6 - 14),
            ('"G^8"', 6 + 7),
            ('"G^15"', 6 + 14),
        ])
        for clef, ypos in testdata:
            score = mpd.parser.parse_to_score_object(r"\staff{ \clef %s c' }" % clef)
            eng = score.get_engravers(20)
            e = [e for e in eng[0] if isinstance(e, mpd.engravers.NoteheadEngraver)][0]
            self.assertEquals(e.m_ypos, ypos, "c' after %s clef is placed wrong" % clef)

suite = unittest.makeSuite(TestClefs)

