#include <stdint.h>

typedef void ThumbInstructionProc(void);
extern ThumbInstructionProc **thumbIProcTab;

#define THUMB_INSTR_INDEX(icode) ((uint16_t)(icode))

static inline ThumbInstructionProc *
ThumbInstructionProc_Find(uint16_t icode) {
        ThumbInstructionProc *proc=thumbIProcTab[THUMB_INSTR_INDEX(icode)];
        return proc;
}

typedef struct ThumbInstruction {
        uint16_t mask;
        uint16_t value;
        char *name;
        ThumbInstructionProc *proc;
        struct ThumbInstruction *next;
} ThumbInstruction;

void ThumbDecoder_New();
